/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.ide.ui.internal.util.KeyStrokeUtil;
import com.ibm.team.filesystem.ui.changes.RenameChangeSetUtil;
import com.ibm.team.filesystem.ui.changes.RenameRemoteActivityComment;
import com.ibm.team.filesystem.ui.changes.views.CommentComposite;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.scm.common.links.ChangeSetLocationFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class CommentTextListener
implements Listener,
IContentProposalListener2 {
    private static final String UNICODE_LINE_SEPARATOR = "\u2028";
    private static final String PLATFORM_LINE_SEPARATOR = System.getProperty("line.separator") == null ? "\n" : System.getProperty("line.separator");
    private CommentComposite commentComposite;
    private CommentTextListenerInput input;
    private boolean popupIsOpened;
    private LinkedList<String> mruComments;
    private ContentProposalAdapter contentProposal;
    private RenameRemoteActivityComment rename;
    private static TextContentAdapter TEXT_ADAPTER = new TextContentAdapter();

    public CommentTextListener(CommentComposite commentComposite, RenameRemoteActivityComment rename, CommentTextListenerInput input) {
        this.commentComposite = commentComposite;
        this.input = input;
        this.popupIsOpened = false;
        this.mruComments = RenameChangeSetUtil.loadMruComments();
        this.rename = rename;
        commentComposite.getTextControl().addListener(16, (Listener)this);
        commentComposite.getTextControl().addListener(31, (Listener)this);
        commentComposite.getTextControl().addListener(24, (Listener)this);
        commentComposite.getTextControl().addListener(1, (Listener)this);
    }

    public void setContentProposal(ContentProposalAdapter contentProposal) {
        if (this.contentProposal != null) {
            this.contentProposal.removeContentProposalListener((IContentProposalListener2)this);
        }
        this.contentProposal = contentProposal;
        this.contentProposal.addContentProposalListener((IContentProposalListener2)this);
    }

    public LinkedList<String> getMruComments() {
        return this.mruComments;
    }

    public void handleEvent(Event e) {
        switch (e.type) {
            case 24: {
                String text = this.commentComposite.getText();
                text = text.replace(UNICODE_LINE_SEPARATOR, PLATFORM_LINE_SEPARATOR);
                this.input.getLabelProvider().editChangeSet(text);
                this.input.getTreeViewer().update((Object[])this.rename.getRemoteActivities(), null);
                int height = this.commentComposite.getHeightHint();
                if (height != this.input.getTreeEditor().minimumHeight) {
                    this.input.getTreeEditor().minimumHeight = height;
                    this.input.getTreeEditor().layout();
                }
                this.commentComposite.notifyListeners(e.type, e);
                break;
            }
            case 16: {
                if (this.popupIsOpened) {
                    this.commentComposite.notifyListeners(e.type, e);
                    break;
                }
                this.saveTask();
                break;
            }
            case 31: {
                switch (e.detail) {
                    case 4: {
                        if (this.popupIsOpened) {
                            this.commentComposite.notifyListeners(e.type, e);
                            break;
                        }
                        if ((e.stateMask & 0x40000) == 262144) break;
                        this.saveTask();
                        e.doit = false;
                        break;
                    }
                    case 2: {
                        if (this.popupIsOpened) {
                            this.commentComposite.notifyListeners(e.type, e);
                            break;
                        }
                        this.endEdit();
                        e.doit = false;
                        this.input.getTreeViewer().update((Object[])this.rename.getRemoteActivities(), null);
                    }
                }
                break;
            }
            case 1: {
                if (this.popupIsOpened && (e.stateMask & 0x40000) == 262144 && e.keyCode == 13) break;
                this.commentComposite.notifyListeners(e.type, e);
            }
        }
    }

    private void endEdit() {
        this.input.endTextEdit(this.commentComposite.getTextControl());
        this.commentComposite.dispose();
        this.commentComposite = null;
        this.input.setFocus();
    }

    private void saveTask() {
        String newComment = this.commentComposite.getText();
        newComment = newComment.replace(UNICODE_LINE_SEPARATOR, PLATFORM_LINE_SEPARATOR);
        this.endEdit();
        RenameChangeSetUtil.updateMruComments(newComment);
        this.rename.saveTask(newComment);
    }

    public void proposalPopupClosed(ContentProposalAdapter adapter) {
        this.popupIsOpened = false;
        this.commentComposite.setInfoText(CommentComposite.POPUP_CLOSED_INFO);
        if (!this.commentComposite.getTextControl().isFocusControl()) {
            this.saveTask();
        }
    }

    public void proposalPopupOpened(ContentProposalAdapter adapter) {
        this.popupIsOpened = true;
        this.commentComposite.setInfoText(CommentComposite.POPUP_OPENED_INFO);
    }

    public static void addContentPropsalAdapter(final CommentComposite commentComposite, CommentTextListener textListener) {
        KeyStroke keyStroke = KeyStrokeUtil.getContentProposalKeyStroke();
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)commentComposite, CommentTextListener.getControlContentAdapter(), CommentTextListener.getProposalProvider(textListener.getMruComments()), keyStroke, null);
        adapter.setProposalAcceptanceStyle(2);
        textListener.setContentProposal(adapter);
        commentComposite.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                commentComposite.resize();
            }
        });
    }

    private static IContentProposalProvider getProposalProvider(final List<String> comments) {
        return new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                contents = contents.trim();
                ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>(comments.size());
                for (String comment : comments) {
                    String commentTrimmed = comment.trim();
                    if (commentTrimmed.length() <= contents.length() || !commentTrimmed.substring(0, contents.length()).equalsIgnoreCase(contents)) continue;
                    proposals.add(this.newProposal(comment));
                }
                if (proposals.size() == 0) {
                    for (String comment : comments) {
                        proposals.add(this.newProposal(comment));
                    }
                }
                return proposals.toArray(new IContentProposal[proposals.size()]);
            }

            private IContentProposal newProposal(final String comment) {
                return new IContentProposal(){

                    public String getContent() {
                        return comment;
                    }

                    public int getCursorPosition() {
                        return comment.length();
                    }

                    public String getDescription() {
                        return null;
                    }

                    public String getLabel() {
                        return ChangeSetLocationFactory.replaceLineEnding((String)comment, (String)" ");
                    }
                };
            }
        };
    }

    private static IControlContentAdapter getControlContentAdapter() {
        return new IControlContentAdapter(){

            public String getControlContents(Control arg0) {
                return TEXT_ADAPTER.getControlContents((Control)((CommentComposite)arg0).getTextControl());
            }

            public int getCursorPosition(Control arg0) {
                return TEXT_ADAPTER.getCursorPosition((Control)((CommentComposite)arg0).getTextControl());
            }

            public Rectangle getInsertionBounds(Control arg0) {
                return TEXT_ADAPTER.getInsertionBounds((Control)((CommentComposite)arg0).getTextControl());
            }

            public void insertControlContents(Control arg0, String arg1, int arg2) {
                TEXT_ADAPTER.insertControlContents((Control)((CommentComposite)arg0).getTextControl(), arg1, arg2);
            }

            public void setControlContents(Control arg0, String arg1, int arg2) {
                TEXT_ADAPTER.setControlContents((Control)((CommentComposite)arg0).getTextControl(), arg1, arg2);
            }

            public void setCursorPosition(Control arg0, int arg1) {
                TEXT_ADAPTER.setCursorPosition((Control)((CommentComposite)arg0).getTextControl(), arg1);
            }
        };
    }

    public static interface CommentTextListenerInput {
        public LocalWorkspaceChangesViewLabelProvider getLabelProvider();

        public TreeViewer getTreeViewer();

        public TreeEditor getTreeEditor();

        public boolean setFocus();

        public void endTextEdit(Text var1);
    }
}

