/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.ide.ui.internal.util.KeyStrokeUtil;
import com.ibm.team.filesystem.ui.changes.RenameChangeSetUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.scm.common.IChangeSet;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CommentComposite
extends Composite {
    private static final boolean IS_MAC = System.getProperty("os.name") == null ? false : System.getProperty("os.name").toLowerCase().contains("mac");
    public static String POPUP_CLOSED_INFO = NLS.bind((String)Messages.LocalWorkspaceChangesView_37, (Object[])new Object[]{KeyStrokeUtil.getContentProposalKeyStroke().format(), KeyStroke.getInstance((int)13).format(), KeyStroke.getInstance((int)(IS_MAC ? SWT.MOD4 : SWT.MOD1), (int)13).format()});
    public static String POPUP_OPENED_INFO = NLS.bind((String)Messages.LocalWorkspaceChangesView_38, (Object[])new Object[]{KeyStroke.getInstance((int)27).format(), KeyStroke.getInstance((int)13).format(), KeyStroke.getInstance((int)(IS_MAC ? SWT.MOD4 : SWT.MOD1), (int)13).format()});
    private Text text;
    private Label separator;
    private Label infoLabel;
    private static final int INSET = 1;
    private boolean adjust = false;

    public CommentComposite(Composite parent, String firstComment) {
        super(parent, 0);
        this.setBackground(parent.getDisplay().getSystemColor(2));
        boolean spacing = false;
        GridLayoutFactory.fillDefaults().margins(1, 1).spacing(0, 0).applyTo((Composite)this);
        this.text = new Text((Composite)this, 66);
        this.text.setText(firstComment);
        this.text.setTextLimit((int)IChangeSet.ITEM_TYPE.getMaxSize(IChangeSet.COMMENT_PROPERTY));
        this.text.selectAll();
        this.text.setFocus();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.text);
        this.separator = new Label((Composite)this, 259);
        this.separator.setBackground(this.text.getBackground());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.separator);
        this.infoLabel = new Label((Composite)this, 131072);
        this.infoLabel.setText(POPUP_CLOSED_INFO);
        this.shrinkInfoFont();
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.infoLabel);
        this.infoLabel.setBackground(this.text.getBackground());
    }

    private void shrinkInfoFont() {
        Font font = this.infoLabel.getFont();
        FontData[] fontDatas = font.getFontData();
        int i = 0;
        while (i < fontDatas.length) {
            fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
            ++i;
        }
        final Font infoFont = new Font((Device)this.infoLabel.getDisplay(), fontDatas);
        this.infoLabel.setFont(infoFont);
        this.infoLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                infoFont.dispose();
            }
        });
    }

    public Text getTextControl() {
        return this.text;
    }

    public String getText() {
        return this.text.getText();
    }

    public int getHeightHint() {
        int width = this.text.getClientArea().width - 2;
        int newTextHeight = RenameChangeSetUtil.computeTextHeight(this.text, width);
        return newTextHeight + 2 + this.separator.getSize().y + this.infoLabel.getSize().y;
    }

    public void setBounds(Rectangle rect) {
        if (this.getParent().getClientArea().width > this.getParent().getSize().x && !this.adjust) {
            this.adjust = true;
            rect.width -= 17;
            super.setBounds(rect);
            this.adjust = false;
            return;
        }
        super.setBounds(rect);
    }

    public void resize() {
        Rectangle rect = this.getBounds();
        rect.height = this.getHeightHint();
        this.setBounds(rect);
        this.adjust = false;
        this.text.setBounds(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
    }

    public void setInfoText(String text) {
        this.infoLabel.setText(text);
    }
}

