/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Trace;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.UserLockCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.UserLockDelegate;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.OfflineManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.outofsync.OutOfSyncCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.outofsync.OutOfSyncCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.rcp.core.patches.IPatchModelChangeEvent;
import com.ibm.team.filesystem.rcp.core.patches.IPatchModelChangeListener;
import com.ibm.team.filesystem.rcp.core.patches.Patch;
import com.ibm.team.filesystem.rcp.core.patches.PatchModel;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.RenameChangeSetUtil;
import com.ibm.team.filesystem.ui.changes.RenameRemoteActivityComment;
import com.ibm.team.filesystem.ui.changes.actions.OpenConflictInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenConflictInExternalCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenShareableInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenShareableInExternalCompareAction;
import com.ibm.team.filesystem.ui.changes.configuration.ChangesSorter;
import com.ibm.team.filesystem.ui.changes.configuration.LocalConfiguration;
import com.ibm.team.filesystem.ui.changes.dialogs.ConflictsPromptManager;
import com.ibm.team.filesystem.ui.changes.views.Actions;
import com.ibm.team.filesystem.ui.changes.views.ChangesDragTargetAdapter;
import com.ibm.team.filesystem.ui.changes.views.ChangesDropTargetAdapter;
import com.ibm.team.filesystem.ui.changes.views.CommentComposite;
import com.ibm.team.filesystem.ui.changes.views.CommentTextListener;
import com.ibm.team.filesystem.ui.changes.views.InaccessibleWorkspaceInformationBarUtil;
import com.ibm.team.filesystem.ui.changes.views.InternalConvertingSelectionProvider;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewContentProvider;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.filesystem.ui.changes.views.OutOfSyncInformationBarUtil;
import com.ibm.team.filesystem.ui.changes.views.ZoomBookmark;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.IZoomWorkItemRoot;
import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewerTooltipSupport;
import com.ibm.team.internal.filesystem.ui.util.MenuUtil;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.openactions.IWorkbenchRunnable;
import com.ibm.team.repository.rcp.ui.openactions.OpenAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

public class ChangesViewPage
extends Composite
implements IListener {
    public static final String JAZZ_WORKITEM_TYPE = "jazz_workitem";
    private Actions actions;
    protected LocalWorkspaceChangesView viewPart;
    protected Tree tree;
    protected LocalWorkspaceChangesViewLabelProvider labelProvider;
    protected LocalSynchronizeDecorator labelDecorator;
    private LocalWorkspaceChangesViewContentProvider contentProvider = null;
    protected TreeViewer viewer;
    protected LocalConfiguration localConfiguration;
    private TreeEditor editor;
    private TreeItem lastEditItem;
    private boolean alreadyRenaming = false;
    private boolean activeSelection = false;
    private Runnable renameChangeRunnable = new Runnable(){

        @Override
        public void run() {
            TreeItem item = null;
            if (ChangesViewPage.this.tree != null && !ChangesViewPage.this.tree.isDisposed()) {
                TreeItem[] items;
                if (ChangesViewPage.this.lastEditItem != null && !ChangesViewPage.this.lastEditItem.isDisposed()) {
                    items = new TreeItem[]{ChangesViewPage.this.lastEditItem};
                    ChangesViewPage.this.textEdit(items);
                }
                item = (items = ChangesViewPage.this.tree.getSelection()) != null && items.length == 1 ? items[0] : null;
            }
            ChangesViewPage.this.alreadyRenaming = false;
            ChangesViewPage.this.lastEditItem = item == ChangesViewPage.this.lastEditItem ? null : item;
        }
    };
    private IStructuredSelection lastSelection = null;
    private IPropertyChangeListener propertyChangeListener;
    private volatile UIJob refreshUIJob;
    private UserLockDelegate fDelegate;
    private IPatchModelChangeListener patchModelListener = new IPatchModelChangeListener(){

        public void handleChanges(IPatchModelChangeEvent[] events) {
            if (events.length == 0) {
                return;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ChangesViewPage.this.isDisposed()) {
                        (this).ChangesViewPage.this.viewPart.checkActivePage();
                        ChangesViewPage.refresh((this).ChangesViewPage.this.viewer);
                    }
                }
            });
        }
    };
    private static final Log log = LoggingHelper.getLog(ChangesViewPage.class);

    public ChangesViewPage(Composite parent, LocalWorkspaceChangesView viewPart) {
        super(parent, 0);
        this.viewPart = viewPart;
        this.actions = viewPart.getActions();
        this.setLayout((Layout)new FillLayout());
        parent.addListener(12, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                ChangesViewPage.this.dispose();
            }
        });
        this.initViewer();
        this.fDelegate = new UserLockDelegate((IListener)this);
    }

    protected void initViewer() {
        this.labelProvider = new LocalWorkspaceChangesViewLabelProvider(true);
        this.labelDecorator = new LocalSynchronizeDecorator(true);
        this.tree = new Tree((Composite)this, 66306);
        this.viewer = new CustomTreeViewer(this.tree);
        ((CustomTreeViewer)this.viewer).init(new DecoratingLabelProvider((ILabelProvider)this.labelProvider, (ILabelDecorator)this.labelDecorator));
        this.viewer.setUseHashlookup(true);
        this.localConfiguration = new LocalConfiguration((IViewPart)this.viewPart, this.viewer);
        ((CustomTreeViewer)this.viewer).setLocalConfiguration(this.localConfiguration);
        this.contentProvider = new LocalWorkspaceChangesViewContentProvider(this.localConfiguration);
        this.viewPart.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setSorter((ViewerSorter)new ChangesSorter());
    }

    public void init() {
        this.editor = new TreeEditor(this.tree);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item;
                TreeItem[] items = ChangesViewPage.this.tree.getSelection();
                TreeItem treeItem = item = items.length == 1 ? items[0] : null;
                if (item != null && item == ChangesViewPage.this.lastEditItem) {
                    Object element = item.getData();
                    if (RenameChangeSetUtil.allowRename(element) == 0) {
                        int time = e.display.getDoubleClickTime() * 3 / 2;
                        ChangesViewPage.this.alreadyRenaming = true;
                        e.display.timerExec(time, ChangesViewPage.this.renameChangeRunnable);
                    }
                } else {
                    ChangesViewPage.this.lastEditItem = ChangesViewPage.this.alreadyRenaming ? null : item;
                    ChangesViewPage.this.alreadyRenaming = false;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                e.display.timerExec(-1, ChangesViewPage.this.renameChangeRunnable);
            }
        });
        this.tree.addListener(16, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                event.display.timerExec(-1, ChangesViewPage.this.renameChangeRunnable);
            }
        });
        this.tree.addListener(35, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                event.display.timerExec(-1, ChangesViewPage.this.renameChangeRunnable);
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && selection instanceof StructuredSelection) {
                    IFileSystemWorkItem workItem;
                    StructuredSelection ss = (StructuredSelection)selection;
                    Object o = ss.getFirstElement();
                    boolean shouldUseExternalTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(ss);
                    if (o instanceof ILocalChange) {
                        ILocalChange change = (ILocalChange)o;
                        if (!OpenShareableInCompareAction.isOpenable(change)) {
                            return;
                        }
                        if (shouldUseExternalTool) {
                            OpenShareableInExternalCompareAction action = new OpenShareableInExternalCompareAction();
                            action.run(ChangesViewPage.this.viewPart.getSite().getShell(), ChangesViewPage.this.viewPart.getSite().getPage(), (IStructuredSelection)ChangesViewPage.this.viewer.getSelection());
                        } else {
                            OpenShareableInCompareAction action = new OpenShareableInCompareAction(ChangesViewPage.this.viewPart.getSite().getPage(), ChangesViewPage.this.viewer.getSelection());
                            action.run();
                        }
                        return;
                    }
                    if (o instanceof IAbstractConflictItem) {
                        if (!OpenConflictInCompareAction.isOpenable((IAbstractConflictItem)o)) {
                            return;
                        }
                        if (shouldUseExternalTool) {
                            OpenConflictInExternalCompareAction action = new OpenConflictInExternalCompareAction();
                            action.run(ChangesViewPage.this.viewPart.getSite().getShell(), ChangesViewPage.this.viewPart.getSite().getPage(), (IStructuredSelection)ChangesViewPage.this.viewer.getSelection());
                        } else {
                            OpenConflictInCompareAction action = new OpenConflictInCompareAction(ChangesViewPage.this.viewPart.getSite().getPage(), (IStructuredSelection)ChangesViewPage.this.viewer.getSelection());
                            action.run();
                        }
                        return;
                    }
                    if (o instanceof IRemoteChangeSummary) {
                        IRemoteChangeSummary change = (IRemoteChangeSummary)o;
                        if (!OpenInCompareAction.isOpenable(change)) {
                            return;
                        }
                        if (shouldUseExternalTool) {
                            OpenInExternalCompareAction action = new OpenInExternalCompareAction();
                            action.run(ChangesViewPage.this.viewPart.getSite().getShell(), ChangesViewPage.this.viewPart.getSite().getPage(), (IStructuredSelection)ChangesViewPage.this.viewer.getSelection());
                        } else {
                            OpenInCompareAction action = new OpenInCompareAction(ChangesViewPage.this.viewPart.getSite().getPage(), ChangesViewPage.this.viewer.getSelection());
                            action.run();
                        }
                        return;
                    }
                    if (o instanceof IFileSystemWorkItem && (o = (workItem = (IFileSystemWorkItem)o).getWorkItem()) == null) {
                        return;
                    }
                    IWorkbenchRunnable genericOpenAction = OpenAction.getActionFor((Object)o);
                    if (genericOpenAction != null) {
                        genericOpenAction.run(ChangesViewPage.this.viewPart.getSite().getShell(), ChangesViewPage.this.viewPart.getSite().getPage(), (IStructuredSelection)new StructuredSelection(o));
                        return;
                    }
                    if (ChangesViewPage.this.viewer.getExpandedState(o)) {
                        ChangesViewPage.this.viewer.collapseToLevel(o, -1);
                    } else {
                        ChangesViewPage.this.viewer.expandToLevel(o, 1);
                        Object element = ChangesSorter.findFirstChange(ChangesViewPage.this.viewer, o, null, true);
                        if (element != null) {
                            ChangesViewPage.this.viewer.reveal(element);
                        }
                    }
                }
            }
        });
        this.addDragSupport(this.viewer);
        this.addDropSupport(this.viewer);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ChangesViewPage.this.viewer.getSelection();
                ChangesViewPage.this.lastSelection = selection;
                ChangesViewPage.this.actions.setActionsEnabledState(selection);
                if (UiPlugin.getBooleanPreference("SHOW_ALL_OCCURRENCES")) {
                    ChangesViewPage.this.localConfiguration.updateSelection(selection);
                }
                String message = null;
                if (ChangesViewPage.this.lastSelection != null) {
                    int size = ChangesViewPage.this.lastSelection.size();
                    message = size == 1 ? LocalConfiguration.getDescription(ChangesViewPage.this.lastSelection.getFirstElement(), false) : NLS.bind((String)Messages.LocalWorkspaceChangesView_34, (Object)size);
                }
                ChangesViewPage.this.viewPart.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
                if (!ChangesViewPage.this.activeSelection) {
                    ChangesViewPage.this.viewPart.setActiveSelection(selection);
                }
            }
        });
        MenuManager contextMenuManager = this.actions.createContextMenuManager(this.viewPart, this.viewer);
        final Menu menu = contextMenuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.viewPart.getViewSite().registerContextMenu(contextMenuManager, (ISelectionProvider)new InternalConvertingSelectionProvider((ISelectionProvider)this.viewer));
        this.viewPart.getViewSite().registerContextMenu(contextMenuManager, (ISelectionProvider)this.viewer);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem menuItem = ChangesViewPage.this.getDefaultMenuItem(menu, ChangesViewPage.this.lastSelection);
                if (menuItem != null && !menuItem.isEnabled()) {
                    menuItem = null;
                }
                menu.setDefaultItem(menuItem);
            }
        });
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.actions.copyAction);
        this.viewPart.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.actions.copyAction.selectionChanged((IStructuredSelection)this.viewer.getSelection());
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (UiPlugin.isChangeProperty(event.getProperty())) {
                        ChangesViewPage.this.viewer.refresh();
                        ChangesViewPage.this.actions.setActionsEnabledState((IStructuredSelection)ChangesViewPage.this.viewer.getSelection());
                        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
                        String description = LocalConfiguration.getModelDescriptionPendingStyle(model);
                        ChangesViewPage.this.viewPart.setContentDescription(description);
                    }
                }
            };
            UiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        }
        this.refreshUIJob = new UIJob(Messages.LocalWorkspaceChangesView_36){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                long start = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
                ChangesViewPage.trace(String.valueOf(((Object)((Object)this)).getClass().getName()) + ":" + this.getName());
                if (ChangesViewPage.this.viewer != null && !ChangesViewPage.this.viewer.getTree().isDisposed()) {
                    IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
                    if (ChangesViewPage.this.viewer.getInput() != model) {
                        ChangesViewPage.this.viewer.setInput((Object)model);
                        if (ChangesViewPage.this.viewer.getSelection().isEmpty()) {
                            ChangesViewPage.this.viewer.expandToLevel(4);
                        }
                    } else {
                        if (ChangesViewPage.this.viewPart.isFlatMode() && !Boolean.getBoolean("com.ibm.team.filesystem.ide.ui.doNotExpandBaselinesInWorkItemZoomMode")) {
                            ZoomBookmark bookmark = ChangesViewPage.this.viewPart.getBookmark();
                            if (bookmark.equals((Object)ZoomBookmark.INCOMING_WORKITEM)) {
                                ComponentBaselineUtil.expandBaselines((ComponentBaselineUtil.BaselineDirection)ComponentBaselineUtil.BaselineDirection.INCOMING);
                            } else if (bookmark.equals((Object)ZoomBookmark.OUTGOING_WORKITEM)) {
                                ComponentBaselineUtil.expandBaselines((ComponentBaselineUtil.BaselineDirection)ComponentBaselineUtil.BaselineDirection.OUTGOING);
                            }
                        }
                        ChangesViewPage.refresh(ChangesViewPage.this.viewer);
                    }
                    ChangesViewPage.this.actions.setActionsEnabledState(ChangesViewPage.this.lastSelection);
                    String description = LocalConfiguration.getModelDescriptionPendingStyle(model);
                    ChangesViewPage.this.viewPart.setContentDescription(description);
                    if (ChangesViewPage.this.lastSelection != null && ChangesViewPage.this.lastSelection.size() == 1) {
                        String message = LocalConfiguration.getDescription(ChangesViewPage.this.lastSelection.getFirstElement(), false);
                        ChangesViewPage.this.viewPart.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
                    }
                    Image titleImage = ChangesViewPage.this.localConfiguration.getTitleImage(model);
                    ChangesViewPage.this.viewPart.setTitleImage(titleImage);
                }
                if (Trace.LOG_ELAPSED_TIME) {
                    Trace.endTrace((long)start, (String)(String.valueOf(((Object)((Object)this)).getClass().getName()) + ":" + this.getName()));
                }
                return Status.OK_STATUS;
            }
        };
        new CustomTreeViewerTooltipSupport((CustomTreeViewer)this.viewer, true, true){

            protected void hoverToolTipOpened() {
                ChangesViewPage.this.viewPart.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.RENAME.getId(), null);
                ChangesViewPage.this.viewPart.getViewSite().getActionBars().updateActionBars();
                Object element = this.getElement();
                if (element instanceof IFileSystemWorkItem || element instanceof IRemoteActivity) {
                    this.setOpenable(true);
                } else {
                    this.setOpenable(false);
                }
            }

            protected void openRequested(Object element) {
                if (element instanceof IFileSystemWorkItem) {
                    IFileSystemWorkItem workItemNode = (IFileSystemWorkItem)element;
                    IAuditable workItem = workItemNode.getWorkItem();
                    this.openWorkItem(workItem.getItemHandle());
                } else if (element instanceof IRemoteActivity) {
                    IRemoteActivity changeSetNode = (IRemoteActivity)element;
                    for (IFileSystemWorkItem fileSystemWorkItem : changeSetNode.getWorkItems()) {
                        this.openWorkItem(fileSystemWorkItem.getWorkItemHandle());
                    }
                }
            }

            private void openWorkItem(Object itemHandle) {
                IWorkbenchPage page = ChangesViewPage.this.viewPart.getViewSite().getPage();
                IEditorInput editorInput = (IEditorInput)Platform.getAdapterManager().loadAdapter(itemHandle, IEditorInput.class.getName());
                if (editorInput != null) {
                    try {
                        IWorkbench workbench = page.getWorkbenchWindow().getWorkbench();
                        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
                        IEditorDescriptor defaultEditor = editorRegistry.getDefaultEditor(ChangesViewPage.JAZZ_WORKITEM_TYPE);
                        String editorId = defaultEditor.getId();
                        boolean activate = OpenStrategy.activateOnOpen();
                        IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)editorId, (boolean)activate);
                    }
                    catch (PartInitException e) {
                        IStatus errorStatus = StatusUtil.newStatus((Object)"com.ibm.team.filesystem.ide.ui", (Throwable)e);
                        StatusUtil.log((IStatus)errorStatus);
                    }
                }
            }

            protected void hoverToolTipClosed() {
                if (!ChangesViewPage.this.tree.isDisposed()) {
                    ChangesViewPage.this.viewPart.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)((ChangesViewPage)ChangesViewPage.this).actions.renameChangeAction);
                    ChangesViewPage.this.viewPart.getViewSite().getActionBars().updateActionBars();
                }
            }

            protected Object doResolve(Object element) {
                IDomainAdapter adapter = DomainAdapterUtils.getDomainAdapter((Object)element);
                if (adapter == null) {
                    if (element instanceof IModelAccessor) {
                        return ((IModelAccessor)element).getModelInstance();
                    }
                    return null;
                }
                return super.doResolve(element);
            }
        };
        this.hookInput();
    }

    public boolean setFocus() {
        return this.tree.setFocus();
    }

    public void dispose() {
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        model.removeGenericListener((IListener)this);
        PatchModel.getDefault().removeChangeListener(this.patchModelListener);
        FileSystemResourcesPlugin.getActiveWorkspaceManager().removeGenericListener((Object)"activeWorkspaces", (IListener)this);
        FileSystemResourcesPlugin.getActiveWorkspaceManager().removeGenericListener((Object)"untrackedWorkspaces", (IListener)this);
        TeamPlatform.getTeamRepositoryService().removeGenericListener((Object)"repositories", (IListener)this);
        OfflineManager.getInstance().removeGenericListener((Object)"unreachableDescriptors", (IListener)this);
        OfflineManager.getInstance().removeGenericListener((Object)"unreachableWorkspaces", (IListener)this);
        UserLockCache.get().removeGenericListener((Object)"lock", (IListener)this);
        OutOfSyncCache.get().removeGenericListener((Object)"out_of_sync", (IListener)this);
        PortsCacheManager.getInstance().removeGenericListener((Object)"PORTS_CACHE_UPDATED", (IListener)this);
        if (this.propertyChangeListener != null) {
            UiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        }
        this.propertyChangeListener = null;
        if (this.localConfiguration != null) {
            this.localConfiguration.dispose();
        }
        this.localConfiguration = null;
        this.refreshUIJob = null;
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.actions.copyAction);
        this.viewer = null;
        this.labelDecorator = null;
        this.labelProvider = null;
        this.renameChangeRunnable = null;
        this.lastSelection = null;
        this.actions = null;
        this.fDelegate.dispose();
        super.dispose();
    }

    public void textEdit() {
        TreeItem[] items = this.tree.getSelection();
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                return;
            }
            ++i;
        }
        this.textEdit(items);
    }

    private void textEdit(TreeItem[] items) {
        RenameRemoteActivityComment rename = RenameRemoteActivityComment.create((Item[])items, (ColumnViewer)this.viewer, this.viewPart.getSite());
        if (rename == null) {
            return;
        }
        TreeItem firstItem = items[0];
        if (firstItem != null) {
            String firstComment = rename.getFirstComment();
            CommentComposite commentComposite = new CommentComposite((Composite)this.tree, firstComment);
            this.viewPart.getTextActionHandler().addText(commentComposite.getTextControl());
            this.editor.grabHorizontal = true;
            this.editor.grabVertical = true;
            this.editor.horizontalAlignment = 16384;
            this.editor.verticalAlignment = 128;
            CommentTextListener textListener = new CommentTextListener(commentComposite, rename, new CommentTextListener.CommentTextListenerInput(){

                @Override
                public boolean setFocus() {
                    return ChangesViewPage.this.setFocus();
                }

                @Override
                public TreeViewer getTreeViewer() {
                    return ChangesViewPage.this.getViewer();
                }

                @Override
                public TreeEditor getTreeEditor() {
                    return ChangesViewPage.this.getTreeEditor();
                }

                @Override
                public LocalWorkspaceChangesViewLabelProvider getLabelProvider() {
                    return ChangesViewPage.this.getLabelProvider();
                }

                @Override
                public void endTextEdit(Text text) {
                    ChangesViewPage.this.endTextEdit(text);
                }
            });
            CommentTextListener.addContentPropsalAdapter(commentComposite, textListener);
            this.viewPart.deactivateHandlers();
            this.editor.setEditor((Control)commentComposite, firstItem);
            this.labelProvider.beginEditChangeSet(rename.getRemoteActivities(), firstComment);
        }
    }

    protected void endTextEdit(Text textControl) {
        this.viewPart.getTextActionHandler().removeText(textControl);
        this.getLabelProvider().endEditChangeSet();
        this.viewPart.activateHandlers();
    }

    private void addDragSupport(TreeViewer viewer) {
        viewer.addDragSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new ChangesDragTargetAdapter((Object)this, viewer));
    }

    private void addDropSupport(TreeViewer viewer) {
        viewer.addDropSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ChangesDropTargetAdapter(viewer));
    }

    private MenuItem getDefaultMenuItem(Menu menu, IStructuredSelection selection) {
        if (selection == null || selection.size() != 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(selection);
        if (o instanceof ILocalChange) {
            if (useExternalCompareTool) {
                return MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.OpenShareableInExternalCompareAction");
            }
            return MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.OpenAction");
        }
        if (o instanceof IRemoteChangeSummary) {
            if (useExternalCompareTool) {
                return MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction");
            }
            return MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.OpenAction");
        }
        if (o instanceof IAbstractConflictItem) {
            if (useExternalCompareTool) {
                return MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.OpenConflictInExternalCompareAction");
            }
            return MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.conflict.OpenAction");
        }
        if (o instanceof IFileSystemWorkItem || o instanceof IZoomWorkItemRoot) {
            return MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.OpenAction");
        }
        return null;
    }

    private static void refresh(TreeViewer viewer) {
        if (!viewer.getTree().isDisposed()) {
            long start = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
            Object[] expandedElements = viewer.getExpandedElements();
            viewer.refresh();
            ArrayList<Object> toExpand = new ArrayList<Object>();
            Object[] objectArray = expandedElements;
            int n = expandedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof Patch) {
                    Patch patch = (Patch)element;
                    Patch np = patch.getModel().getPatch(patch.getId());
                    if (np != null) {
                        toExpand.add(np);
                    }
                } else {
                    toExpand.add(element);
                }
                ++n2;
            }
            viewer.setExpandedElements(toExpand.toArray());
            if (Trace.LOG_ELAPSED_TIME) {
                Trace.endTrace((long)start, (String)"ChangesViewPage.refresh()");
            }
        }
    }

    public void show(IRemoteActivity activity) {
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)activity), true);
    }

    public void hookInput() {
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        model.addGenericListener((IListener)this);
        PatchModel.getDefault().addChangeListener(this.patchModelListener);
        FileSystemResourcesPlugin.getActiveWorkspaceManager().addGenericListener((Object)"activeWorkspaces", (IListener)this);
        FileSystemResourcesPlugin.getActiveWorkspaceManager().addGenericListener((Object)"untrackedWorkspaces", (IListener)this);
        TeamPlatform.getTeamRepositoryService().addGenericListener((Object)"repositories", (IListener)this);
        OfflineManager.getInstance().addGenericListener((Object)"unreachableDescriptors", (IListener)this);
        OfflineManager.getInstance().addGenericListener((Object)"unreachableWorkspaces", (IListener)this);
        OfflineManager.getInstance().requestUpdate();
        UserLockCache.get().addGenericListener((Object)"lock", (IListener)this);
        OutOfSyncCacheManager.init();
        OutOfSyncCache.get().addGenericListener((Object)"out_of_sync", (IListener)this);
        PortsCacheManager.getInstance().addGenericListener((Object)"PORTS_CACHE_UPDATED", (IListener)this);
        this.viewer.setInput((Object)model);
        this.viewer.expandToLevel(2);
        this.actions.setActionsEnabledState(null);
        String description = LocalConfiguration.getModelDescriptionPendingStyle(model);
        this.viewPart.setContentDescription(description);
        ConflictsPromptManager.getInstance();
        this.viewPart.checkActivePage();
    }

    public void handleEvents(List events) {
        IActiveWorkspaceManager awm = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        IEvent event = (IEvent)events.get(0);
        ChangesViewPage.trace(String.format("%s.handleEvents() got event, type=%s, source=%s", ((Object)((Object)this)).getClass().getSimpleName(), event.getEventType(), event.getEventSource()));
        if (event.getEventSource() == awm) {
            this.viewPart.checkActivePage();
            return;
        }
        if (event.getEventType() == "unreachableDescriptors") {
            this.viewPart.checkActivePage();
        }
        if (event.getEventType() == "unreachableWorkspaces") {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ChangesViewPage.this.isDisposed()) {
                        InaccessibleWorkspaceInformationBarUtil.updateBar(ChangesViewPage.this.viewPart);
                    }
                }
            });
        }
        if (event.getEventType() == "out_of_sync") {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ChangesViewPage.this.isDisposed()) {
                        OutOfSyncInformationBarUtil.updateBar(ChangesViewPage.this.viewPart);
                    }
                }
            });
        }
        long delay = 0L;
        if (event instanceof IPropertyChangeEvent) {
            if (((IPropertyChangeEvent)event).getProperty() == "repositories") {
                this.viewPart.checkActivePage();
            } else if (((IPropertyChangeEvent)event).getProperty() == "user_locks") {
                ChangesViewPage.trace("ChangesViewPage.handleEvents() got property change event for USER_LOCKS*******");
                delay = 2000L;
            } else {
                ChangesViewPage.trace(String.format("ChangesViewPage.handleEvents() got property change event for %s*******", ((IPropertyChangeEvent)event).getProperty()));
            }
        } else if (event.getEventType().equals("lock")) {
            ChangesViewPage.trace(String.format("ChangesViewPage.handleEvents() got event of type %s*******", ((Event)event).getEventType()));
        }
        UIJob job = this.refreshUIJob;
        if (job != null) {
            ChangesViewPage.trace(String.format("ChangesViewPage.handleEvents() scheduling event for refreshUIJob in %d msec", delay));
            job.schedule(delay);
        }
    }

    public void cancelRenameChange() {
        this.lastEditItem = null;
        this.tree.getDisplay().timerExec(-1, this.renameChangeRunnable);
    }

    public boolean showChangesPage() {
        if (FileSystemResourcesPlugin.getActiveWorkspaceManager().getActiveWorkspaces().length != 0) {
            return true;
        }
        if (!PatchModel.getDefault().isEmpty()) {
            return true;
        }
        return UiPlugin.getBooleanPreference("com.ibm.team.filesystem.ide.ui.prefs_show_with_no_changes") && !OfflineManager.getInstance().getUnreachableDescriptors().isEmpty();
    }

    public void expandToChanges() {
        if (this.actions.expandToChangesAction != null) {
            this.actions.expandToChangesAction.run();
        }
    }

    public void setSelection(IStructuredSelection selection) {
        this.activeSelection = selection == this.viewPart.getActiveSelection();
        this.viewer.setSelection((ISelection)selection, true);
        this.activeSelection = false;
        Tree tree = this.viewer.getTree();
        TreeItem[] items = tree.getSelection();
        int i = 1;
        while (i < items.length) {
            TreeItem item = items[i];
            TreeItem parent = item.getParentItem();
            while (parent != null) {
                parent.setExpanded(true);
                parent = parent.getParentItem();
            }
            ++i;
        }
    }

    public void showContentChanges(Collection<Patch> contentChanges) {
        IStructuredSelection ss;
        Object first;
        PatchModel pendingPatchesNode = PatchModel.getDefault();
        this.viewer.setExpandedState((Object)pendingPatchesNode, true);
        ArrayList<Patch> contentChangeList = new ArrayList<Patch>();
        contentChangeList.addAll(contentChanges);
        StructuredSelection selection = new StructuredSelection(contentChangeList);
        this.viewer.setSelection((ISelection)selection, true);
        ISelection sel = this.viewer.getSelection();
        boolean correctSelection = false;
        if (sel instanceof IStructuredSelection && (first = (ss = (IStructuredSelection)sel).getFirstElement()) != null && contentChangeList.contains(first)) {
            correctSelection = true;
        }
        if (!correctSelection) {
            this.viewer.reveal((Object)pendingPatchesNode);
        }
    }

    public LocalWorkspaceChangesViewLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public LocalSynchronizeDecorator getLabelDecorator() {
        return this.labelDecorator;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public LocalConfiguration getLocalConfiguration() {
        return this.localConfiguration;
    }

    public LocalWorkspaceChangesViewContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public TreeEditor getTreeEditor() {
        return this.editor;
    }

    public TreeItem getLastEditItem() {
        return this.lastEditItem;
    }

    public boolean getAlreadyRenaming() {
        return this.alreadyRenaming;
    }

    public Runnable getRenameChangeRunnable() {
        return this.renameChangeRunnable;
    }

    public Tree getTree() {
        return this.tree;
    }

    public IStructuredSelection getLastSelection() {
        return this.lastSelection;
    }

    private static void trace(String message) {
        if (log != null && log.isTraceEnabled()) {
            log.trace((Object)message);
        }
    }
}

