/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IResumeOperation;
import com.ibm.team.filesystem.client.operations.IShareOperation;
import com.ibm.team.filesystem.client.operations.ISuspendOperation;
import com.ibm.team.filesystem.client.operations.ResumeDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.WorkspaceUpdateUtil;
import com.ibm.team.filesystem.ui.actions.AssociateChangeSetChangeRequestAction;
import com.ibm.team.filesystem.ui.changes.actions.CheckIntoChangeSetAction;
import com.ibm.team.filesystem.ui.changes.actions.DeliverAction;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.internal.filesystem.ui.util.WarnResumeUser;
import com.ibm.team.internal.filesystem.ui.util.WarnShareUser;
import com.ibm.team.internal.filesystem.ui.util.WarnSuspendUser;
import com.ibm.team.internal.filesystem.ui.util.WarnUpdateUser;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.links.GenericLinkCreator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.RepositoryProvider;

public class ChangesDropTargetAdapter
extends DropTargetAdapter {
    private Tree tree;
    private JobRunner jobRunner = new JobRunner(true);

    public ChangesDropTargetAdapter(TreeViewer viewer) {
        this.tree = (Tree)viewer.getControl();
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            return;
        }
        TreeItem treeItem = this.tree.getItem(this.tree.toControl(event.x, event.y));
        Object data = treeItem != null ? treeItem.getData() : null;
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection s = (IStructuredSelection)selection;
        Object[] elements = s.toArray();
        if (data == null) {
            this.dropTo(elements);
        } else if (data instanceof IRemoteActivity) {
            this.dropToRemoteActivity((IRemoteActivity)data, elements);
        } else if (data instanceof IActivitySource) {
            this.dropToActivitySource((IActivitySource)data, elements);
        } else if (data instanceof IComponentSyncContext) {
            this.dropToComponentSyncContext((IComponentSyncContext)data, elements);
        } else if (data instanceof IWorkspaceSyncContext) {
            this.dropToWorkspaceSyncContext((IWorkspaceSyncContext)data, elements);
        }
    }

    public void dragOver(DropTargetEvent event) {
        TreeItem treeItem = this.tree.getItem(this.tree.toControl(event.x, event.y));
        Object data = treeItem != null ? treeItem.getData() : null;
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection s = (IStructuredSelection)selection;
            Object[] elements = s.toArray();
            DragType dragType = this.getDragType(data, elements);
            if (data != null) {
                if (dragType != DragType.NONE) {
                    event.feedback = 9;
                    switch (dragType) {
                        case CHANGES: 
                        case UNRESOLVED: {
                            event.detail = 2;
                            break;
                        }
                        case LOCALFILES: 
                        case FLOWTARGET: {
                            event.detail = 1;
                            break;
                        }
                        case LINKS: {
                            event.detail = 4;
                        }
                    }
                    return;
                }
            } else if (dragType == DragType.ACTIVATE_WORKSPACE) {
                event.feedback = 9;
                event.detail = 1;
                return;
            }
        }
        event.feedback = 24;
        event.detail = 0;
    }

    private DragType getDragType(Object data, Object[] elements) {
        if (data instanceof IActivitySource && this.dragOverActivitySource((IActivitySource)data, elements)) {
            return DragType.CHANGES;
        }
        if (data instanceof IRemoteActivity) {
            return this.getRemoteActivityType((IRemoteActivity)data, elements);
        }
        if (data instanceof IComponentSyncContext && this.dragOverComponentContext((IComponentSyncContext)data, elements)) {
            return this.getComponentContextType((IComponentSyncContext)data, elements);
        }
        if (data instanceof IWorkspaceSyncContext && this.dragOverWorkspaceContext((IWorkspaceSyncContext)data, elements)) {
            return this.getWorkspaceContextType((IWorkspaceSyncContext)data, elements);
        }
        if (data == null) {
            boolean allAbstractPlaceWrappers = true;
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (!(element instanceof AbstractPlaceWrapper)) {
                    allAbstractPlaceWrappers = false;
                    break;
                }
                ++n2;
            }
            return allAbstractPlaceWrappers ? DragType.ACTIVATE_WORKSPACE : DragType.NONE;
        }
        return DragType.NONE;
    }

    private void dropTo(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof AbstractPlaceWrapper) {
                AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)element);
                FileSystemResourcesPlugin.getActiveWorkspaceManager().activate((IWorkspaceHandle)wrapper.getWorkspace());
            }
            ++n2;
        }
    }

    private void dropToRemoteActivity(final IRemoteActivity source, final Object[] elements) {
        if (this.getLinkFactories(source.getActivitySource().getModel().localTeamRepository(), elements)) {
            final UIContext context = UIContext.createShellContext((Display)Display.getCurrent(), (JobRunner)this.jobRunner);
            this.jobRunner.enqueue(Messages.ChangesDropTargetAdapter_0, (Operation)new RepositoryOperation(source.getActivitySource().getModel().localTeamRepository()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                    try {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ChangesDropTargetAdapter_1, (int)elements.length);
                        GenericLinkCreator links = new GenericLinkCreator();
                        ITeamRepository sourceRepo = (ITeamRepository)source.getChangeSetHandle().getOrigin();
                        int i = 0;
                        while (i < elements.length) {
                            Object element = elements[i];
                            if (element instanceof IReference) {
                                element = ((IReference)element).resolve();
                            }
                            if (element instanceof IItemHandle) {
                                IItemHandle itemHandle = (IItemHandle)element;
                                ITeamRepository targetRepo = (ITeamRepository)itemHandle.getOrigin();
                                if (sourceRepo != null && targetRepo != null) {
                                    if (sourceRepo.getId().equals((Object)targetRepo.getId())) {
                                        links.createLinks(source.getChangeSetHandle().getItemType(), (Object)source.getChangeSetHandle(), itemHandle.getItemType(), (Object)itemHandle, (IProgressMonitor)progress.newChild(1));
                                    } else {
                                        IItem workItem = targetRepo.itemManager().fetchCompleteItem(itemHandle, 0, (IProgressMonitor)progress.newChild(1));
                                        Location location = Location.namedLocation((IItem)workItem, (String)targetRepo.getRepositoryURI());
                                        URI oslcURI = null;
                                        try {
                                            oslcURI = new URI(location.toString());
                                        }
                                        catch (URISyntaxException uRISyntaxException) {
                                            // empty catch block
                                        }
                                        String comment = ChangeSetLinks.describe((IItem)workItem);
                                        IWorkspace workspace = source.getActivitySource().getWorkspace();
                                        AssociateChangeSetChangeRequestAction.CreateLinksInfo arg = new AssociateChangeSetChangeRequestAction.CreateLinksInfo();
                                        arg.context = context;
                                        arg.targetRepo = targetRepo;
                                        arg.oslcURIs.add(oslcURI);
                                        arg.oslcLabels.add(comment);
                                        arg.sourceChangeSets.add(source.getChangeSetHandle());
                                        arg.sourceRepos.add(sourceRepo);
                                        arg.sourceWorkspaces.add((IWorkspaceHandle)workspace);
                                        AssociateChangeSetChangeRequestAction.createLinks(arg);
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    catch (TeamRepositoryException e) {
                        problems.reportProblem(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                    }
                }
            });
            return;
        }
        if (source instanceof IOutgoingRemoteActivity) {
            Collection localChanges = ChangesDropTargetAdapter.getLocalChanges(elements, (IComponentHandle)source.getActivitySource().getModel().getComponent());
            if (localChanges.size() != 0) {
                Shell shell = this.tree.getShell();
                IComponentSyncContext context = source.getActivitySource().getModel();
                CheckIntoChangeSetAction.run(shell, context, (IOutgoingRemoteActivity)source, localChanges);
                return;
            }
            final Collection summaries = ChangesDropTargetAdapter.getActiveChangeSummaries(elements);
            final Shell shell = this.tree.getShell();
            if (summaries.size() != 0) {
                Job job = new Job(Messages.ChangesDropTargetAdapter_5){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            try {
                                monitor.beginTask(Messages.ChangesDropTargetAdapter_6, 100);
                                IComponentSyncContext compareChanges = source.getActivitySource().getModel();
                                compareChanges.relocate(summaries, source, (UpdateDilemmaHandler)new WarnUpdateUser(shell, this.getName()), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                compareChanges.refresh(false, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                            }
                            catch (FileSystemException e) {
                                IStatus iStatus = FileSystemStatusUtil.getStatusFor((Throwable)e);
                                monitor.done();
                                return iStatus;
                            }
                            catch (TeamRepositoryException e) {
                                IStatus iStatus = FileSystemStatusUtil.getStatusFor((Throwable)e);
                                monitor.done();
                                return iStatus;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
                return;
            }
            List<IProject> projects = ChangesDropTargetAdapter.getUnsharedProjects(elements);
            if (projects.size() != 0) {
                IWorkspaceConnection connection = source.getActivitySource().getModel().getOutgoingTeamPlace();
                IChangeSetHandle changeSet = source.getChangeSetHandle();
                IComponent component = source.getActivitySource().getModel().getComponent();
                this.shareProjects(projects, connection, (IComponentHandle)component, changeSet);
                return;
            }
        }
    }

    private void dropToComponentSyncContext(final IComponentSyncContext context, final Object[] elements) {
        List<IProject> projects;
        if (ChangesDropTargetAdapter.singleAbstractPlaceOrBaselineWrapper(elements)) {
            Job job = new Job(Messages.ChangesDropTargetAdapter_7){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (elements[0] instanceof AbstractPlaceWrapper) {
                            IWorkspaceConnection collaboration = ((AbstractPlaceWrapper)((Object)elements[0])).getWorkspaceConnection(monitor);
                            IWorkspace workspace = context.getOutgoingTeamPlace().getResolvedWorkspace();
                            boolean persist = !workspace.isStream();
                            FileSystemResourcesPlugin.getActiveWorkspaceManager().setComponentCollaboration((IWorkspaceHandle)workspace, Collections.singletonList(context.getComponent()), collaboration, persist, monitor);
                        } else if (elements[0] instanceof BaselineWrapper) {
                            IBaselineConnection collaboration = ((BaselineWrapper)elements[0]).getBaselineConnection(monitor);
                            FileSystemResourcesPlugin.getActiveWorkspaceManager().setComponentCollaboration((IWorkspaceHandle)context.getOutgoingTeamPlace().getResolvedWorkspace(), (IComponentHandle)context.getComponent(), collaboration, true, monitor);
                        }
                    }
                    catch (TeamRepositoryException e) {
                        return StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
            return;
        }
        if (ChangesDropTargetAdapter.allUnsharedProjects(elements) && (projects = ChangesDropTargetAdapter.getUnsharedProjects(elements)).size() != 0) {
            IWorkspaceConnection connection = context.getOutgoingTeamPlace();
            IComponent component = context.getComponent();
            this.shareProjects(projects, connection, (IComponentHandle)component, null);
            return;
        }
        if (this.getLinkFactories(context.localTeamRepository(), elements)) {
            final Shell shell = this.tree.getShell();
            final UIContext uiContext = UIContext.createShellContext((Shell)Display.getCurrent().getActiveShell(), (IOperationRunner)this.jobRunner);
            this.jobRunner.enqueue(Messages.ChangesDropTargetAdapter_8, (Operation)new RepositoryOperation(context.localTeamRepository()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                    try {
                        try {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ChangesDropTargetAdapter_9, (int)elements.length);
                            WarnCommitUser problemHandler = new WarnCommitUser(shell, Messages.ChangesDropTargetAdapter_10);
                            IOutgoingRemoteActivity source = context.createActivityLocalChanges(Collections.emptyList(), true, (CommitDilemmaHandler)problemHandler, (IProgressMonitor)progress.newChild(1));
                            GenericLinkCreator links = new GenericLinkCreator();
                            ITeamRepository sourceRepo = context.getOutgoingConnection().teamRepository();
                            int i = 0;
                            while (i < elements.length) {
                                Object element = elements[i];
                                if (element instanceof IItemHandle) {
                                    IItemHandle itemHandle = (IItemHandle)element;
                                    ITeamRepository targetRepo = (ITeamRepository)itemHandle.getOrigin();
                                    if (sourceRepo != null && targetRepo != null) {
                                        if (sourceRepo.getId().equals((Object)targetRepo.getId())) {
                                            links.createLinks(source.getChangeSetHandle().getItemType(), (Object)source.getChangeSetHandle(), itemHandle.getItemType(), (Object)itemHandle, (IProgressMonitor)progress.newChild(1));
                                        } else {
                                            IItem workItem = targetRepo.itemManager().fetchCompleteItem(itemHandle, 0, (IProgressMonitor)progress.newChild(1));
                                            Location location = Location.namedLocation((IItem)workItem, (String)targetRepo.getRepositoryURI());
                                            URI oslcURI = null;
                                            try {
                                                oslcURI = new URI(location.toString());
                                            }
                                            catch (URISyntaxException uRISyntaxException) {
                                                // empty catch block
                                            }
                                            String comment = ChangeSetLinks.describe((IItem)workItem);
                                            IWorkspace workspace = source.getActivitySource().getWorkspace();
                                            AssociateChangeSetChangeRequestAction.CreateLinksInfo arg = new AssociateChangeSetChangeRequestAction.CreateLinksInfo();
                                            arg.context = uiContext;
                                            arg.targetRepo = targetRepo;
                                            arg.oslcURIs.add(oslcURI);
                                            arg.oslcLabels.add(comment);
                                            arg.sourceChangeSets.add(source.getChangeSetHandle());
                                            arg.sourceRepos.add(sourceRepo);
                                            arg.sourceWorkspaces.add((IWorkspaceHandle)workspace);
                                            AssociateChangeSetChangeRequestAction.createLinks(arg);
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (FileSystemException e) {
                            problems.reportProblem(StatusUtil.newStatus((Object)((Object)this), (String)Messages.ChangesDropTargetAdapter_21, (Throwable)e));
                            monitor.done();
                        }
                        catch (TeamRepositoryException e) {
                            problems.reportProblem(StatusUtil.newStatus((Object)((Object)this), (String)Messages.ChangesDropTargetAdapter_22, (Throwable)e));
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return;
        }
    }

    private void dropToWorkspaceSyncContext(final IWorkspaceSyncContext context, final Object[] elements) {
        if (ChangesDropTargetAdapter.singleAbstractPlaceOrBaselineWrapper(elements)) {
            Job job = new Job(Messages.ChangesDropTargetAdapter_13){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (elements[0] instanceof AbstractPlaceWrapper) {
                            IWorkspaceConnection collaboration = ((AbstractPlaceWrapper)((Object)elements[0])).getWorkspaceConnection(monitor);
                            IWorkspace workspace = context.getLocal().getResolvedWorkspace();
                            boolean persist = !workspace.isStream();
                            FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceCollaboration((IWorkspaceHandle)workspace, collaboration, persist, monitor);
                        } else if (elements[0] instanceof BaselineWrapper) {
                            IBaselineConnection collaboration = ((BaselineWrapper)elements[0]).getBaselineConnection(monitor);
                            FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceCollaboration((IWorkspaceHandle)context.getLocal().getResolvedWorkspace(), collaboration, true, monitor);
                        }
                    }
                    catch (TeamRepositoryException e) {
                        return StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
            return;
        }
    }

    private void dropToActivitySource(IActivitySource source, Object[] elements) {
        IActivitySource from;
        if (source instanceof IOutgoingActivitySource) {
            List<IProject> projects;
            from = ChangesDropTargetAdapter.getActivitySource(elements);
            if (from instanceof IIncomingActivitySource) {
                final List incomingActivities = ChangesDropTargetAdapter.getRemoteActivities(elements);
                Shell shell = this.tree.getShell();
                UIContext context = UIContext.createShellContext((Shell)shell);
                final WarnWorkspaceUpdate warnWorkspaceUpdate = new WarnWorkspaceUpdate(context, Messages.ChangesDropTargetAdapter_14);
                Job job = new Job(Messages.ChangesDropTargetAdapter_14){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            WorkspaceUpdateUtil.accept((Collection)incomingActivities, (WorkspaceUpdateDilemmaHandler)warnWorkspaceUpdate, (boolean)false, (boolean)false, (IProgressMonitor)monitor);
                            return Status.OK_STATUS;
                        }
                        catch (FileSystemException e) {
                            return FileSystemStatusUtil.getStatusFor((Throwable)e);
                        }
                        catch (TeamRepositoryException e) {
                            return FileSystemStatusUtil.getStatusFor((Throwable)e);
                        }
                    }
                };
                job.setUser(true);
                job.schedule();
                return;
            }
            if (from instanceof ISuspendedActivitySource) {
                final IComponentSyncContext context = from.getModel();
                final List suspendedActivities = ChangesDropTargetAdapter.getRemoteActivities(elements);
                final Shell shell = this.tree.getShell();
                Job job = new Job(Messages.ChangesDropTargetAdapter_16){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            List changeSets = ComponentSyncUtil.getChangeSetHandles((Collection)suspendedActivities);
                            IWorkspaceConnection workspace = context.getOutgoingTeamPlace();
                            IResumeOperation op = IOperationFactory.instance.getResumeOperation((ResumeDilemmaHandler)new WarnResumeUser(shell, this.getName()));
                            op.setFileContentMerger(FileSystemResourcesPlugin.getConfiguredExternalFileContentMerger());
                            op.resume(workspace, (Collection)changeSets);
                            op.run(monitor);
                            return Status.OK_STATUS;
                        }
                        catch (FileSystemException e) {
                            return FileSystemStatusUtil.getStatusFor((Throwable)e);
                        }
                        catch (TeamRepositoryException e) {
                            return FileSystemStatusUtil.getStatusFor((Throwable)e);
                        }
                    }
                };
                job.setUser(true);
                job.schedule();
                return;
            }
            if (ChangesDropTargetAdapter.allUnsharedProjects(elements) && (projects = ChangesDropTargetAdapter.getUnsharedProjects(elements)).size() != 0) {
                IWorkspaceConnection connection = source.getModel().getOutgoingTeamPlace();
                IComponent component = source.getModel().getComponent();
                this.shareProjects(projects, connection, (IComponentHandle)component, null);
                return;
            }
        }
        if (source instanceof IIncomingActivitySource) {
            from = ChangesDropTargetAdapter.getActivitySource(elements);
            if (from == null || !(from instanceof IOutgoingActivitySource)) {
                return;
            }
            List outgoingActivities = ChangesDropTargetAdapter.getRemoteActivities(elements);
            DeliverAction deliverAction = new DeliverAction();
            deliverAction.deliver(this.tree.getShell(), outgoingActivities);
        }
        if (source instanceof ISuspendedActivitySource) {
            from = ChangesDropTargetAdapter.getActivitySource(elements);
            if (from == null || !(from instanceof IOutgoingActivitySource)) {
                return;
            }
            final IComponentSyncContext context = from.getModel();
            final List outgoingActivities = ChangesDropTargetAdapter.getRemoteActivities(elements);
            final Shell shell = this.tree.getShell();
            Job job = new Job(Messages.ChangesDropTargetAdapter_17){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ISuspendOperation op = IOperationFactory.instance.getSuspendOperation((SuspendDilemmaHandler)new WarnSuspendUser(shell, this.getName()));
                        op.suspend(context.getOutgoingTeamPlace(), (Collection)ComponentSyncUtil.getChangeSetHandles((Collection)outgoingActivities));
                        op.run(monitor);
                        return Status.OK_STATUS;
                    }
                    catch (FileSystemException e) {
                        return FileSystemStatusUtil.getStatusFor((Throwable)e);
                    }
                    catch (TeamRepositoryException e) {
                        return FileSystemStatusUtil.getStatusFor((Throwable)e);
                    }
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private void shareProjects(final List<IProject> projects, final IWorkspaceConnection connection, final IComponentHandle component, final IChangeSetHandle changeSet) {
        this.jobRunner.enqueue(Messages.ChangesDropTargetAdapter_18, (Operation)new RepositoryOperation(connection.teamRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                try {
                    try {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ChangesDropTargetAdapter_19, (int)100);
                        WarnShareUser handler = new WarnShareUser(null, Messages.ChangesDropTargetAdapter_20);
                        IShareOperation shareOp = IOperationFactory.instance.getShareOperation((ShareDilemmaHandler)handler);
                        ArrayList<PathLocation> shareRoots = new ArrayList<PathLocation>(projects.size());
                        for (IProject project : projects) {
                            IPath path = project.getLocation();
                            if (path == null) continue;
                            shareRoots.add(new PathLocation(path));
                        }
                        shareOp.share(connection, changeSet, component, shareRoots, true, (IProgressMonitor)progress.newChild(1));
                        shareOp.run((IProgressMonitor)progress.newChild(99));
                    }
                    catch (FileSystemException e) {
                        problems.reportProblem(StatusUtil.newStatus((Object)((Object)this), (String)Messages.ChangesDropTargetAdapter_21, (Throwable)e));
                        monitor.done();
                    }
                    catch (TeamRepositoryException e) {
                        problems.reportProblem(StatusUtil.newStatus((Object)((Object)this), (String)Messages.ChangesDropTargetAdapter_22, (Throwable)e));
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private boolean dragOverWorkspaceContext(IWorkspaceSyncContext context, Object[] elements) {
        return this.getWorkspaceContextType(context, elements) != DragType.NONE;
    }

    private DragType getWorkspaceContextType(IWorkspaceSyncContext context, Object[] elements) {
        boolean allFlows;
        if (!context.getLocal().isStream() && ChangesDropTargetAdapter.singleAbstractPlaceOrBaselineWrapper(elements) && !(allFlows = FileSystemResourcesPlugin.getDefault().getPluginPreferences().getBoolean("show_all_flow_targets"))) {
            return DragType.FLOWTARGET;
        }
        return DragType.NONE;
    }

    private boolean dragOverComponentContext(IComponentSyncContext context, Object[] elements) {
        return this.getComponentContextType(context, elements) != DragType.NONE;
    }

    private DragType getComponentContextType(IComponentSyncContext context, Object[] elements) {
        if (context.isLocal() && !context.getOutgoingTeamPlace().isStream() && ChangesDropTargetAdapter.singleAbstractPlaceOrBaselineWrapper(elements)) {
            boolean allFlows = FileSystemResourcesPlugin.getDefault().getPluginPreferences().getBoolean("show_all_flow_targets");
            if (allFlows) {
                return DragType.NONE;
            }
            return DragType.FLOWTARGET;
        }
        if (ChangesDropTargetAdapter.allUnsharedProjects(elements) && context.isLocal()) {
            return DragType.LOCALFILES;
        }
        if (this.getLinkFactories(context.localTeamRepository(), elements)) {
            return DragType.LINKS;
        }
        return DragType.NONE;
    }

    private DragType getRemoteActivityType(IRemoteActivity activity, Object[] elements) {
        IActivitySource source = activity.getActivitySource();
        if (source instanceof IOutgoingActivitySource) {
            boolean active = source.getModel().isActive(activity);
            if (!ChangesDropTargetAdapter.getLocalChanges(elements, (IComponentHandle)source.getModel().getComponent()).isEmpty() && active) {
                return DragType.UNRESOLVED;
            }
            if (!ChangesDropTargetAdapter.getActiveChangeSummaries(elements, activity).isEmpty()) {
                return DragType.CHANGES;
            }
            if (ChangesDropTargetAdapter.allUnsharedProjects(elements) && active) {
                return DragType.LOCALFILES;
            }
        }
        if ((source instanceof ISuspendedActivitySource || source instanceof IOutgoingActivitySource) && this.getLinkFactories(source.getModel().localTeamRepository(), elements)) {
            return DragType.LINKS;
        }
        return DragType.NONE;
    }

    private boolean getLinkFactories(ITeamRepository repo, Object[] elements) {
        GenericLinkCreator links = new GenericLinkCreator();
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            if (object instanceof IReference) {
                object = ((IReference)object).resolve();
            }
            if (object instanceof IItemHandle) {
                List linkTypes = links.getCompatibleLinkTypes(IChangeSet.ITEM_TYPE, ((IItemHandle)object).getItemType());
                if (linkTypes.isEmpty()) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isIncompatibleRepository(Object[] elements, ITeamRepository repo) {
        return !ComponentSyncUtil.isCompatibleRepository((Object[])elements, (ITeamRepository)repo);
    }

    private boolean dragOverActivitySource(IActivitySource source, Object[] elements) {
        if (source instanceof IOutgoingActivitySource) {
            if (ChangesDropTargetAdapter.allUnsharedProjects(elements) && source.getModel().isLocal()) {
                return true;
            }
            if (this.isIncompatibleRepository(elements, source.getModel().localTeamRepository())) {
                return false;
            }
            IActivitySource from = ChangesDropTargetAdapter.getActivitySource(elements);
            if (from != null && from instanceof IIncomingActivitySource && from.getModel() == source.getModel()) {
                return true;
            }
            return from != null && from instanceof ISuspendedActivitySource && from.getModel() == source.getModel();
        }
        if (source instanceof IIncomingActivitySource) {
            if (this.isIncompatibleRepository(elements, source.getModel().localTeamRepository())) {
                return false;
            }
            IActivitySource from = ChangesDropTargetAdapter.getActivitySource(elements);
            return from != null && from instanceof IOutgoingActivitySource && from.getModel() == source.getModel();
        }
        if (source instanceof ISuspendedActivitySource) {
            if (this.isIncompatibleRepository(elements, source.getModel().localTeamRepository())) {
                return false;
            }
            IActivitySource from = ChangesDropTargetAdapter.getActivitySource(elements);
            return from != null && from instanceof IOutgoingActivitySource && from.getModel() == source.getModel();
        }
        return false;
    }

    public static boolean singleAbstractPlaceOrBaselineWrapper(Object[] elements) {
        return elements.length == 1 && (elements[0] instanceof AbstractPlaceWrapper || elements[0] instanceof BaselineWrapper);
    }

    public static boolean allUnsharedProjects(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            boolean shared;
            IProject project;
            Object object = elements[i] instanceof IProject ? (IProject)elements[i] : (project = elements[i] instanceof IAdaptable ? (IProject)((IAdaptable)elements[i]).getAdapter(IProject.class) : null);
            if (project == null) {
                return false;
            }
            boolean bl = shared = RepositoryProvider.getProvider((IProject)project, (String)"com.ibm.team.filesystem.rcp.core.provider") != null;
            if (shared) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Collection getLocalChanges(Object[] elements) {
        Set[] result = ComponentSyncUtil.filter(Arrays.asList(elements), (Class[])new Class[]{ILocalChange.class, Object.class});
        if (result[1].size() != 0) {
            return Collections.EMPTY_SET;
        }
        return result[0];
    }

    public static Collection getLocalChanges(Object[] elements, IComponentHandle component) {
        Collection result = ChangesDropTargetAdapter.getLocalChanges(elements);
        return ComponentSyncUtil.sameComponent((Collection)result, (IComponentHandle)component) ? result : Collections.EMPTY_LIST;
    }

    public static List<IProject> getUnsharedProjects(Object[] elements) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        int i = 0;
        while (i < elements.length) {
            boolean shared;
            IProject project;
            Object object = elements[i] instanceof IProject ? (IProject)elements[i] : (project = elements[i] instanceof IAdaptable ? (IProject)((IAdaptable)elements[i]).getAdapter(IProject.class) : null);
            if (project == null) {
                return Collections.emptyList();
            }
            boolean bl = shared = RepositoryProvider.getProvider((IProject)project, (String)"com.ibm.team.filesystem.rcp.core.provider") != null;
            if (shared) {
                return Collections.emptyList();
            }
            result.add(project);
            ++i;
        }
        return result;
    }

    public static Collection getActiveChangeSummaries(Object[] elements) {
        Set[] result = ComponentSyncUtil.filter(Arrays.asList(elements), (Class[])new Class[]{IActivitySource.class, IOutgoingRemoteChangeSummary.class, Object.class});
        Set changeSummaries = result[0].size() != 0 || result[2].size() != 0 ? Collections.EMPTY_SET : result[1];
        for (IOutgoingRemoteChangeSummary summary : changeSummaries) {
            IRemoteActivity activity = summary.getActivity();
            if (activity.getActivitySource().getModel().isActive(activity)) continue;
            return Collections.EMPTY_SET;
        }
        return changeSummaries;
    }

    public static Collection getActiveChangeSummaries(Object[] elements, IRemoteActivity target) {
        if (!target.getActivitySource().getModel().isActive(target)) {
            return Collections.EMPTY_LIST;
        }
        Collection result = ChangesDropTargetAdapter.getActiveChangeSummaries(elements);
        Set contexts = ComponentSyncUtil.getContexts((Collection)result);
        return contexts.size() == 1 && contexts.iterator().next() == target.getActivitySource().getModel() ? result : Collections.EMPTY_LIST;
    }

    public static List getRemoteActivities(Object[] elements) {
        ArrayList<Object> list = new ArrayList<Object>(elements.length);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IRemoteActivity) {
                list.add(elements[i]);
            }
            ++i;
        }
        return list;
    }

    public static IActivitySource getActivitySource(Object[] elements) {
        IActivitySource source = null;
        int i = 0;
        while (i < elements.length) {
            IActivitySource current = null;
            if (elements[i] instanceof IRemoteActivity) {
                current = ((IRemoteActivity)elements[i]).getActivitySource();
            }
            if (source == null) {
                source = current;
            }
            if (source != current) {
                return null;
            }
            ++i;
        }
        return source;
    }

    public static enum DragType {
        NONE,
        LOCALFILES,
        LINKS,
        CHANGES,
        UNRESOLVED,
        FLOWTARGET,
        ACTIVATE_WORKSPACE;

    }
}

