/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.file.LiveAnnotate;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenPortEditorAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.SearchForChangeSetsAction;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.WorkspaceUpdateUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.WorkspaceSyncContext;
import com.ibm.team.filesystem.ui.actions.flows.SwitchCollaborationAction;
import com.ibm.team.filesystem.ui.changes.RenameChangeSetUtil;
import com.ibm.team.filesystem.ui.changes.actions.AcceptAction;
import com.ibm.team.filesystem.ui.changes.actions.ChangesViewFilterActionGroup;
import com.ibm.team.filesystem.ui.changes.actions.CheckinAllAction;
import com.ibm.team.filesystem.ui.changes.actions.ContributorContextMenu;
import com.ibm.team.filesystem.ui.changes.actions.CopyChangeAction;
import com.ibm.team.filesystem.ui.changes.actions.DeleteAction;
import com.ibm.team.filesystem.ui.changes.actions.DeliverAction;
import com.ibm.team.filesystem.ui.changes.actions.DeliverBaselineGroupAction;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.changes.actions.MoveToActivityContributionItem;
import com.ibm.team.filesystem.ui.changes.actions.NavigateAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenAction;
import com.ibm.team.filesystem.ui.changes.actions.RefreshSandboxAction;
import com.ibm.team.filesystem.ui.changes.actions.SaveIntoActivityContributionItem;
import com.ibm.team.filesystem.ui.changes.actions.ShowRepositoryFilesAction;
import com.ibm.team.filesystem.ui.changes.actions.SyncZoomAction;
import com.ibm.team.filesystem.ui.changes.actions.TrackWorkspaceAction;
import com.ibm.team.filesystem.ui.changes.actions.UntrackWorkspaceAction;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.filesystem.ui.changes.views.SetupPendingViewPage;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.IZoomWorkItemRoot;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.internal.filesystem.ui.views.history.actions.ShowHistoryAction;
import com.ibm.team.internal.filesystem.ui.views.history.actions.ShowSnapshotsInWorkspaceAction;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.actions.ShowStructuralChangesAction;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class Actions {
    public static final String COMMAND_ACCEPT = "com.ibm.team.filesystem.ide.ui.command.accept";
    public static final String COMMAND_DELIVER = "com.ibm.team.filesystem.ide.ui.command.deliver";
    public static final String COMMAND_CHECKIN = "com.ibm.team.filesystem.ide.ui.command.checkin";
    public static final String COMMAND_ZOOM_TOGGLE = "com.ibm.team.filesystem.ide.ui.command.SyncZoomAction";
    public static final String COMMAND_ZOOM_TOGGLE_FULL = "com.ibm.team.filesystem.ide.ui.command.SyncZoomAction.FULL";
    public static final String COMMAND_ZOOM_TOGGLE_OUTGOING = "com.ibm.team.filesystem.ide.ui.command.SyncZoomAction.OUTGOING";
    public static final String COMMAND_ZOOM_TOGGLE_INCOMING = "com.ibm.team.filesystem.ide.ui.command.SyncZoomAction.INCOMING";
    public static final String COMMAND_ZOOM_TOGGLE_SUSPENDED = "com.ibm.team.filesystem.ide.ui.command.SyncZoomAction.SUSPENDED";
    public static final String COMMAND_SHOW_HISTORY = "com.ibm.team.filesystem.ide.ui.command.showHistory";
    public static final String COMMAND_REFRESH = "com.ibm.team.filesystem.ide.ui.command.RefreshSandboxAction.REMOTES_CHANGES";
    public static final String COMMAND_CHANGE_FLOW_TARGET = "com.ibm.team.filesystem.ui.command.changeFlowTarget";
    public static final String COMMAND_SHOW_SNAPSHOTS = "com.ibm.team.internal.filesystem.ui.command.showSnapshotsInWorkspace";
    public static final String COMMAND_SHOW_REPOSITORY_FILES = "com.ibm.team.filesystem.ui.changes.command.showRepositoryFiles";
    public static final String COMMAND_ANNOTATE = "com.ibm.team.filesystem.ide.ui.command.annotate";
    public static final String COMMAND_OPEN_CHANGE_EXPLORER = "com.ibm.team.internal.filesystem.ui.commands.showInChangeExplorer";
    public static final String COMMAND_TRACK_WORKSPACE = "com.ibm.team.filesystem.ui.command.trackWorkspace";
    public static final String COMMAND_UNTRACK_WORKSPACE = "com.ibm.team.filesystem.ui.command.untrackWorkspace";
    public static final String[] COMMAND_IDS = new String[]{"com.ibm.team.filesystem.ide.ui.command.accept", "com.ibm.team.filesystem.ide.ui.command.deliver", "com.ibm.team.filesystem.ide.ui.command.checkin", "com.ibm.team.filesystem.ide.ui.command.SyncZoomAction", "com.ibm.team.filesystem.ide.ui.command.SyncZoomAction.FULL", "com.ibm.team.filesystem.ide.ui.command.SyncZoomAction.OUTGOING", "com.ibm.team.filesystem.ide.ui.command.SyncZoomAction.INCOMING", "com.ibm.team.filesystem.ide.ui.command.SyncZoomAction.SUSPENDED", "com.ibm.team.filesystem.ide.ui.command.showHistory", "com.ibm.team.filesystem.ide.ui.command.RefreshSandboxAction.REMOTES_CHANGES", "com.ibm.team.filesystem.ui.command.changeFlowTarget", "com.ibm.team.internal.filesystem.ui.command.showSnapshotsInWorkspace", "com.ibm.team.filesystem.ui.changes.command.showRepositoryFiles", "com.ibm.team.filesystem.ide.ui.command.annotate", "com.ibm.team.internal.filesystem.ui.commands.showInChangeExplorer", "com.ibm.team.filesystem.ui.command.trackWorkspace", "com.ibm.team.filesystem.ui.command.untrackWorkspace"};
    public Action renameChangeAction;
    public Action checkinAllAction;
    public Action deliverAllAction;
    public Action acceptAllAction;
    public BaseSelectionListenerAction copyAction;
    public Action refreshAction;
    public Action collapseAllAction;
    public Action expandToChangesAction;
    public IAction openLinkAction;
    public SyncZoomAction zoomAction;
    public SaveIntoActivityContributionItem saveIntoContributionItem = null;
    public MoveToActivityContributionItem moveToActivityContributionItem = null;
    public ContributionItem expandAllContributionItem;
    public Action openPreferencesAction;
    public Action loadWorkspaceAction;
    public Action newWorkspaceAction;
    public Action openPortEditorAction;
    public ChangesViewFilterActionGroup changesViewFilterActionGroup;
    public PartSiteJobRunner jobRunner;

    public void init(final Shell shell, final LocalWorkspaceChangesView viewPart, LocalWorkspaceChangesViewLabelProvider labelProvider, LocalSynchronizeDecorator labelDecorator) {
        this.jobRunner = new PartSiteJobRunner(viewPart.getSite(), false);
        this.checkinAllAction = new Action(){

            public void run() {
                IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
                final IComponentSyncContext[] elements = model.getComponentSyncContexts();
                Job job = new Job(Messages.LocalWorkspaceChangesView_6){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            WarnCommitUser problemHandler = new WarnCommitUser(shell, this.getName());
                            int i = 0;
                            while (i < elements.length) {
                                List localChanges;
                                IComponentSyncContext context = elements[i];
                                if (context.isLocal() && !(localChanges = context.getLocalChangeSource().getLocalChanges()).isEmpty()) {
                                    context.autoCommitLocalChanges((Collection)localChanges, false, (CommitDilemmaHandler)problemHandler, monitor);
                                }
                                ++i;
                            }
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (FileSystemException e) {
                            IStatus iStatus = FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LocalWorkspaceChangesView_7, (Throwable)e);
                            return iStatus;
                        }
                        catch (TeamRepositoryException e) {
                            IStatus iStatus = FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LocalWorkspaceChangesView_7, (Throwable)e);
                            return iStatus;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        };
        this.checkinAllAction.setToolTipText(Messages.LocalWorkspaceChangesView_9);
        this.checkinAllAction.setText(Messages.LocalWorkspaceChangesView_10);
        this.checkinAllAction.setImageDescriptor(ImagePool.CHECKIN_ALL);
        this.checkinAllAction.setDisabledImageDescriptor(ImagePool.CHECKIN_ALL_DISABLED);
        this.checkinAllAction.setActionDefinitionId(COMMAND_CHECKIN);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.checkinAllAction, "com.ibm.team.filesystem.ide.ui.action_checkinall");
        this.acceptAllAction = new Action(){

            public void run() {
                IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
                IComponentSyncContext[] elements = model.getComponentSyncContexts();
                ArrayList<IComponentSyncContext> contexts = new ArrayList<IComponentSyncContext>(Arrays.asList(elements));
                int nDeletions = 0;
                int nAdditions = 0;
                for (IComponentSyncContext context : contexts) {
                    if (context.isOfType(64)) {
                        ++nAdditions;
                    }
                    if (!context.isOfType(128)) continue;
                    ++nDeletions;
                }
                if (nDeletions > 0 || nAdditions > 0) {
                    String message;
                    String title;
                    if (nDeletions > 0 && nAdditions > 0) {
                        title = Messages.LocalWorkspaceChangesView_11;
                        message = NLS.bind((String)Messages.LocalWorkspaceChangesView_12, (Object)nAdditions, (Object)nDeletions);
                    } else if (nDeletions > 0) {
                        title = Messages.LocalWorkspaceChangesView_13;
                        message = NLS.bind((String)Messages.LocalWorkspaceChangesView_14, (Object)nDeletions);
                    } else {
                        title = Messages.LocalWorkspaceChangesView_15;
                        message = NLS.bind((String)Messages.LocalWorkspaceChangesView_16, (Object)nAdditions);
                    }
                    message = String.valueOf(message) + Messages.LocalWorkspaceChangesView_17;
                    int result = new MessageDialog(viewPart.getSite().getShell(), title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2).open();
                    if (result == 2 || result < 0) {
                        return;
                    }
                    if (result == 1) {
                        Iterator iter = contexts.iterator();
                        while (iter.hasNext()) {
                            IComponentSyncContext context = (IComponentSyncContext)iter.next();
                            if (!context.isOfType(64) && !context.isOfType(128)) continue;
                            iter.remove();
                        }
                    }
                }
                AcceptAction acceptAction = new AcceptAction();
                acceptAction.init((IViewPart)viewPart);
                acceptAction.run(viewPart.getSite().getShell(), viewPart.getSite().getPage(), (IStructuredSelection)new StructuredSelection(contexts));
            }
        };
        this.acceptAllAction.setToolTipText(Messages.LocalWorkspaceChangesView_18);
        this.acceptAllAction.setText(Messages.LocalWorkspaceChangesView_19);
        this.acceptAllAction.setImageDescriptor(ImagePool.ACCEPT_ALL);
        this.acceptAllAction.setDisabledImageDescriptor(ImagePool.ACCEPT_ALL_DISABLED);
        this.acceptAllAction.setActionDefinitionId(COMMAND_ACCEPT);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.acceptAllAction, "com.ibm.team.filesystem.ide.ui.action_acceptall");
        this.deliverAllAction = new Action(){

            public void run() {
                IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
                IWorkspaceSyncContext[] elements = model.getWorkspaceSyncContexts();
                ArrayList<IWorkspaceSyncContext> contexts = new ArrayList<IWorkspaceSyncContext>(elements.length);
                ActiveWorkspaceManager manager = ActiveWorkspaceManager.getInstance();
                for (IWorkspaceSyncContext context : Arrays.asList(elements)) {
                    if (!manager.isWorkspaceTracked((IWorkspaceHandle)context.getLocal().getResolvedWorkspace())) continue;
                    contexts.add(context);
                }
                String message = Actions.this.getDeliverAllMessage(contexts);
                if (message != null && !DialogUtil.openConfirm(viewPart.getSite().getShell(), Messages.LocalWorkspaceChangesView_20, message, 4, false)) {
                    return;
                }
                DeliverAction deliverAction = new DeliverAction(false);
                deliverAction.init((IViewPart)viewPart);
                deliverAction.deliver(viewPart.getSite().getShell(), contexts);
            }
        };
        this.deliverAllAction.setToolTipText(Messages.LocalWorkspaceChangesView_21);
        this.deliverAllAction.setText(Messages.LocalWorkspaceChangesView_22);
        this.deliverAllAction.setImageDescriptor(ImagePool.DELIVER_ALL);
        this.deliverAllAction.setDisabledImageDescriptor(ImagePool.DELIVER_ALL_DISABLED);
        this.deliverAllAction.setActionDefinitionId(COMMAND_DELIVER);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.deliverAllAction, "com.ibm.team.filesystem.ide.ui.action_deliverall");
        this.collapseAllAction = new Action(){

            public void run() {
                viewPart.getActiveViewer().collapseAll();
            }
        };
        this.collapseAllAction.setToolTipText(Messages.LocalWorkspaceChangesView_23);
        this.collapseAllAction.setText(Messages.LocalWorkspaceChangesView_24);
        this.collapseAllAction.setImageDescriptor(ImagePool.COLLAPSEALL_ICON);
        this.expandToChangesAction = new Action(){

            public void run() {
                TreeViewer viewer = viewPart.getActiveViewer();
                if (viewPart.isFlatMode()) {
                    viewer.expandToLevel(viewer.getInput(), 2);
                } else {
                    viewer.expandToLevel(viewer.getInput(), 4);
                }
            }
        };
        this.expandToChangesAction.setToolTipText(Messages.LocalWorkspaceChangesView_25);
        this.expandToChangesAction.setText(Messages.LocalWorkspaceChangesView_25);
        this.expandToChangesAction.setImageDescriptor(ImagePool.EXPANDTOCHANGES_ICON);
        this.openPreferencesAction = new Action(){

            public void run() {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"com.ibm.team.filesystem.ui.preferences.ChangesPreferencePage", (String[])new String[]{"com.ibm.team.filesystem.ui.preferences.ChangesPreferencePage", "com.ibm.team.internal.filesystem.synchronize.preferences.SourceControlPreferencePage", "com.ibm.team.filesystem.ui.preferences.SynchronizationPreferencePage", "com.ibm.team.filesystem.ide.ui.SandboxPreferencePage"}, null).open();
            }
        };
        this.openPreferencesAction.setToolTipText(Messages.LocalWorkspaceChangesView_27);
        this.openPreferencesAction.setText(Messages.LocalWorkspaceChangesView_28);
        Action searchForChangeSetsAction = new Action(Messages.LocalWorkspaceChangesView_29){

            public void run() {
                new SearchForChangeSetsAction().run(viewPart.getSite().getShell(), viewPart.getSite().getPage(), (IStructuredSelection)new StructuredSelection());
            }
        };
        this.loadWorkspaceAction = new Action(Messages.LocalWorkspaceChangesView_30){

            public void run() {
                SetupPendingViewPage.loadRepositoryWorkspace(shell, viewPart.getSite().getPage().getActivePart());
            }
        };
        this.loadWorkspaceAction.setImageDescriptor(ImagePool.LOAD_WORKSPACE_IMAGE);
        this.newWorkspaceAction = new Action(Messages.LocalWorkspaceChangesView_31){

            public void run() {
                SetupPendingViewPage.newRepositoryWorkspace(shell, viewPart.getSite().getPage());
            }
        };
        this.newWorkspaceAction.setImageDescriptor(ImagePool.CREATE_WORKSPACE);
        if (this.saveIntoContributionItem == null) {
            this.saveIntoContributionItem = new SaveIntoActivityContributionItem(labelProvider, labelDecorator);
        }
        if (this.moveToActivityContributionItem == null) {
            this.moveToActivityContributionItem = new MoveToActivityContributionItem(labelProvider, labelDecorator);
        }
        this.openLinkAction = new Action(){

            public void run() {
                AbstractActionDelegate.execute(OpenAction.class, (UIContext)UIContext.createPartContext((IWorkbenchPart)viewPart.getSite().getPage().getActivePart()), (IStructuredSelection)((IStructuredSelection)viewPart.getActiveViewer().getSelection()));
            }
        };
        this.openLinkAction.setText(Messages.LocalWorkspaceChangesView_32);
        this.openLinkAction.setId("com.ibm.team.filesystem.ui.changes.actions.OpenAction");
        this.expandAllContributionItem = new ContributionItem(){

            public boolean isDynamic() {
                return true;
            }

            public boolean isDirty() {
                return true;
            }

            public void fill(Menu menu, int index) {
                MenuItem item = new MenuItem(menu, 8, index);
                IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
                IStructuredSelection selection = (IStructuredSelection)viewPart.getActiveViewer().getSelection();
                boolean isTracked = false;
                for (Object element : selection) {
                    if (element instanceof WorkspaceSyncContext) {
                        WorkspaceSyncContext syncContext = (WorkspaceSyncContext)element;
                        isTracked |= manager.isWorkspaceTracked((IWorkspaceHandle)syncContext.getLocal().getResolvedWorkspace());
                    } else {
                        isTracked |= true;
                    }
                    if (isTracked) break;
                }
                item.setEnabled(isTracked);
                item.setText(Messages.LocalWorkspaceChangesView_33);
                Listener listener = new Listener(){

                    public void handleEvent(Event event) {
                        IStructuredSelection selection = (IStructuredSelection)viewPart.getActiveViewer().getSelection();
                        for (Object element : selection) {
                            viewPart.getActiveViewer().expandToLevel(element, -1);
                        }
                    }
                };
                item.addListener(13, listener);
            }
        };
        this.refreshAction = new RefreshSandboxAction(shell, (IOperationRunner)this.jobRunner);
        this.renameChangeAction = new Action(){

            public void run() {
                viewPart.getActiveChangesViewPage().textEdit();
            }
        };
        NavigateAction previousAction = new NavigateAction(viewPart, false);
        NavigateAction nextAction = new NavigateAction(viewPart, true);
        this.zoomAction = new SyncZoomAction((IOperationRunner)this.jobRunner, viewPart);
        this.zoomAction.setActionDefinitionId(COMMAND_ZOOM_TOGGLE);
        this.openPortEditorAction = new Action(){

            public void run() {
                ISelection selection = viewPart.getActiveViewer().getSelection();
                if (selection instanceof IStructuredSelection) {
                    OpenPortEditorAction.openPortEditor(viewPart.getSite().getPage(), (IStructuredSelection)selection);
                }
            }
        };
        this.openPortEditorAction.setToolTipText(Messages.LocalWorkspaceChangesView_OPEN_PORT_EDITOR_ACTION_LABEL);
        this.openPortEditorAction.setText(Messages.LocalWorkspaceChangesView_OPEN_PORT_EDITOR_ACTION_LABEL);
        this.openPortEditorAction.setImageDescriptor(ImagePool.PORT_EDITOR_ICON);
        IActionBars bars = viewPart.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        IToolBarManager toolbarManager = bars.getToolBarManager();
        toolbarManager.add((IAction)this.refreshAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.zoomAction);
        toolbarManager.add((IAction)nextAction);
        toolbarManager.add((IAction)previousAction);
        toolbarManager.add((IAction)this.collapseAllAction);
        toolbarManager.add((IAction)this.expandToChangesAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.checkinAllAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.acceptAllAction);
        toolbarManager.add((IAction)this.deliverAllAction);
        IMenuManager menuManager = viewPart.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)this.loadWorkspaceAction);
        menuManager.add((IAction)this.newWorkspaceAction);
        menuManager.add((IAction)searchForChangeSetsAction);
        menuManager.add((IContributionItem)new Separator());
        this.changesViewFilterActionGroup = new ChangesViewFilterActionGroup();
        this.changesViewFilterActionGroup.fillContextMenu(menuManager);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new GroupMarker("additions"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.openPreferencesAction);
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)new Action(){

            public void run() {
                DeleteAction deleteAction = new DeleteAction();
                deleteAction.init((IViewPart)viewPart);
                deleteAction.selectionChanged(null, viewPart.getActiveViewer().getSelection());
                deleteAction.run(null);
            }
        });
        bars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)previousAction);
        bars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)nextAction);
        bars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameChangeAction);
        this.copyAction = new BaseSelectionListenerAction(Messages.LocalWorkspaceChangesView_35){

            public void run() {
                CopyChangeAction.copyToClipboard(UIContext.createPartContext((IWorkbenchPart)viewPart), AdapterUtil.adaptList(this.getStructuredSelection().toList(), ChangeSetWrapper.class));
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                return !AdapterUtil.adaptList(selection.toList(), ChangeSetWrapper.class).isEmpty();
            }
        };
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
    }

    public MenuManager createContextMenuManager(final LocalWorkspaceChangesView viewPart, TreeViewer viewer) {
        MenuManager contextMenuManager = new MenuManager(){

            protected boolean allowItem(IContributionItem itemToAdd) {
                boolean acceptWithHierarchy = "com.ibm.team.filesystem.ui.changes.actions.AcceptWithHierarchyAction".equals(itemToAdd.getId());
                boolean deliverWithHierarchy = "com.ibm.team.filesystem.ui.changes.actions.DeliverWithHierarchyAction".equals(itemToAdd.getId());
                if (acceptWithHierarchy || deliverWithHierarchy) {
                    IStructuredSelection lastSelection = viewPart.getActiveChangesViewPage().getLastSelection();
                    HashSet<ITeamRepository> reposInSelection = new HashSet<ITeamRepository>();
                    for (Object o : lastSelection.toList()) {
                        if (o instanceof IComponentSyncContext) {
                            IComponentSyncContext component = (IComponentSyncContext)o;
                            reposInSelection.add(component.getOutgoingConnection().teamRepository());
                            continue;
                        }
                        return false;
                    }
                    for (ITeamRepository repo : reposInSelection) {
                        if (FileSystemCore.getComponentHierarchyManager().isHierarchicalComponentsEnabled(repo)) continue;
                        return false;
                    }
                    Collection children = WorkspaceUpdateUtil.getComponentHierarchyChildren((Collection)lastSelection.toList(), (boolean)deliverWithHierarchy, null, null);
                    return children.size() > lastSelection.toList().size();
                }
                return super.allowItem(itemToAdd);
            }
        };
        contextMenuManager.setRemoveAllWhenShown(true);
        final ContributorContextMenu contributorMenuManager = new ContributorContextMenu(viewPart);
        contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Menu menu = ((MenuManager)manager).getMenu();
                if (menu != null) {
                    MenuItem[] items = menu.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                }
                IStructuredSelection lastSelection = viewPart.getActiveChangesViewPage().getLastSelection();
                manager.add((IContributionItem)new Separator("jazz.new.group"));
                ContextMenuHelper.addNewSubmenu((IMenuManager)manager, (boolean)false);
                manager.add((IContributionItem)new GroupMarker("jazz.open.group"));
                if (OpenPortEditorAction.isValidSelection((ISelection)lastSelection)) {
                    manager.add((IAction)Actions.this.openPortEditorAction);
                }
                manager.add((IContributionItem)new Separator("jazz.navigate.group"));
                manager.add((IContributionItem)new Separator("wizard"));
                manager.add((IContributionItem)new Separator("flow"));
                Actions.this.saveIntoContributionItem.setSelection(lastSelection);
                if (Actions.this.saveIntoContributionItem.isNeeded()) {
                    manager.add((IContributionItem)Actions.this.saveIntoContributionItem);
                }
                manager.add((IContributionItem)new Separator("basis"));
                manager.add((IContributionItem)new Separator("quick"));
                manager.add((IContributionItem)new Separator("edit"));
                manager.add((IContributionItem)new Separator("conflicts"));
                manager.add((IContributionItem)new Separator("jazz.refactoring.group"));
                Actions.this.moveToActivityContributionItem.setSelection(lastSelection);
                if (Actions.this.moveToActivityContributionItem.isNeeded()) {
                    manager.add((IContributionItem)Actions.this.moveToActivityContributionItem);
                }
                manager.add((IContributionItem)new Separator("contributor"));
                if (ContributorContextMenu.isNeeded(lastSelection)) {
                    manager.appendToGroup("contributor", (IContributionItem)contributorMenuManager);
                }
                manager.add((IContributionItem)new Separator("relatedArtifactsGroup"));
                manager.add((IContributionItem)new Separator("jazz.locking.group"));
                manager.add((IContributionItem)new Separator("jazz.compare.group"));
                manager.add((IContributionItem)new Separator("additions"));
                manager.add((IContributionItem)new Separator("expand"));
                if (lastSelection != null && !lastSelection.isEmpty()) {
                    manager.add((IContributionItem)Actions.this.expandAllContributionItem);
                }
                manager.add((IContributionItem)new Separator("jazz.properties.group"));
                if (lastSelection != null && !lastSelection.isEmpty() && Actions.allLinksSelection(lastSelection)) {
                    manager.appendToGroup("jazz.open.group", Actions.this.openLinkAction);
                }
            }
        });
        viewPart.getViewSite().registerContextMenu(String.valueOf(viewPart.getViewSite().getId()) + ".contributor", (MenuManager)contributorMenuManager, contributorMenuManager.getSelectionProvider());
        contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TreeViewer viewer = viewPart.getActiveViewer();
                viewer.setSelection(viewer.getSelection());
            }
        });
        return contextMenuManager;
    }

    private String getDeliverAllMessage(List<IWorkspaceSyncContext> elements) {
        String name = null;
        int count = 0;
        for (IWorkspaceSyncContext context : elements) {
            name = context.getLocal().getName();
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return count == 1 ? NLS.bind((String)Messages.LocalWorkspaceChangesView_40, name) : NLS.bind((String)Messages.LocalWorkspaceChangesView_41, (Object)count);
    }

    private static boolean allLinksSelection(IStructuredSelection selection) {
        if (selection == null) {
            return false;
        }
        for (Object element : selection) {
            boolean workItem;
            boolean bl = workItem = element instanceof IZoomWorkItemRoot && ((IZoomWorkItemRoot)element).getWorkItem() != null || element instanceof IFileSystemWorkItem;
            if (workItem) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        this.jobRunner.dispose();
        if (this.changesViewFilterActionGroup != null) {
            this.changesViewFilterActionGroup.dispose();
        }
        this.changesViewFilterActionGroup = null;
        this.acceptAllAction = null;
        this.checkinAllAction = null;
        this.collapseAllAction = null;
        this.copyAction = null;
        this.deliverAllAction = null;
        this.expandToChangesAction = null;
        this.expandAllContributionItem = null;
        this.loadWorkspaceAction = null;
        this.newWorkspaceAction = null;
        this.openLinkAction = null;
        this.openPreferencesAction = null;
        ((RefreshSandboxAction)this.refreshAction).dispose();
        this.refreshAction = null;
        this.renameChangeAction = null;
        this.zoomAction = null;
        this.openPortEditorAction = null;
        if (this.saveIntoContributionItem != null) {
            this.saveIntoContributionItem.dispose();
            this.saveIntoContributionItem = null;
        }
        if (this.moveToActivityContributionItem != null) {
            this.moveToActivityContributionItem.dispose();
            this.moveToActivityContributionItem = null;
        }
    }

    public void setActionsEnabledState(IStructuredSelection selection) {
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        if (model == null) {
            this.collapseAllAction.setEnabled(false);
            this.expandToChangesAction.setEnabled(false);
            this.checkinAllAction.setEnabled(false);
            this.acceptAllAction.setEnabled(false);
            this.deliverAllAction.setEnabled(false);
            return;
        }
        this.checkinAllAction.setEnabled(ComponentSyncUtil.enableCheckin((IComponentSyncModel)model));
        this.acceptAllAction.setEnabled(ComponentSyncUtil.enableAccept((IComponentSyncModel)model, (boolean)false));
        this.deliverAllAction.setEnabled(ComponentSyncUtil.enableDeliver((IComponentSyncModel)model, (boolean)false));
        this.collapseAllAction.setEnabled(true);
        if (selection != null && selection.size() > 0) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                int allowRename = RenameChangeSetUtil.allowRename(it.next());
                if (allowRename == 0 || allowRename == 1) continue;
                this.renameChangeAction.setEnabled(false);
                return;
            }
        }
        this.renameChangeAction.setEnabled(true);
    }

    public IHandler createHandler(LocalWorkspaceChangesView viewPart) {
        return new LocalWorkspaceChangesActionHandler(viewPart);
    }

    private final class LocalWorkspaceChangesActionHandler
    extends AbstractHandler {
        private final LocalWorkspaceChangesView viewPart;

        private LocalWorkspaceChangesActionHandler(LocalWorkspaceChangesView viewPart) {
            this.viewPart = viewPart;
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            Object action = null;
            AbstractActionDelegate actionDelegate = null;
            String commandId = event.getCommand().getId();
            IStructuredSelection selection = (IStructuredSelection)this.viewPart.getActiveViewer().getSelection();
            if (commandId.equals(Actions.COMMAND_DELIVER)) {
                actionDelegate = this.isSelectionType(IOutgoingBaselineGroup.class, selection) ? new DeliverBaselineGroupAction() : new DeliverAction();
                action = this.fallbackIfNoSelection(actionDelegate, this.viewPart, selection, (IAction)Actions.this.deliverAllAction);
            } else if (commandId.equals(Actions.COMMAND_ACCEPT)) {
                actionDelegate = new AcceptAction();
                action = this.fallbackIfNoSelection(actionDelegate, this.viewPart, selection, (IAction)Actions.this.acceptAllAction);
            } else if (commandId.equals(Actions.COMMAND_CHECKIN)) {
                actionDelegate = new CheckinAllAction();
                action = this.fallbackIfNoSelection(actionDelegate, this.viewPart, selection, (IAction)Actions.this.checkinAllAction);
            } else if (commandId.equals(Actions.COMMAND_SHOW_HISTORY)) {
                actionDelegate = new ShowHistoryAction();
            } else if (commandId.equals(Actions.COMMAND_CHANGE_FLOW_TARGET)) {
                actionDelegate = new SwitchCollaborationAction();
            } else if (commandId.equals(Actions.COMMAND_SHOW_SNAPSHOTS)) {
                actionDelegate = new ShowSnapshotsInWorkspaceAction();
            } else if (commandId.equals(Actions.COMMAND_SHOW_REPOSITORY_FILES)) {
                actionDelegate = new ShowRepositoryFilesAction();
            } else if (commandId.equals(Actions.COMMAND_REFRESH)) {
                action = Actions.this.refreshAction;
            } else if (commandId.equals(Actions.COMMAND_ZOOM_TOGGLE)) {
                if (Actions.this.zoomAction != null) {
                    action = Actions.this.zoomAction;
                }
            } else if (commandId.equals(Actions.COMMAND_ZOOM_TOGGLE_FULL)) {
                if (Actions.this.zoomAction != null) {
                    action = Actions.this.zoomAction.fullModeAction;
                }
            } else if (commandId.equals(Actions.COMMAND_ZOOM_TOGGLE_OUTGOING)) {
                if (Actions.this.zoomAction != null) {
                    action = Actions.this.zoomAction.outgoingWorkItemsZoomAction;
                }
            } else if (commandId.equals(Actions.COMMAND_ZOOM_TOGGLE_INCOMING)) {
                if (Actions.this.zoomAction != null) {
                    action = Actions.this.zoomAction.incomingWorkItemsZoomAction;
                }
            } else if (commandId.equals(Actions.COMMAND_ZOOM_TOGGLE_SUSPENDED)) {
                if (Actions.this.zoomAction != null) {
                    action = Actions.this.zoomAction.suspendedChangeSetsZoomAction;
                }
            } else if (commandId.equals(Actions.COMMAND_ANNOTATE)) {
                actionDelegate = new LiveAnnotate();
            } else if (commandId.equals(Actions.COMMAND_OPEN_CHANGE_EXPLORER)) {
                actionDelegate = new ShowStructuralChangesAction();
            } else if (commandId.equals(Actions.COMMAND_TRACK_WORKSPACE)) {
                actionDelegate = new TrackWorkspaceAction();
            } else if (commandId.equals(Actions.COMMAND_UNTRACK_WORKSPACE)) {
                actionDelegate = new UntrackWorkspaceAction();
            }
            if (actionDelegate != null) {
                actionDelegate.init((IViewPart)this.viewPart);
                Action tempAction = new Action(){};
                actionDelegate.selectionChanged((IAction)tempAction, (ISelection)selection);
                if (action != null && !tempAction.isEnabled()) {
                    action.run();
                } else if (actionDelegate != null && tempAction.isEnabled()) {
                    actionDelegate.run(this.viewPart.getSite().getShell(), this.viewPart.getSite().getPage(), selection);
                }
            } else if (action != null) {
                action.run();
            }
            return null;
        }

        private IAction fallbackIfNoSelection(AbstractActionDelegate actionDelegate, LocalWorkspaceChangesView viewPart, IStructuredSelection selection, IAction fallbackAction) {
            Action tempAction = new Action(){};
            if (actionDelegate != null) {
                actionDelegate.init((IViewPart)viewPart);
                actionDelegate.selectionChanged((IAction)tempAction, (ISelection)selection);
                if (selection.isEmpty() || !tempAction.isEnabled()) {
                    return fallbackAction;
                }
                return null;
            }
            return fallbackAction;
        }

        private boolean isSelectionType(Class<?> type, IStructuredSelection selection) {
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (!type.isInstance(o)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

