/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.dialogs;

import com.ibm.team.filesystem.client.internal.operations.MoveToResolveConflictOperation;
import com.ibm.team.filesystem.client.operations.MoveDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPicker;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class MoveConflictedItemsDialog
extends TitleAreaDialog {
    Collection<IConflictItem> conflictItems;
    Hashtable<IComponentSyncContext, MoveConflictedItemInfo> result = new Hashtable();
    String message;
    TableViewer movingItems;
    boolean initialized;
    Button moveButton;
    Button renameButton;
    static final String title = Messages.MoveConflictedItemsDialog_0;

    public MoveConflictedItemsDialog(Shell shell, Collection<IConflictItem> conflictItems) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.conflictItems = conflictItems;
        this.message = Messages.MoveConflictedItemsDialog_1;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(title);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getTheMessage());
        return control;
    }

    void init(IProgressMonitor monitor) throws TeamRepositoryException {
        Set contexts = ComponentSyncUtil.getContexts(this.conflictItems);
        SubMonitor mainProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)contexts.size());
        for (IComponentSyncContext context : contexts) {
            SubMonitor progress = mainProgress.newChild(1);
            progress.setWorkRemaining(100);
            MoveConflictedItemInfo info = new MoveConflictedItemInfo();
            this.result.put(context, info);
            info.context = context;
            info.conflictItems = ComponentSyncUtil.filter(this.conflictItems, (IComponentSyncContext)context);
            IComponent component = context.getComponent();
            IWorkspaceConnection wc = context.getOutgoingTeamPlace();
            ArrayList<IVersionableHandle> items = new ArrayList<IVersionableHandle>();
            for (IConflictItem ci : info.conflictItems) {
                IVersionableHandle item = ci.getLogicalChange().item();
                items.add(item);
                info.versionableStatesToMove.put(item.getItemId(), MoveConflictedItemsDialog.findVersionableStateToMove(ci));
            }
            List versionables = wc.configuration((IComponentHandle)component).fetchCompleteItems(items, (IProgressMonitor)progress.newChild(50));
            progress.setWorkRemaining(items.size() * 3);
            IVersionableManager versionableManager = SCMPlatform.getWorkspaceManager((ITeamRepository)wc.teamRepository()).versionableManager();
            int i = 0;
            while (i < items.size()) {
                IVersionableHandle handle = (IVersionableHandle)items.get(i);
                UUID uuid = handle.getItemId();
                IVersionable v = (IVersionable)versionables.get(i);
                IFolderHandle folderHandle = null;
                if (v == null) {
                    IVersionableHandle state = info.versionableStatesToMove.get(uuid);
                    v = versionableManager.fetchCompleteState(state, (IProgressMonitor)progress.newChild(1));
                    folderHandle = v.getParent();
                } else {
                    folderHandle = v.getParent();
                    progress.worked(1);
                }
                IFolderHandle folderWithState = null;
                if (folderHandle != null) {
                    try {
                        folderWithState = (IFolderHandle)wc.configuration((IComponentHandle)component).fetchCompleteItem((IVersionableHandle)folderHandle, (IProgressMonitor)progress.newChild(1));
                    }
                    catch (ItemNotFoundException itemNotFoundException) {
                        // empty catch block
                    }
                }
                if (folderWithState != null) {
                    IFolder userFolder = (IFolder)versionableManager.fetchCompleteState(folderWithState, (IProgressMonitor)progress.newChild(1));
                    info.oldFolders.put(uuid, userFolder);
                }
                ++i;
            }
            info.twins = this.searchTwins(info.context, info.conflictItems, (IProgressMonitor)progress.newChild(items.size()));
        }
        this.initialized = true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite p = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(p, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Table table = new Table(composite, 2050);
        this.movingItems = new TableViewer(table);
        this.movingItems.setContentProvider((IContentProvider)new ArrayContentProvider());
        final LocalWorkspaceChangesViewLabelProvider localLabelProvider = new LocalWorkspaceChangesViewLabelProvider();
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return localLabelProvider.getImage(element);
            }

            public String getText(Object element) {
                IConflictItem conflictItem = (IConflictItem)element;
                IComponentSyncContext context = conflictItem.getOutgoingActivitySource().getModel();
                MoveConflictedItemInfo info = MoveConflictedItemsDialog.this.result.get(context);
                IVersionableHandle item = conflictItem.getLogicalChange().item();
                UUID uuid = item.getItemId();
                String currentPath = conflictItem.getResourceName(true);
                IFolder newFolder = null;
                IFolder oldFolder = null;
                String newName = null;
                IVersionableHandle evilTwin = null;
                if (info != null) {
                    newFolder = info.newFolders.get(uuid);
                    oldFolder = info.oldFolders.get(uuid);
                    newName = info.newNames.get(uuid);
                    evilTwin = info.twins.get(uuid);
                }
                String moveDescription = "";
                moveDescription = newFolder != null ? NLS.bind((String)Messages.MoveConflictedItemsDialog_3, (Object)newFolder.getName()) : (oldFolder != null ? NLS.bind((String)Messages.MoveConflictedItemsDialog_4, (Object)oldFolder.getName()) : Messages.MoveConflictedItemsDialog_5);
                String renameDescription = "";
                if (newName != null) {
                    renameDescription = NLS.bind((String)Messages.MoveConflictedItemsDialog_7, newName);
                }
                String text = NLS.bind((String)Messages.MoveConflictedItemsDialog_8, (Object[])new Object[]{currentPath, moveDescription, renameDescription});
                if (evilTwin != null) {
                    text = evilTwin instanceof IFolderHandle ? String.valueOf(text) + Messages.MoveConflictedItemsDialog_9 : String.valueOf(text) + Messages.MoveConflictedItemsDialog_10;
                }
                return text;
            }
        };
        this.movingItems.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)new LocalSynchronizeDecorator(){

            @Override
            public String decorateText(String text, Object element) {
                return text;
            }
        }));
        Composite buttonsComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)buttonsComposite);
        this.moveButton = new Button(buttonsComposite, 8);
        this.moveButton.setText(Messages.MoveConflictedItemsDialog_11);
        this.renameButton = new Button(buttonsComposite, 8);
        this.renameButton.setText(Messages.MoveConflictedItemsDialog_12);
        this.movingItems.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MoveConflictedItemsDialog.this.updateButtons();
            }
        });
        this.moveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                List conflicts = ((IStructuredSelection)MoveConflictedItemsDialog.this.movingItems.getSelection()).toList();
                Set contexts = ComponentSyncUtil.getContexts((Collection)conflicts);
                if (contexts.size() != 1) {
                    return;
                }
                IComponentSyncContext context = (IComponentSyncContext)contexts.toArray()[0];
                final IConflictItem conflictItem = (IConflictItem)conflicts.get(0);
                MoveConflictedItemInfo info = MoveConflictedItemsDialog.this.result.get(context);
                final IWorkspaceConnection wc = context.getOutgoingTeamPlace();
                IComponent component = context.getComponent();
                final Shell shell = MoveConflictedItemsDialog.this.moveButton.getShell();
                new Job(Messages.MoveConflictedItemsDialog_13, (IComponentHandle)component, conflicts, info, context){
                    private final /* synthetic */ IComponentHandle val$component;
                    private final /* synthetic */ List val$conflicts;
                    private final /* synthetic */ MoveConflictedItemInfo val$info;
                    private final /* synthetic */ IComponentSyncContext val$context;
                    {
                        this.val$component = iComponentHandle;
                        this.val$conflicts = list;
                        this.val$info = moveConflictedItemInfo;
                        this.val$context = iComponentSyncContext;
                        super($anonymous0);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        IVersionableHandle versionableHandle = MoveConflictedItemsDialog.findVersionableStateToMove(conflictItem);
                        IVersionableManager versionableManager = SCMPlatform.getWorkspaceManager((ITeamRepository)wc.teamRepository()).versionableManager();
                        IVersionable versionable = null;
                        try {
                            versionable = versionableManager.fetchCompleteState(versionableHandle, (IProgressMonitor)progress.newChild(50));
                        }
                        catch (TeamRepositoryException e) {
                            StatusUtil.log((Object)((Object)this), (Throwable)e);
                        }
                        final IFolderHandle parent = versionable != null ? versionable.getParent() : null;
                        final IFolderHandle[] result = new IFolderHandle[1];
                        shell.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                result[0] = RepositoryFilesPicker.pickFolder(shell, wc, val$component, new IVersionableHandle[]{parent}, Messages.MoveConflictedItemsDialog_14);
                            }
                        });
                        IFolder newFolder = null;
                        if (result[0] != null) {
                            try {
                                newFolder = (IFolder)wc.configuration(this.val$component).fetchCompleteItem((IVersionableHandle)result[0], (IProgressMonitor)progress.newChild(40));
                            }
                            catch (TeamRepositoryException e) {
                                StatusUtil.log((Object)((Object)this), (Throwable)e);
                                return StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                            }
                            for (IConflictItem ci : this.val$conflicts) {
                                IVersionableHandle item = ci.getLogicalChange().item();
                                this.val$info.newFolders.put(item.getItemId(), newFolder);
                            }
                            try {
                                this.val$info.twins = MoveConflictedItemsDialog.this.searchTwins(this.val$context, this.val$conflicts, (IProgressMonitor)progress.newChild(10));
                            }
                            catch (TeamRepositoryException e) {
                                StatusUtil.log((Object)((Object)this), (Throwable)e);
                                return StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                            }
                            shell.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ((this).this).MoveConflictedItemsDialog.this.movingItems.refresh();
                                    MoveConflictedItemsDialog.this.updateButtons();
                                }
                            });
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        });
        this.renameButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Shell shell;
                RenameItemDialog dialog;
                final List conflicts = ((IStructuredSelection)MoveConflictedItemsDialog.this.movingItems.getSelection()).toList();
                if (conflicts.size() != 1) {
                    return;
                }
                IConflictItem conflictItem = (IConflictItem)conflicts.get(0);
                final IComponentSyncContext context = conflictItem.getOutgoingActivitySource().getModel();
                final MoveConflictedItemInfo info = MoveConflictedItemsDialog.this.result.get(context);
                IVersionableHandle item = conflictItem.getLogicalChange().item();
                UUID uuid = item.getItemId();
                String currentName = info.newNames.get(uuid);
                if (currentName == null) {
                    currentName = conflictItem.getResourceName(false);
                }
                if ((dialog = new RenameItemDialog(shell = MoveConflictedItemsDialog.this.moveButton.getShell(), currentName)).open() != 0) {
                    return;
                }
                String name = dialog.getName();
                info.newNames.put(item.getItemId(), name);
                if (name.equals(conflictItem.getResourceName(false))) {
                    info.newNames.remove(item.getItemId());
                }
                new Job(Messages.MoveConflictedItemsDialog_15){

                    protected IStatus run(IProgressMonitor monitor) {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        try {
                            info.twins = MoveConflictedItemsDialog.this.searchTwins(context, conflicts, (IProgressMonitor)progress);
                            shell.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ((this).this).MoveConflictedItemsDialog.this.movingItems.refresh();
                                    MoveConflictedItemsDialog.this.updateButtons();
                                }
                            });
                        }
                        catch (TeamRepositoryException e) {
                            StatusUtil.log((Object)((Object)this), (Throwable)e);
                            return StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        });
        this.moveButton.setEnabled(false);
        this.renameButton.setEnabled(false);
        this.movingItems.setInput(this.conflictItems);
        GridLayoutFactory.fillDefaults().generateLayout(buttonsComposite);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).numColumns(2).generateLayout(composite);
        return parent;
    }

    void updateButtons() {
        int size = ((IStructuredSelection)this.movingItems.getSelection()).size();
        List conflicts = ((IStructuredSelection)this.movingItems.getSelection()).toList();
        Set contexts = ComponentSyncUtil.getContexts((Collection)conflicts);
        this.moveButton.setEnabled(this.initialized && contexts.size() == 1);
        this.renameButton.setEnabled(this.initialized && size == 1);
        int missingParentsCount = this.missingParentsCount();
        int evilTwinCount = 0;
        for (Map.Entry<IComponentSyncContext, MoveConflictedItemInfo> entry : this.result.entrySet()) {
            evilTwinCount += entry.getValue().twins.size();
        }
        this.getButton(0).setEnabled(this.initialized && missingParentsCount == 0 && evilTwinCount == 0);
        if (missingParentsCount != 0 || evilTwinCount != 0) {
            String message = "";
            if (evilTwinCount != 0) {
                message = String.valueOf(message) + (evilTwinCount == 1 ? Messages.MoveConflictedItemsDialog_17 : NLS.bind((String)Messages.MoveConflictedItemsDialog_26, (Object)evilTwinCount));
            }
            if (missingParentsCount != 0) {
                message = String.valueOf(message) + (missingParentsCount == 1 ? Messages.MoveConflictedItemsDialog_19 : NLS.bind((String)Messages.MoveConflictedItemsDialog_27, (Object)missingParentsCount));
            }
            this.setErrorMessage(message);
        } else {
            this.setErrorMessage(null);
        }
        this.setTitle(this.getTitle());
        this.setMessage(this.getTheMessage());
    }

    String getTitle() {
        return title;
    }

    String getTheMessage() {
        return this.initialized ? this.message : Messages.MoveConflictedItemsDialog_21;
    }

    int missingParentsCount() {
        if (!this.initialized) {
            return 0;
        }
        int required = 0;
        for (IConflictItem conflictItem : this.conflictItems) {
            if (!this.isMissingParent(conflictItem)) continue;
            ++required;
        }
        return required;
    }

    boolean isMissingParent(IConflictItem conflictItem) {
        if (!this.initialized) {
            return false;
        }
        IComponentSyncContext context = conflictItem.getOutgoingActivitySource().getModel();
        MoveConflictedItemInfo info = this.result.get(context);
        UUID uuid = conflictItem.getLogicalChange().item().getItemId();
        IFolder newFolder = info.newFolders.get(uuid);
        IFolder oldFolder = info.oldFolders.get(uuid);
        return oldFolder == null && newFolder == null;
    }

    Hashtable<UUID, IVersionableHandle> searchTwins(IComponentSyncContext context, Collection<IConflictItem> conflictItems, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)conflictItems.size());
        MoveConflictedItemInfo info = this.result.get(context);
        Hashtable<UUID, IVersionableHandle> result = new Hashtable<UUID, IVersionableHandle>();
        for (IConflictItem conflictItem : conflictItems) {
            Map entries;
            IVersionableHandle twin;
            IWorkspaceConnection wc = context.getOutgoingTeamPlace();
            IComponent component = context.getComponent();
            IVersionableHandle item = conflictItem.getLogicalChange().item();
            UUID uuid = item.getItemId();
            IFolder folder = info.newFolders.get(uuid);
            if (folder == null) {
                folder = info.oldFolders.get(uuid);
            }
            if (folder == null) continue;
            String name = info.newNames.get(uuid);
            if (name == null) {
                name = conflictItem.getResourceName(false);
            }
            if ((twin = (IVersionableHandle)(entries = wc.configuration((IComponentHandle)component).childEntries((IFolderHandle)folder, (IProgressMonitor)progress.newChild(1))).get(name)) == null || twin.sameItemId((IItemHandle)item)) continue;
            result.put(uuid, twin);
        }
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public int open() {
        final Display display = Display.getCurrent();
        new Job(Messages.MoveConflictedItemsDialog_22){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    MoveConflictedItemsDialog.this.init(monitor);
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).MoveConflictedItemsDialog.this.movingItems.refresh();
                            MoveConflictedItemsDialog.this.updateButtons();
                        }
                    });
                }
                catch (TeamRepositoryException e) {
                    return StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule(1000L);
        return super.open();
    }

    protected Point getInitialSize() {
        return new Point(this.convertHorizontalDLUsToPixels(500), this.convertVerticalDLUsToPixels(200));
    }

    public Hashtable<IComponentSyncContext, MoveConflictedItemInfo> getResult() {
        return this.result;
    }

    public MoveToResolveConflictOperation getMoveOperation(MoveDilemmaHandler handler) {
        MoveToResolveConflictOperation op = new MoveToResolveConflictOperation(handler);
        for (Map.Entry<IComponentSyncContext, MoveConflictedItemInfo> resultEntry : this.result.entrySet()) {
            MoveConflictedItemInfo info = resultEntry.getValue();
            IComponentSyncContext context = resultEntry.getKey();
            ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
            IWorkspaceConnection wc = context.getOutgoingTeamPlace();
            IComponent component = context.getComponent();
            for (Map.Entry<UUID, IVersionableHandle> entry : info.versionableStatesToMove.entrySet()) {
                String newName;
                UUID uuid = entry.getKey();
                IVersionableHandle stateToMove = entry.getValue();
                IFolder parent = info.newFolders.get(uuid);
                if (parent == null) {
                    parent = info.oldFolders.get(uuid);
                }
                if ((newName = info.newNames.get(uuid)) != null) {
                    op.move(wc, (IComponentHandle)component, stateToMove, (IFolderHandle)parent, newName, conflictReport);
                    continue;
                }
                op.move(wc, (IComponentHandle)component, stateToMove, (IFolderHandle)parent, conflictReport);
            }
        }
        return op;
    }

    public static IVersionableHandle findVersionableStateToMove(IConflictItem conflictItem) {
        IComponentSyncContext context = conflictItem.getOutgoingActivitySource().getModel();
        ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
        IVersionableHandle versionableHandle = conflictItem.getLogicalChange().item();
        for (IItemConflictReport baseConflict : conflictReport.conflictReport().conflicts()) {
            if (!baseConflict.item().sameItemId((IItemHandle)versionableHandle)) continue;
            if (baseConflict.getSelectedContributorState() != null) {
                versionableHandle = baseConflict.getSelectedContributorState();
                break;
            }
            if (baseConflict.getProposedContributorState() != null) {
                versionableHandle = baseConflict.getProposedContributorState();
                break;
            }
            throw new IllegalStateException("Can no longer find the item to be merged");
        }
        return versionableHandle;
    }

    public static class MoveConflictedItemInfo {
        public IComponentSyncContext context;
        public Collection<IConflictItem> conflictItems = new ArrayList<IConflictItem>();
        public Hashtable<UUID, IFolder> oldFolders = new Hashtable();
        public Hashtable<UUID, IFolder> newFolders = new Hashtable();
        public Hashtable<UUID, String> newNames = new Hashtable();
        public Hashtable<UUID, IVersionableHandle> versionableStatesToMove = new Hashtable();
        public Hashtable<UUID, IVersionableHandle> twins = new Hashtable();
    }

    class RenameItemDialog
    extends MessageDialog {
        String name;
        Text text;

        public RenameItemDialog(Shell shell, String name) {
            super(shell, Messages.MoveConflictedItemsDialog_24, null, Messages.MoveConflictedItemsDialog_25, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.name = name;
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
            this.text = new Text(composite, 2048);
            this.text.setText(this.name);
            GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout(composite);
            return parent;
        }

        protected void buttonPressed(int buttonId) {
            this.name = this.text.getText();
            super.buttonPressed(buttonId);
        }

        public String getName() {
            return this.name;
        }
    }
}

