/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.dialogs;

import com.ibm.team.filesystem.ui.changes.RenameChangeSetUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.scm.common.links.ChangeSetLocationFactory;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class EditCommentDialog
extends Dialog {
    private Text text;
    private Combo combo;
    private String value;
    private static final String title = Messages.EditCommentDialog_0;
    private static final String message = Messages.EditCommentDialog_1;
    private static final String previous = Messages.EditCommentDialog_2;

    public EditCommentDialog(Shell parentShell, String comment) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.value = comment;
    }

    protected Control createDialogArea(Composite parent) {
        int width;
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 0);
        label.setText(message);
        GridData data = new GridData(4, 4, false, false);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.text = new Text(composite, 2626);
        this.text.setText(this.value);
        GridData textData = new GridData(4, 4, true, true);
        textData.widthHint = width = this.convertHorizontalDLUsToPixels(300);
        textData.heightHint = RenameChangeSetUtil.computeTextHeight(this.text, width, 4);
        this.text.setLayoutData((Object)textData);
        this.text.setFocus();
        this.text.selectAll();
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                boolean traverse_return;
                boolean ctrl = (e.stateMask & 0x40000) != 0;
                boolean bl = traverse_return = e.detail == 4;
                if (ctrl && traverse_return) {
                    EditCommentDialog.this.value = EditCommentDialog.this.text.getText();
                    EditCommentDialog.this.okPressed();
                }
            }
        });
        Label mruLabel = new Label(composite, 64);
        mruLabel.setText(previous);
        mruLabel.setLayoutData((Object)data);
        this.combo = new Combo(composite, 2056);
        GridData comboData = new GridData(4, 4, true, false);
        comboData.widthHint = width;
        this.combo.setLayoutData((Object)comboData);
        final LinkedList<String> comments = RenameChangeSetUtil.loadMruComments();
        for (String comment : comments) {
            this.combo.add(ChangeSetLocationFactory.replaceLineEnding((String)comment, (String)" "));
        }
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditCommentDialog.this.text.setText((String)comments.get(EditCommentDialog.this.combo.getSelectionIndex()));
                EditCommentDialog.this.text.setFocus();
                EditCommentDialog.this.text.selectAll();
            }
        });
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(title);
    }

    protected void buttonPressed(int buttonId) {
        this.value = this.text.getText();
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.saveOnOk(this.value);
        RenameChangeSetUtil.updateMruComments(this.value);
        super.okPressed();
    }

    protected abstract void saveOnOk(String var1);
}

