/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.dialogs;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.AutoResolveAction;
import com.ibm.team.filesystem.ui.changes.dialogs.ConflictsPromptDialog;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ConflictsPromptManager
implements IListener {
    static ConflictsPromptManager INSTANCE = null;
    List<IConflictItem> previousConflicts = Collections.emptyList();
    volatile boolean isConflictsPromptDialogOpened;
    UIJob job;
    UIContext lastContext;

    public static synchronized ConflictsPromptManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConflictsPromptManager();
        }
        return INSTANCE;
    }

    private ConflictsPromptManager() {
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        model.addGenericListener((Object)"refreshedRemoteAcceptCompleted", (IListener)this);
        model.addGenericListener((Object)"refreshedRemoteCompleted", (IListener)this);
        model.getLocalSynchronizationManager().addGenericListener((Object)"loadedComponents", (IListener)this);
    }

    public void dispose() {
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        model.removeGenericListener((Object)"refreshedRemoteAcceptCompleted", (IListener)this);
        model.removeGenericListener((Object)"refreshedRemoteCompleted", (IListener)this);
        model.getLocalSynchronizationManager().removeGenericListener((Object)"loadedComponents", (IListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(List events) {
        if (!UiPlugin.getBooleanPreference("com.ibm.team.filesystem.ide.ui.prefs_show_conflict_prompt_dialog_on_conflict") || UiPlugin.getBooleanPreference("com.ibm.team.filesystem.ide.ui.prefs_attempt_to_auto_resolve_conflicts_on_accept")) {
            return;
        }
        boolean notifyAccept = false;
        for (IEvent event : events) {
            if (event.getEventType() != "refreshedRemoteAcceptCompleted") continue;
            notifyAccept = true;
            break;
        }
        if (!notifyAccept) {
            return;
        }
        ConflictsPromptManager conflictsPromptManager = this;
        synchronized (conflictsPromptManager) {
            Set<IComponentSyncContext> contexts = null;
            List<IConflictItem> conflictedItems = AutoResolveAction.getConflictedItems();
            int i = 0;
            while (i < 10) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    break;
                }
                List<IConflictItem> newConflictedItems = AutoResolveAction.getConflictedItems();
                if (conflictedItems.size() == newConflictedItems.size()) break;
                conflictedItems = newConflictedItems;
                ++i;
            }
            contexts = this.newConflicts(this.previousConflicts, conflictedItems);
            this.previousConflicts = conflictedItems;
            if (contexts.isEmpty()) {
                return;
            }
            LocalWorkspaceChangesView.requestShowPendingView();
            if (!this.isConflictsPromptDialogOpened) {
                this.isConflictsPromptDialogOpened = true;
                UIJob job = new UIJob(Messages.ConflictsPromptManager_jobName){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        try {
                            Shell shell;
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            Shell shell2 = shell = window != null ? window.getShell() : null;
                            if (shell != null) {
                                List<IConflictItem> items = AutoResolveAction.getConflictedItems();
                                ConflictsPromptDialog dialog = new ConflictsPromptDialog(shell, items);
                                dialog.open();
                                if (dialog.getAutoResolve()) {
                                    items = AutoResolveAction.getConflictedItems();
                                    AutoResolveAction.autoResolve(ConflictsPromptManager.this.getContext(shell), items);
                                }
                            }
                        }
                        finally {
                            ConflictsPromptManager.this.isConflictsPromptDialogOpened = false;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    private UIContext getContext(Shell shell) {
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww == null) {
            throw new IllegalStateException("No active workbench page");
        }
        IWorkbenchPage page = ww.getActivePage();
        if (page == null) {
            throw new IllegalStateException("No active workbench page");
        }
        if (this.lastContext == null || !page.equals(this.lastContext.getPage())) {
            this.lastContext = UIContext.createPageContext((Shell)shell, (IWorkbenchPage)page);
        }
        return this.lastContext;
    }

    private Set<IComponentSyncContext> newConflicts(List<IConflictItem> oldConflicts, List<IConflictItem> newConflicts) {
        HashSet<IComponentSyncContext> result = new HashSet<IComponentSyncContext>();
        for (IConflictItem newConflict : newConflicts) {
            if (oldConflicts.contains(newConflict)) continue;
            result.add(newConflict.getOutgoingActivitySource().getModel());
        }
        return result;
    }
}

