/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.dialogs;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConflictsPromptDialog
extends MessageDialogWithToggle {
    boolean autoResolve;
    boolean resolveLater;
    Collection<IConflictItem> items;

    public ConflictsPromptDialog(Shell parent, Collection<IConflictItem> items) {
        super(parent, Messages.ConflictsPromptDialog_0, null, ConflictsPromptDialog.getMessage(items), 2, new String[]{Messages.ConflictsPromptDialog_8, Messages.ConflictsPromptDialog_9}, 0, Messages.ConflictsPromptDialog_2, false);
        this.setPrefStore(UiPlugin.getDefault().getPreferenceStore());
        this.setPrefKey("com.ibm.team.filesystem.ide.ui.prefs_show_conflict_prompt_dialog_on_conflict");
        this.items = items;
    }

    protected Control createMessageArea(Composite parent) {
        super.createMessageArea(parent);
        Link link = new Link(parent, 0);
        link.setText(Messages.ConflictsPromptDialog_5);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.team.filesystem.ide.ui.action_howtoresolveconflicts");
            }
        });
        GridData data = new GridData(0);
        data.horizontalSpan = 2;
        link.setLayoutData((Object)data);
        link.setFont(parent.getFont());
        return parent;
    }

    private static String getMessage(Collection<IConflictItem> items) {
        String componentName;
        Set components = ComponentSyncUtil.getContexts(items);
        int nComponents = components.size();
        String string = componentName = nComponents == 1 ? ((IComponentSyncContext)components.iterator().next()).getComponent().getName() : null;
        if (items.size() == 1 && nComponents == 1) {
            return NLS.bind((String)Messages.ConflictsPromptDialog_7, (Object)componentName);
        }
        if (items.size() > 1 && nComponents == 1) {
            return NLS.bind((String)Messages.ConflictsPromptDialog_1, (Object)items.size(), (Object)componentName);
        }
        if (items.size() == 1 && nComponents > 1) {
            return NLS.bind((String)Messages.ConflictsPromptDialog_12, (Object)nComponents);
        }
        if (items.size() > 1 && nComponents > 1) {
            return NLS.bind((String)Messages.ConflictsPromptDialog_13, (Object)items.size(), (Object)nComponents);
        }
        return "";
    }

    protected void buttonPressed(int buttonId) {
        this.autoResolve = buttonId == 256;
        this.resolveLater = buttonId == 257;
        super.buttonPressed(buttonId);
        if (this.autoResolve || this.resolveLater) {
            this.getPrefStore().setValue(this.getPrefKey(), !this.getToggleState());
        }
    }

    public boolean getAutoResolve() {
        return this.autoResolve;
    }

    public boolean getResolveLater() {
        return this.resolveLater;
    }
}

