/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.dialogs;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.ui.changes.RenameRemoteActivityComment;
import com.ibm.team.filesystem.ui.changes.actions.MoveToActivityContributionItem;
import com.ibm.team.filesystem.ui.changes.configuration.ChangesSorter;
import com.ibm.team.filesystem.ui.changes.dialogs.EditCommentDialog;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewContentProvider;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnDiscardUser;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;

public class ChangesDialog
extends TitleAreaDialog
implements IListener {
    private static final String statusStr = Messages.ChangesDialog_0;
    private CheckboxTableViewer changesViewer;
    private Label flowLabel;
    private TreeViewer detailsViewer;
    private Label statusLabel;
    private IWorkbenchPage targetPage;
    private Object remoteActivities;
    private Collection associatedRemoteActivities;
    private Collection conflictedRemoteActivities;
    private List selectedResources;
    private boolean isAccept;
    private String title;
    private String message;
    private String errorMessage;
    private List<IRemoteActivity> selectedActivities;
    private Object selectedActivity;
    private int checkedChanges;
    private UIJob refreshUIJob;
    private StructuredSelection currentSelection;
    private MoveToActivityContributionItem moveToActivityContributionItem;
    private IStructuredSelection selectedChanges;

    public ChangesDialog(IWorkbenchPart targetPart, Collection remoteActivities, Collection associatedRemoteActivities, Collection conflictedRemoteActivities, List selectedResources, boolean isAccept) {
        super(targetPart.getSite().getShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.targetPage = targetPart.getSite().getPage();
        this.remoteActivities = remoteActivities;
        this.associatedRemoteActivities = associatedRemoteActivities;
        this.conflictedRemoteActivities = conflictedRemoteActivities;
        this.selectedResources = selectedResources;
        this.isAccept = isAccept;
        if (isAccept) {
            this.title = Messages.ChangesDialog_1;
            this.message = Messages.ChangesDialog_2;
        } else {
            this.title = Messages.ChangesDialog_3;
            this.message = Messages.ChangesDialog_4;
            this.errorMessage = Messages.ChangesDialog_5;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(this.title);
        this.setMessage(this.message);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Object obj;
        Composite p = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(p, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Table table = new Table(composite, 2080);
        this.changesViewer = new CheckboxTableViewer(table);
        this.changesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (this.isAccept) {
            this.changesViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new LocalWorkspaceChangesViewLabelProvider(), (ILabelDecorator)new LocalSynchronizeDecorator()));
        } else {
            LocalSynchronizeDecorator labelDecorator = new LocalSynchronizeDecorator(){

                @Override
                public String decorateText(String text, Object element) {
                    return text;
                }
            };
            LocalWorkspaceChangesViewLabelProvider labelProvider = new LocalWorkspaceChangesViewLabelProvider();
            this.changesViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)labelDecorator));
            this.moveToActivityContributionItem = new MoveToActivityContributionItem(labelProvider, labelDecorator);
        }
        this.changesViewer.setSorter((ViewerSorter)new ChangesSorter());
        this.changesViewer.setInput(this.remoteActivities);
        this.changesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ChangesDialog.this.checkedChanges = ChangesDialog.this.changesViewer.getCheckedElements().length;
                ChangesDialog.this.statusLabel.setText(String.valueOf(statusStr) + ChangesDialog.this.checkedChanges);
                if (ChangesDialog.this.isAccept) {
                    ChangesDialog.this.getButton(0).setEnabled(ChangesDialog.this.checkedChanges > 0);
                } else {
                    ChangesDialog.this.getButton(0).setEnabled(ChangesDialog.this.isValidSelection() && ChangesDialog.this.checkedChanges > 0);
                }
            }
        });
        this.changesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ss = (StructuredSelection)event.getSelection();
                if (ChangesDialog.this.currentSelection == null || !ChangesDialog.this.currentSelection.equals((Object)ss)) {
                    ChangesDialog.this.selectedActivity = ss.getFirstElement();
                    ChangesDialog.this.detailsViewer.setInput(ChangesDialog.this.selectedActivity);
                    ChangesDialog.this.detailsViewer.expandAll();
                    ChangesDialog.this.currentSelection = ss;
                    if (!ChangesDialog.this.isAccept && ChangesDialog.this.selectedActivity != null) {
                        IComponentSyncContext componentSyncContext = ((IRemoteActivity)ChangesDialog.this.selectedActivity).getActivitySource().getModel();
                        String componentName = componentSyncContext.getComponent().getName();
                        String localWorkspaceName = componentSyncContext.getWorkspaceSyncContext().getLocal().getName();
                        String remoteWorkspaceName = componentSyncContext.getComponentSyncInfo().getRemoteOutgoing().getName();
                        ChangesDialog.this.flowLabel.setText(NLS.bind((String)Messages.ChangesDialog_6, (Object[])new Object[]{localWorkspaceName, componentName, remoteWorkspaceName, componentName}));
                    }
                    if (!ChangesDialog.this.isAccept && ChangesDialog.this.getButton(1024) != null) {
                        ChangesDialog.this.getButton(1024).setEnabled(ChangesDialog.this.selectedActivity != null);
                    }
                }
            }
        });
        if (!this.isAccept) {
            final IWorkbenchPartSite site = this.targetPage.getActivePart().getSite();
            Action renameAction = new Action(Messages.ChangesDialog_7){

                public void run() {
                    TableItem[] items = ChangesDialog.this.changesViewer.getTable().getSelection();
                    final RenameRemoteActivityComment rename = RenameRemoteActivityComment.create((Item[])items, (ColumnViewer)ChangesDialog.this.changesViewer, site);
                    if (rename == null) {
                        return;
                    }
                    String comment = rename.getFirstComment();
                    EditCommentDialog dialog = new EditCommentDialog(ChangesDialog.this.getShell(), comment){

                        @Override
                        protected void saveOnOk(String value) {
                            rename.saveTask(value);
                        }
                    };
                    dialog.open();
                }
            };
            Action discardAction = new Action(Messages.ChangesDialog_8){

                public void run() {
                    ChangesDialog.this.discardChange(ChangesDialog.this.selectedActivity);
                }
            };
            MenuManager changesViewerMenuMgr = new MenuManager();
            this.changesViewer.getTable().setMenu(changesViewerMenuMgr.createContextMenu((Control)this.changesViewer.getTable()));
            changesViewerMenuMgr.setRemoveAllWhenShown(true);
            changesViewerMenuMgr.addMenuListener(new IMenuListener((IAction)discardAction, (IAction)renameAction){
                private final /* synthetic */ IAction val$discardAction;
                private final /* synthetic */ IAction val$renameAction;
                {
                    this.val$discardAction = iAction;
                    this.val$renameAction = iAction2;
                }

                public void menuAboutToShow(IMenuManager manager) {
                    manager.add(this.val$discardAction);
                    manager.add(this.val$renameAction);
                    this.val$discardAction.setEnabled(ChangesDialog.this.canDiscard(ChangesDialog.this.selectedActivity));
                }
            });
        }
        new Label(composite, 0).setText(Messages.ChangesDialog_9);
        if (!this.isAccept) {
            this.flowLabel = new Label(composite, 64);
        }
        Tree tree = new Tree(composite, 2050);
        this.detailsViewer = new TreeViewer(tree);
        this.detailsViewer.setContentProvider((IContentProvider)new LocalWorkspaceChangesViewContentProvider());
        this.detailsViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new LocalWorkspaceChangesViewLabelProvider(), (ILabelDecorator)new LocalSynchronizeDecorator()));
        this.detailsViewer.setSorter((ViewerSorter)new ChangesSorter());
        if (!this.isAccept) {
            this.detailsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ChangesDialog.this.selectedChanges = (IStructuredSelection)ChangesDialog.this.detailsViewer.getSelection();
                }
            });
            MenuManager detailsViewMenuMgr = new MenuManager();
            this.detailsViewer.getTree().setMenu(detailsViewMenuMgr.createContextMenu((Control)this.detailsViewer.getTree()));
            detailsViewMenuMgr.setRemoveAllWhenShown(true);
            detailsViewMenuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    ChangesDialog.this.moveToActivityContributionItem.setSelection(ChangesDialog.this.selectedChanges);
                    if (ChangesDialog.this.moveToActivityContributionItem.isNeeded()) {
                        manager.add((IContributionItem)ChangesDialog.this.moveToActivityContributionItem);
                    }
                }
            });
        }
        this.statusLabel = new Label(composite, 0);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout(composite);
        if (!this.isAccept) {
            this.refreshUIJob = new UIJob(Messages.ChangesDialog_10){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (ChangesDialog.this.changesViewer != null && !ChangesDialog.this.changesViewer.getTable().isDisposed() && ChangesDialog.this.detailsViewer != null && !ChangesDialog.this.detailsViewer.getTree().isDisposed()) {
                        Object obj;
                        if (ChangesDialog.this.changesViewer.getInput() != ChangesDialog.this.remoteActivities) {
                            ChangesDialog.this.changesViewer.setInput(ChangesDialog.this.remoteActivities);
                        } else {
                            ChangesDialog.this.changesViewer.refresh();
                        }
                        ChangesDialog.this.detailsViewer.refresh();
                        if (ChangesDialog.this.changesViewer.getSelection().isEmpty() && (obj = ChangesDialog.this.changesViewer.getElementAt(0)) != null) {
                            ChangesDialog.this.changesViewer.setSelection((ISelection)new StructuredSelection(obj));
                        }
                        ChangesDialog.this.checkedChanges = ChangesDialog.this.changesViewer.getCheckedElements().length;
                        ChangesDialog.this.statusLabel.setText(String.valueOf(statusStr) + ChangesDialog.this.checkedChanges);
                        Button b = ChangesDialog.this.getButton(0);
                        if (b != null && !b.isDisposed()) {
                            b.setEnabled(ChangesDialog.this.isValidSelection() && ChangesDialog.this.checkedChanges > 0);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.hookInput();
        }
        if ((obj = this.changesViewer.getElementAt(0)) != null) {
            this.changesViewer.setSelection((ISelection)new StructuredSelection(obj));
        }
        this.changesViewer.setCheckedElements(this.associatedRemoteActivities.toArray());
        this.checkedChanges = this.changesViewer.getCheckedElements().length;
        this.statusLabel.setText(String.valueOf(statusStr) + this.checkedChanges);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1024, Messages.ChangesDialog_11, false);
        this.getButton(1024).addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    ChangesDialog.this.targetPage.showView("com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView");
                    ChangesDialog.this.cancelPressed();
                    IViewPart viewPart = ChangesDialog.this.targetPage.findView("com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView");
                    if (viewPart != null && ChangesDialog.this.selectedActivity != null) {
                        LocalWorkspaceChangesView pendingChangesView = (LocalWorkspaceChangesView)viewPart;
                        pendingChangesView.getActiveChangesViewPage().show((IRemoteActivity)ChangesDialog.this.selectedActivity);
                    }
                }
                catch (PartInitException e1) {
                    StatusUtil.log(this.getClass(), (Throwable)e1);
                }
            }
        });
        super.createButtonsForButtonBar(parent);
        if (this.isAccept) {
            this.getButton(0).setEnabled(this.checkedChanges > 0);
        } else {
            this.getButton(0).setEnabled(this.isValidSelection() && this.checkedChanges > 0);
        }
    }

    protected void okPressed() {
        this.selectedActivities = new ArrayList<IRemoteActivity>();
        Object[] checkedElements = this.changesViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            Object o = checkedElements[i];
            IRemoteActivity activity = (IRemoteActivity)o;
            this.selectedActivities.add(activity);
            ++i;
        }
        super.okPressed();
    }

    public boolean close() {
        if (!this.isAccept) {
            this.unhookInput();
            this.refreshUIJob.cancel();
            this.refreshUIJob = null;
        }
        return super.close();
    }

    protected Point getInitialSize() {
        return new Point(this.convertHorizontalDLUsToPixels(450), this.convertVerticalDLUsToPixels(300));
    }

    public List<IRemoteActivity> getSelectedActivities() {
        return this.selectedActivities;
    }

    private void hookInput() {
        FileSystemResourcesPlugin.getComponentSyncModel().addGenericListener((IListener)this);
    }

    private void unhookInput() {
        FileSystemResourcesPlugin.getComponentSyncModel().removeGenericListener((IListener)this);
    }

    public void handleEvents(List events) {
        for (IEvent event : events) {
            if (event.getEventType() != "refreshedRemoteCompleted") continue;
            Collection[] results = ComponentSyncUtil.getRemoteActivities((Collection)this.selectedResources, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
            this.remoteActivities = results[0];
            this.conflictedRemoteActivities = results[2];
        }
        if (this.refreshUIJob == null) {
            return;
        }
        this.refreshUIJob.schedule(1000L);
    }

    private boolean canDiscard(Object element) {
        IRemoteActivity activity = (IRemoteActivity)element;
        return activity.getChanges().isEmpty();
    }

    private void discardChange(Object element) {
        final IRemoteActivity activity = (IRemoteActivity)element;
        final String name = Messages.ChangesDialog_12;
        final Shell shell = this.getShell();
        Job job = new Job(name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        monitor.beginTask(name, 100);
                        IComponentSyncContext context = activity.getActivitySource().getModel();
                        HashSet<IRemoteActivity> activities = new HashSet<IRemoteActivity>();
                        activities.add(activity);
                        context.discardChangeSets(activities, (DiscardDilemmaHandler)new WarnDiscardUser(shell, this.getName()), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        ((Collection)ChangesDialog.this.remoteActivities).remove(ChangesDialog.this.selectedActivity);
                        context.refresh(false, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    }
                    catch (FileSystemException e) {
                        IStatus iStatus = StatusUtil.newStatus((Object)"com.ibm.team.filesystem.ide.ui", (String)Messages.ChangesDialog_13, (Throwable)e);
                        monitor.done();
                        return iStatus;
                    }
                    catch (TeamRepositoryException e) {
                        IStatus iStatus = StatusUtil.newStatus((Object)"com.ibm.team.filesystem.ide.ui", (String)Messages.ChangesDialog_14, (Throwable)e);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private boolean isValidSelection() {
        Object[] checkedElements = this.changesViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            Object o = checkedElements[i];
            IRemoteActivity activity = (IRemoteActivity)o;
            if (this.conflictedRemoteActivities.contains(activity)) {
                this.setErrorMessage(this.errorMessage);
                return false;
            }
            ++i;
        }
        this.setErrorMessage(null);
        return true;
    }
}

