/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.dialogs;

import com.ibm.team.filesystem.ui.domain.MyWorkspacesDomainTreeProvider;
import com.ibm.team.filesystem.ui.wizards.newworkspace.NewWorkspaceWizard;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;

public class AllMyWorkspacesDialog
extends TitleAreaDialog {
    SimpleTableViewer<AbstractPlaceWrapper> viewer;
    ContributorPlaceWrapper workspace;
    private final IWorkbenchPart part;
    private LocalResourceManager localResourceManager;

    public AllMyWorkspacesDialog(IWorkbenchPart part) {
        super(part.getSite().getShell());
        this.part = part;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.AllMyWorkspacesDialog_0);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(Messages.AllMyWorkspacesDialog_1);
        this.setMessage(Messages.AllMyWorkspacesDialog_2);
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources(), control);
        this.setTitleImage(this.localResourceManager.createImage(ImagePool.CHECKOUT_SELECTED_WIZBAN));
        this.getButton(0).setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite p = (Composite)super.createDialogArea(parent);
        final Composite composite = new Composite(p, 0);
        Table table = new Table(composite, 2816);
        table.setHeaderVisible(false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.viewer = new SimpleTableViewer(table, null, null);
        new LabelColumn(this.viewer, Messages.AllMyWorkspacesDialog_3, -1);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout(composite);
        JobRunner runner = new JobRunner(Messages.AllMyWorkspacesDialog_4, false);
        this.viewer.setInput(MyWorkspacesDomainTreeProvider.getAllMyWorkspacesQuery((IOperationRunner)runner));
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                AllMyWorkspacesDialog.this.getButton(0).setEnabled(!e.getSelection().isEmpty());
            }
        });
        this.viewer.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (AllMyWorkspacesDialog.this.getButton(0).isEnabled()) {
                    AllMyWorkspacesDialog.this.okPressed();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repositories.length) {
            ITeamRepository next = repositories[i];
            RepositoryUtils.asyncLogin(next, (IOperationRunner)runner);
            ++i;
        }
        Link newWorkspaceLink = new Link(composite, 0);
        newWorkspaceLink.setText(Messages.AllMyWorkspacesDialog_5);
        newWorkspaceLink.setBackground(composite.getBackground());
        newWorkspaceLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWorkspaceWizard wizard = new NewWorkspaceWizard(UIContext.createPartContext((IWorkbenchPart)AllMyWorkspacesDialog.this.part));
                WizardDialog dialog = new WizardDialog(composite.getShell(), (IWizard)wizard);
                if (dialog.open() != 0) {
                    return;
                }
                AllMyWorkspacesDialog.this.close();
            }
        });
        return parent;
    }

    protected void okPressed() {
        this.workspace = (ContributorPlaceWrapper)((Object)this.viewer.getSelection().getFirstElement());
        super.okPressed();
    }

    public ContributorPlaceWrapper getWorkspace() {
        return this.workspace;
    }
}

