/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.configuration;

import com.ibm.team.filesystem.rcp.core.internal.rest.util.SearchChangesUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.progress.UIJob;

public class SearchChanges {
    private SearchJob searchJob;
    private TreeViewer viewer;
    private Set occurrences;

    public SearchChanges(TreeViewer viewer) {
        this.viewer = viewer;
        this.occurrences = Collections.EMPTY_SET;
        this.searchJob = new SearchJob();
        this.searchJob.setSystem(true);
    }

    public void updateCurrent(Object current) {
        this.searchJob.requestSearch(current);
    }

    public void dispose() {
        this.searchJob = null;
    }

    public boolean sameOccurrence(Object object) {
        return this.occurrences.contains(object);
    }

    private void replaceOccurrences(Set occurrences) {
        this.occurrences = occurrences;
    }

    class SearchJob
    extends Job {
        Object previous;
        Object current;

        public SearchJob() {
            super(Messages.SearchChanges_0);
        }

        public void requestSearch(Object current) {
            if (this.current == current) {
                return;
            }
            this.previous = this.current;
            this.current = current;
            this.schedule(100L);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask(Messages.SearchChanges_1, 100);
                if (SearchChanges.this.searchJob == null) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                Object current = this.current;
                Set newChanges = SearchChangesUtil.allOccurrences((Object)current);
                SearchChanges.this.replaceOccurrences(newChanges);
                new UIJob(Messages.SearchChanges_2){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!SearchChanges.this.viewer.getTree().isDisposed()) {
                            SearchChanges.this.viewer.getTree().redraw();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }
}

