/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.configuration;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.changes.ActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.LockQuery;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.ICompareEditorListener;
import com.ibm.team.filesystem.ui.changes.actions.OpenConflictInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenConflictInExternalCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenShareableInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenShareableInExternalCompareAction;
import com.ibm.team.filesystem.ui.changes.configuration.ChangesSorter;
import com.ibm.team.filesystem.ui.changes.configuration.INavigatable;
import com.ibm.team.filesystem.ui.changes.configuration.SearchChanges;
import com.ibm.team.filesystem.ui.changes.views.DecorationImageDescriptor;
import com.ibm.team.filesystem.ui.changes.views.FlowDecoratorUtil;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.ImageUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;

public class LocalConfiguration
implements INavigatable,
ICompareEditorListener {
    Object currentChange;
    CompareEditorInput input;
    IViewPart part;
    TreeViewer viewer;
    Color folderBackground;
    Color sameOccurrenceBackground;
    SearchChanges searchChanges;
    ImageUtil imageUtil;
    private IEditorPart editor;
    private IPartListener editorListener;

    public LocalConfiguration(IViewPart part, TreeViewer viewer) {
        this.part = part;
        this.viewer = viewer;
        this.imageUtil = new ImageUtil();
        this.searchChanges = new SearchChanges(viewer);
        this.sameOccurrenceBackground = UiPlugin.getDefault().getColorRegistry().getColor("OCCURRENCES");
    }

    @Override
    public void created(CompareEditorInput input) {
        this.input = input;
    }

    public void updateSelection(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        this.searchChanges.updateCurrent(element);
        if (this.currentChange != element) {
            this.currentChange = null;
        }
    }

    public Color getBackgroundColor(Object object) {
        return this.searchChanges.sameOccurrence(object) ? this.sameOccurrenceBackground : null;
    }

    public Color getFolderBackgroundColor() {
        return this.folderBackground;
    }

    public void dispose() {
        if (this.folderBackground != null) {
            this.folderBackground.dispose();
        }
        this.folderBackground = null;
        this.sameOccurrenceBackground = null;
        if (this.searchChanges != null) {
            this.searchChanges.dispose();
        }
        this.searchChanges = null;
        if (this.imageUtil != null) {
            this.imageUtil.dispose();
        }
        this.imageUtil = null;
    }

    public static List getVisibleActivitySources(IComponentSyncContext context) {
        IOutgoingActivitySource source;
        boolean isVisible;
        ArrayList<Object> result = new ArrayList<Object>();
        IUnresolvedSource unresolvedSource = context.getUnresolvedSource();
        boolean bl = context.getLocalChangeSource().isAutoCheckinArmed() ? unresolvedSource.containsConflict() : (isVisible = !unresolvedSource.getFolders().isEmpty());
        if (isVisible) {
            result.add(unresolvedSource);
        }
        if ((source = context.getOutgoingActivitySource()).size() != 0 || ComponentSyncUtil.isReplaceOutgoing((IComponentSyncContext)context)) {
            result.add(source);
        }
        if (LocalConfiguration.includeSuspendedChangeSets() && (source = context.getSuspendedActivitySource()).size() != 0) {
            result.add(source);
        }
        if (!context.isOfType(1) && ((source = context.getIncomingActivitySource()).size() != 0 || ComponentSyncUtil.isReplaceIncoming((IComponentSyncContext)context))) {
            result.add(source);
        }
        return result;
    }

    private static boolean includeSuspendedChangeSets() {
        return UiPlugin.getBooleanPreference("com.ibm.team.filesystem.ide.ui.prefs_show_suspended_change_sets");
    }

    public static List getPending(IComponentSyncContext context) {
        ArrayList result = new ArrayList();
        result.addAll(ComponentConflictUtil.getPending((IComponentSyncContext)context));
        return result;
    }

    public static boolean excludeDisconnectedComponents() {
        return !UiPlugin.getBooleanPreference("com.ibm.team.filesystem.ide.ui.show_not_loaded_components");
    }

    public static boolean excludeComponentsWithNoChanges() {
        return !UiPlugin.getBooleanPreference("com.ibm.team.filesystem.ide.ui.prefs_show_with_no_changes");
    }

    public static boolean excludeUntrackedWorkspaces() {
        return !UiPlugin.getBooleanPreference("com.ibm.team.filesystem.ide.ui.prefs_show_untracked_workspaces");
    }

    public static boolean excludeAddedRemovedComponents() {
        return !UiPlugin.getBooleanPreference("com.ibm.team.filesystem.ide.ui.show_added_removed_components");
    }

    public static IComponentSyncContext[] getVisibleComponentSyncContexts(IWorkspaceSyncContext context) {
        if (ComponentSyncUtil.shouldShowComponentHierarchies()) {
            return ComponentSyncUtil.getRootComponentSyncContexts((IWorkspaceSyncContext)context, (boolean)LocalConfiguration.excludeDisconnectedComponents(), (boolean)LocalConfiguration.excludeComponentsWithNoChanges(), (int)LocalConfiguration.getSourcesFlag(), (boolean)LocalConfiguration.excludeAddedRemovedComponents());
        }
        return ComponentSyncUtil.getComponentSyncContexts((IWorkspaceSyncContext)context, (boolean)LocalConfiguration.excludeDisconnectedComponents(), (boolean)LocalConfiguration.excludeComponentsWithNoChanges(), (int)LocalConfiguration.getSourcesFlag(), (boolean)LocalConfiguration.excludeAddedRemovedComponents());
    }

    public static int getSourcesFlag() {
        int result = 4369;
        if (!LocalConfiguration.includeSuspendedChangeSets()) {
            result ^= 0x1000;
        }
        return result;
    }

    @Override
    public void gotoDifference(boolean next) {
        IEditorInput editorInput;
        boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool();
        if (!useExternalCompareTool && this.editor != null && (editorInput = this.editor.getEditorInput()) != null) {
            ICompareNavigator compareNavigator = (ICompareNavigator)editorInput.getAdapter(ICompareNavigator.class);
            boolean result = compareNavigator.selectChange(next);
            new UIJob(Messages.OpenInCompareAction_0){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (LocalConfiguration.this.editor != null) {
                        IWorkbenchPage page = LocalConfiguration.this.editor.getEditorSite().getPage();
                        page.activate((IWorkbenchPart)LocalConfiguration.this.editor);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
            if (!result) {
                return;
            }
            this.input = null;
        }
        if (this.currentChange == null) {
            Object result = this.getCurrentChange(next);
            if (!next) {
                result = this.find(result, false);
            }
            this.newCurrentChange(result);
            return;
        }
        this.newCurrentChange(this.find(this.currentChange, next));
    }

    private void newCurrentChange(Object currentChange) {
        this.currentChange = currentChange;
        if (currentChange == null) {
            return;
        }
        StructuredSelection selection = new StructuredSelection(currentChange);
        this.viewer.reveal(currentChange);
        this.viewer.setSelection((ISelection)selection, true);
        boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(selection);
        if (currentChange instanceof IRemoteChangeSummary) {
            if (useExternalCompareTool) {
                OpenInExternalCompareAction action = new OpenInExternalCompareAction();
                action.run(this.part.getSite().getShell(), this.part.getSite().getPage(), (IStructuredSelection)this.viewer.getSelection());
            } else {
                OpenInCompareAction compareAction = new OpenInCompareAction(this.part.getSite().getPage(), (ISelection)selection, (IReusableEditor)this.editor, this);
                compareAction.run();
            }
        } else if (currentChange instanceof ILocalChange) {
            if (useExternalCompareTool) {
                OpenShareableInExternalCompareAction action = new OpenShareableInExternalCompareAction();
                action.run(this.part.getSite().getShell(), this.part.getSite().getPage(), (IStructuredSelection)this.viewer.getSelection());
            } else {
                OpenShareableInCompareAction compareAction = new OpenShareableInCompareAction(this.part.getSite().getPage(), (ISelection)selection, (IReusableEditor)this.editor, this);
                compareAction.run();
            }
        } else if (currentChange instanceof IConflictItem) {
            if (useExternalCompareTool) {
                OpenConflictInExternalCompareAction action = new OpenConflictInExternalCompareAction();
                action.run(this.part.getSite().getShell(), this.part.getSite().getPage(), (IStructuredSelection)this.viewer.getSelection());
            } else {
                OpenConflictInCompareAction compareAction = new OpenConflictInCompareAction(this.part.getSite().getPage(), (IStructuredSelection)selection, (IReusableEditor)this.editor, this);
                compareAction.run();
            }
        }
    }

    private Object getCurrentChange(boolean next) {
        Object selection = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (!next && (selection instanceof IRemoteChangeSummary || selection instanceof ILocalChange)) {
            return selection;
        }
        return ChangesSorter.findFirstChange(this.viewer, selection, null, false);
    }

    private Object find(Object currentChange, boolean next) {
        int nextIndex;
        ArrayList result = new ArrayList();
        ChangesSorter.findChanges(this.viewer, null, result);
        if (result.isEmpty()) {
            return null;
        }
        int index = result.indexOf(currentChange);
        if (index == -1) {
            return result.get(0);
        }
        int n = nextIndex = next ? index + 1 : index - 1;
        if (nextIndex == -1) {
            nextIndex = result.size() - 1;
        }
        if (nextIndex == result.size()) {
            nextIndex = 0;
        }
        return result.get(nextIndex);
    }

    /*
     * Unable to fully structure code
     */
    public static String getModelDescriptionPendingStyle(IComponentSyncModel model) {
        description = ContentDescription.getDescription(model.getComponentSyncContexts(), true);
        excludeDisconnectedComponents = LocalConfiguration.excludeDisconnectedComponents();
        excludeComponentsWithNoChanges = LocalConfiguration.excludeComponentsWithNoChanges();
        nFiltered = 0;
        nAdded = 0;
        nRemoved = 0;
        var10_7 = model.getComponentSyncContexts();
        var9_8 = var10_7.length;
        var8_9 = 0;
        while (var8_9 < var9_8) {
            context = var10_7[var8_9];
            if (!excludeDisconnectedComponents && !excludeComponentsWithNoChanges && !LocalConfiguration.excludeAddedRemovedComponents()) ** GOTO lbl20
            if (excludeDisconnectedComponents && ComponentSyncUtil.isDisconnected((IComponentSyncContext)context) && !ComponentSyncUtil.hasConnectedDescendants((IComponentSyncContext)context)) {
                ++nFiltered;
            } else {
                if (!(!excludeComponentsWithNoChanges || context.hasChanges() || !LocalConfiguration.excludeAddedRemovedComponents() && (context.isOfType(16) || context.isOfType(32) || context.isOfType(64) || context.isOfType(128)))) {
                    ++nFiltered;
                }
                if (!excludeComponentsWithNoChanges && !context.hasChanges() && LocalConfiguration.excludeAddedRemovedComponents() && (context.isOfType(16) || context.isOfType(32) || context.isOfType(64) || context.isOfType(128))) {
                    ++nFiltered;
                }
lbl20:
                // 4 sources

                if (context.isOfType(16) || context.isOfType(64)) {
                    ++nAdded;
                }
                if (context.isOfType(32) || context.isOfType(128)) {
                    ++nRemoved;
                }
            }
            ++var8_9;
        }
        if (nAdded != 0) {
            description = description.length() > 0 ? String.valueOf(description) + ", " : description;
            description = String.valueOf(description) + (nAdded == 1 ? Messages.LocalConfiguration_40 : NLS.bind((String)Messages.LocalConfiguration_41, (Object)nAdded));
        }
        if (nRemoved != 0) {
            description = description.length() > 0 ? String.valueOf(description) + ", " : description;
            description = String.valueOf(description) + (nRemoved == 1 ? Messages.LocalConfiguration_42 : NLS.bind((String)Messages.LocalConfiguration_43, (Object)nRemoved));
        }
        if (nFiltered != 0) {
            filteredDescription = nFiltered == 1 ? Messages.LocalConfiguration_0 : NLS.bind((String)Messages.LocalConfiguration_1, (Object)nFiltered);
            description = description.length() == 0 ? filteredDescription : NLS.bind((String)Messages.LocalConfiguration_2, (Object)description, (Object)filteredDescription);
        }
        return description;
    }

    public static String getWorkspaceDescription(IWorkspaceSyncContext context, boolean noChangesMessage) {
        ActiveWorkspaceManager manager = ActiveWorkspaceManager.getInstance();
        if (!manager.isWorkspaceTracked((IWorkspaceHandle)context.getLocal().getResolvedWorkspace())) {
            return Messages.LocalConfiguration_UNTRACKED_WORKSPACE;
        }
        return ContentDescription.getDescription(context.getComponentSyncContexts(), noChangesMessage);
    }

    public static String getDescription(Object element, boolean explorerStyle) {
        if (element instanceof IComponentSyncContext) {
            IComponentSyncContext context = (IComponentSyncContext)element;
            return ContentDescription.getDescription(new IComponentSyncContext[]{context}, true);
        }
        if (element instanceof IWorkspaceSyncContext) {
            return LocalConfiguration.getWorkspaceDescription((IWorkspaceSyncContext)element, true);
        }
        if (element instanceof IActivitySource) {
            IActivitySource source = (IActivitySource)element;
            return ContentDescription.getChangesCountDescription(source.getBaselines().size(), source.getActivities().size(), true);
        }
        if (element instanceof IActivityFolder) {
            IActivityFolder folder = (IActivityFolder)element;
            return folder.getPath();
        }
        if (element instanceof IRemoteChangeSummary) {
            IRemoteChangeSummary summary = (IRemoteChangeSummary)element;
            String name = summary.getResourceName();
            IActivityFolder folder = ComponentSyncUtil.findFolder((IRemoteChangeSummary)summary);
            return folder != null ? NLS.bind((String)Messages.LocalConfiguration_3, (Object)name, (Object)folder.getPath()) : name;
        }
        return null;
    }

    public Image getTitleImage(IComponentSyncModel model) {
        BitSet flags = LocalConfiguration.getViewDecorationFlags(model);
        DecorationImageDescriptor descriptor = new DecorationImageDescriptor(ImagePool.SHOW_CHANGES_ICON, flags, 4);
        return this.imageUtil.getImage((ImageDescriptor)descriptor);
    }

    public static BitSet getViewDecorationFlags(IComponentSyncModel model) {
        IComponentSyncContext[] contexts;
        boolean pendingLocal = false;
        boolean incoming = false;
        boolean conflicts = false;
        BitSet flags = new BitSet();
        IComponentSyncContext[] iComponentSyncContextArray = contexts = model.getComponentSyncContexts();
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            IOutgoingActivitySource source = context.getOutgoingActivitySource();
            if (!conflicts && context.hasConflict((IActivitySource)source)) {
                flags.set(23);
                conflicts = true;
            }
            if (!incoming && (context.isOfType(64) || context.isOfType(128) || context.getIncomingActivitySource().size() > 0)) {
                flags.set(22);
                incoming = true;
            }
            if (!pendingLocal && !context.getLocalChangeSource().getAutoCheckinMode() && context.getLocalChangeSource().size() > 0) {
                flags.set(21);
                pendingLocal = true;
            }
            ++n2;
        }
        return flags;
    }

    public static BitSet getDecorationFlags(IWorkspaceSyncContext workspaceContext) {
        boolean pendingLocal = false;
        boolean incoming = false;
        boolean outgoing = false;
        boolean unresolved = false;
        boolean conflicts = false;
        IComponentSyncContext[] contexts = workspaceContext.getComponentSyncContexts();
        int i = 0;
        while (i < contexts.length) {
            IComponentSyncContext context = contexts[i];
            IOutgoingActivitySource source = context.getOutgoingActivitySource();
            if (!outgoing && FlowDecoratorUtil.hasOutgoing(context)) {
                outgoing = true;
            }
            if (!unresolved) {
                unresolved = context.getUnresolvedSource().containsConflict();
            }
            if (!conflicts && context.hasConflict((IActivitySource)source)) {
                conflicts = true;
            }
            if (!incoming && FlowDecoratorUtil.hasIncoming(context)) {
                incoming = true;
            }
            if (!pendingLocal && !context.getLocalChangeSource().getAutoCheckinMode() && context.getLocalChangeSource().size() > 0) {
                pendingLocal = true;
            }
            ++i;
        }
        BitSet flags = new BitSet();
        if (pendingLocal) {
            flags.set(15);
        }
        if (unresolved) {
            flags.set(11);
        } else if (conflicts) {
            flags.set(10);
        } else if (outgoing && !incoming) {
            flags.set(13);
        } else if (incoming && !outgoing) {
            flags.set(12);
        } else if (outgoing && incoming) {
            flags.set(14);
        }
        IWorkspaceConnection connection = (IWorkspaceConnection)workspaceContext.getRemoteOutgoingConnectionDescriptor().getCachedConnection();
        if (connection != null) {
            if (connection.isLockedByMe()) {
                flags.set(20);
            } else if (connection.isLocked()) {
                flags.set(19);
            }
        }
        ITeamRepository targetIncomingRepo = null;
        try {
            targetIncomingRepo = workspaceContext.getRemoteIncomingConnectionDescriptor().getTeamRepository();
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        ITeamRepository targetOutgoingRepo = null;
        try {
            targetOutgoingRepo = workspaceContext.getRemoteOutgoingConnectionDescriptor().getTeamRepository();
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        if (targetIncomingRepo != null && !RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)targetIncomingRepo) && targetOutgoingRepo != null && !RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)targetOutgoingRepo)) {
            flags.set(24);
        }
        return flags;
    }

    public static BitSet getDecorationFlags(IUnresolvedFolder folder) {
        BitSet flags = new BitSet();
        if (folder.containsConflict()) {
            flags.set(11);
        }
        if (!folder.getLocalChanges().isEmpty()) {
            flags.set(15);
        }
        LockQuery.LockCount lockCount = LockQuery.countLocks((Object)folder);
        if (lockCount.locksBlocking > 0) {
            flags.set(19);
        } else if (lockCount.locksOwned > 0) {
            flags.set(20);
        }
        return flags;
    }

    @Override
    public void setEditor(final IReusableEditor editor) {
        final IWorkbenchPage page = editor.getSite().getPage();
        this.editor = editor;
        if (editor != null) {
            if (this.editorListener == null) {
                this.editorListener = new IPartListener(){

                    public void partBroughtToTop(IWorkbenchPart part) {
                    }

                    public void partClosed(IWorkbenchPart part) {
                        LocalConfiguration.this.editor = null;
                        LocalConfiguration.this.editorListener = null;
                    }

                    public void partDeactivated(IWorkbenchPart part) {
                    }

                    public void partOpened(IWorkbenchPart part) {
                    }

                    public void partActivated(IWorkbenchPart part) {
                    }
                };
                page.addPartListener(this.editorListener);
            }
            new UIJob(Messages.OpenInCompareAction_0){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    page.activate((IWorkbenchPart)editor);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public static class ContentDescription {
        public static final String NO_CONTEXT = "";

        public static String getDescription(IComponentSyncContext[] contexts, boolean noChangesMessage) {
            if (contexts.length == 0) {
                return ContentDescription.noContextsDescription();
            }
            return ContentDescription.getChangesCountDescription(contexts, noChangesMessage);
        }

        public static String noContextsDescription() {
            return NO_CONTEXT;
        }

        public static String getChangesCountDescription(int nBaselines, int nChanges, boolean noChangesMessage) {
            String result = NO_CONTEXT;
            boolean addSep = false;
            if (nBaselines != 0) {
                result = String.valueOf(result) + (nBaselines == 1 ? Messages.LocalConfiguration_6 : NLS.bind((String)Messages.LocalConfiguration_7, (Object)nBaselines));
                addSep = true;
            }
            if (nChanges != 0) {
                if (addSep) {
                    result = String.valueOf(result) + (nBaselines != 0 ? " + " : ", ");
                }
                result = String.valueOf(result) + (nChanges == 1 ? Messages.LocalConfiguration_10 : NLS.bind((String)Messages.LocalConfiguration_11, (Object)nChanges));
                addSep = true;
            }
            if (noChangesMessage && result.length() == 0) {
                result = Messages.LocalConfiguration_12;
            }
            return result;
        }

        public static String getChangesCountDescription(int nLocal, int nIncomingBaselines, int nIncoming, int nOutgoingBaselines, int nOutgoing, int nConflict, int nCollision, int nComponentChanges, boolean noChangesMessage) {
            String result = NO_CONTEXT;
            boolean addSep = false;
            if (ComponentSyncModel.DEGRADED_NOCHANGES || ComponentSyncModel.DEGRADED_NOWORKITEMS || LocalSynchronizeDecorator.NO_DECORATION) {
                result = String.valueOf(result) + Messages.LocalConfiguration_39;
                addSep = true;
            }
            if (nLocal != 0) {
                result = String.valueOf(result) + NLS.bind((String)Messages.LocalConfiguration_14, (Object)nLocal);
                addSep = true;
            }
            if (nIncomingBaselines != 0) {
                if (addSep) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + (nIncomingBaselines == 1 ? Messages.LocalConfiguration_16 : NLS.bind((String)Messages.LocalConfiguration_17, (Object)nIncomingBaselines));
                addSep = true;
            }
            if (nIncoming != 0) {
                if (addSep) {
                    result = String.valueOf(result) + (nIncomingBaselines != 0 ? " + " : ", ");
                }
                result = String.valueOf(result) + (nIncoming == 1 ? Messages.LocalConfiguration_20 : NLS.bind((String)Messages.LocalConfiguration_21, (Object)nIncoming));
                addSep = true;
            }
            if (nOutgoingBaselines != 0) {
                if (addSep) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + (nOutgoingBaselines == 1 ? Messages.LocalConfiguration_23 : NLS.bind((String)Messages.LocalConfiguration_24, (Object)nOutgoingBaselines));
                addSep = true;
            }
            if (nOutgoing != 0) {
                if (addSep) {
                    result = String.valueOf(result) + (nOutgoingBaselines != 0 ? " + " : ", ");
                }
                result = String.valueOf(result) + (nOutgoing == 1 ? Messages.LocalConfiguration_27 : NLS.bind((String)Messages.LocalConfiguration_28, (Object)nOutgoing));
                addSep = true;
            }
            if (nConflict != 0) {
                if (addSep) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + (nConflict == 1 ? Messages.LocalConfiguration_30 : NLS.bind((String)Messages.LocalConfiguration_31, (Object)nConflict));
                addSep = true;
            }
            if (nCollision != 0) {
                if (addSep) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + (nCollision == 1 ? Messages.LocalConfiguration_33 : NLS.bind((String)Messages.LocalConfiguration_34, (Object)nCollision));
                addSep = true;
            }
            if (nComponentChanges != 0) {
                if (addSep) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + (nComponentChanges == 1 ? Messages.LocalConfiguration_36 : NLS.bind((String)Messages.LocalConfiguration_37, (Object)nComponentChanges));
                addSep = true;
            }
            if (noChangesMessage && result.length() == 0) {
                result = Messages.LocalConfiguration_38;
            }
            return result;
        }

        public static String getChangesCountDescription(IComponentSyncContext[] contexts, boolean noChangesMessage) {
            int nIncoming = 0;
            int nOutgoing = 0;
            int nPendingLocal = 0;
            int nConflict = 0;
            int nCollision = 0;
            int nComponentChanges = 0;
            int nIncomingBaselines = 0;
            int nOutgoingBaselines = 0;
            int i = 0;
            while (i < contexts.length) {
                IComponentSyncContext context = contexts[i];
                if (!context.isOfType(1)) {
                    nIncoming += context.getIncomingActivitySource().getActivities().size();
                    nIncomingBaselines += context.getIncomingActivitySource().getBaselines().size();
                }
                if (context.isOfType(16) || context.isOfType(32) || context.isOfType(64) || context.isOfType(128)) {
                    ++nComponentChanges;
                }
                nOutgoingBaselines += context.getOutgoingActivitySource().getBaselines().size();
                List outgoing = context.getOutgoingActivitySource().getActivities();
                nOutgoing += outgoing.size();
                if (!context.getLocalChangeSource().getAutoCheckinMode() || !context.getLocalChangeSource().isAutoCheckinArmed()) {
                    nPendingLocal += context.getLocalChangeSource().getLocalChanges().size();
                }
                nConflict += context.getOutgoingActivitySource().getConflictItems().size();
                for (IRemoteActivity activity : outgoing) {
                    if (!context.hasConflict(activity)) continue;
                    ++nCollision;
                }
                ++i;
            }
            return ContentDescription.getChangesCountDescription(nPendingLocal, nIncomingBaselines, nIncoming, nOutgoingBaselines, nOutgoing, nConflict, nCollision, nComponentChanges, noChangesMessage);
        }
    }
}

