/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.configuration;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.utils.ConnectionFacade;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalChangeSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.OfflineManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentTypeChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortContainerNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.EncodingChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ExecutableBitChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.LineDelimiterChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.MoveChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PendingPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PendingPortsContainerNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortChangesContainerNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortNodesUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortsNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PropertyChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.SymbolicLinkChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeParentNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OriginalSourceChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.SourceChangeSetNode;
import com.ibm.team.filesystem.rcp.core.patches.PatchModel;
import com.ibm.team.filesystem.ui.changes.views.PatchedDirectory;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class ChangesSorter
extends ViewerSorter {
    public int category(Object element) {
        VersionableChangeParentNode node;
        if (element instanceof PatchModel) {
            return 0;
        }
        if (element instanceof OfflineManager.UnreachableWorkspace) {
            return 1;
        }
        if (element instanceof IWorkspaceSyncContext) {
            IWorkspaceSyncContext wsc = (IWorkspaceSyncContext)element;
            return wsc.getLocal().isStream() ? 2 : 3;
        }
        if (element instanceof IUnresolvedSource) {
            return 0;
        }
        if (element instanceof ILocalChangeSource) {
            return 1;
        }
        if (element instanceof PortsNode) {
            return 2;
        }
        if (element instanceof IOutgoingActivitySource) {
            return 3;
        }
        if (element instanceof IIncomingActivitySource) {
            return 4;
        }
        if (element instanceof ISuspendedActivitySource) {
            return 5;
        }
        if (element instanceof ILocalFolder) {
            return 10;
        }
        if (element instanceof IUnresolvedFolder) {
            return 10;
        }
        if (element instanceof ILocalChange) {
            return ((ILocalChange)element).getTarget() instanceof IFolderHandle ? 11 : 12;
        }
        if (element instanceof IConflictItem) {
            IConflictItem conflict = (IConflictItem)element;
            ILogicalChange logicalChange = conflict.getLogicalChange();
            switch (conflict.getType()) {
                case 1: {
                    boolean modMod = logicalChange.kind() == 1 && ((ILogicalConflict)logicalChange).conflictType() == 9;
                    return modMod ? 13 : 14;
                }
                case 2: {
                    return 15;
                }
                case 3: {
                    return 16;
                }
            }
        }
        if (element instanceof ILocalConflictItem) {
            return 17;
        }
        if (element instanceof IRemoteActivity) {
            return 20;
        }
        if (element instanceof IBaselineGroup) {
            return 21;
        }
        if (element instanceof ISubcomponentChange) {
            return 30;
        }
        if (element instanceof IActivityFolder) {
            return 31;
        }
        if (element instanceof IFileSystemWorkItem) {
            return 32;
        }
        if (element instanceof PatchedDirectory) {
            return 33;
        }
        if (element instanceof CurrentPortNode) {
            return 34;
        }
        if (element instanceof OriginalSourceChangeSetNode) {
            return 35;
        }
        if (element instanceof SourceChangeSetNode) {
            return 36;
        }
        if (element instanceof IRemoteChangeSummary) {
            return ((IRemoteChangeSummary)element).getItem() instanceof IFolderHandle ? 40 : 41;
        }
        if (element instanceof CurrentPortContainerNode) {
            return 50;
        }
        if (element instanceof PendingPortsContainerNode) {
            return 51;
        }
        if (element instanceof PortChangesContainerNode) {
            return 60;
        }
        if (element instanceof VersionableChangeParentNode) {
            node = (VersionableChangeParentNode)element;
            if (node.getPathHint() == null) {
                return 70;
            }
            return 71;
        }
        if (element instanceof VersionableChangeNode) {
            node = (VersionableChangeNode)element;
            IVersionableHandle versionable = node.getVersionable();
            if (versionable instanceof IFolderHandle) {
                return 80;
            }
            return 81;
        }
        if (element instanceof AbstractChangeDetailNode) {
            MoveChangeDetailNode moveChange;
            AbstractChangeDetailNode changeDetailNode = (AbstractChangeDetailNode)element;
            if (changeDetailNode instanceof ContentChangeDetailNode) {
                return 90;
            }
            if (changeDetailNode instanceof ContentTypeChangeDetailNode) {
                return 91;
            }
            if (changeDetailNode instanceof EncodingChangeDetailNode) {
                return 92;
            }
            if (changeDetailNode instanceof ExecutableBitChangeDetailNode) {
                return 93;
            }
            if (changeDetailNode instanceof LineDelimiterChangeDetailNode) {
                return 94;
            }
            if (changeDetailNode instanceof MoveChangeDetailNode && (moveChange = (MoveChangeDetailNode)changeDetailNode).isMove()) {
                return 95;
            }
            if (changeDetailNode instanceof PropertyChangeDetailNode) {
                PropertyChangeDetailNode node2 = (PropertyChangeDetailNode)element;
                if (node2.isAdded()) {
                    return 96;
                }
                if (node2.isDeleted()) {
                    return 97;
                }
                if (node2.isModified()) {
                    return 98;
                }
                return 98;
            }
            if (changeDetailNode instanceof MoveChangeDetailNode && (moveChange = (MoveChangeDetailNode)changeDetailNode).isRename() && !moveChange.isMove()) {
                return 99;
            }
            if (changeDetailNode instanceof SymbolicLinkChangeDetailNode) {
                return 100;
            }
        }
        return 101;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        VersionableChangeParentNode v2;
        VersionableChangeParentNode v1;
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (e1 instanceof OfflineManager.UnreachableWorkspace && e2 instanceof OfflineManager.UnreachableWorkspace) {
            OfflineManager.UnreachableWorkspace uw1 = (OfflineManager.UnreachableWorkspace)e1;
            OfflineManager.UnreachableWorkspace uw2 = (OfflineManager.UnreachableWorkspace)e2;
            return uw1.getName().compareToIgnoreCase(uw2.getName());
        }
        if (e1 instanceof IWorkspaceSyncContext && e2 instanceof IWorkspaceSyncContext) {
            IWorkspaceSyncContext wsc1 = (IWorkspaceSyncContext)e1;
            IWorkspaceSyncContext wsc2 = (IWorkspaceSyncContext)e2;
            IWorkspaceConnection wc1 = wsc1.getLocal();
            IWorkspaceConnection wc2 = wsc2.getLocal();
            ConnectionFacade wc1ri = wsc1.getRemoteIncomingConnectionDescriptor();
            ConnectionFacade wc2ri = wsc2.getRemoteIncomingConnectionDescriptor();
            ConnectionFacade wc1ro = wsc1.getRemoteOutgoingConnectionDescriptor();
            ConnectionFacade wc2ro = wsc2.getRemoteOutgoingConnectionDescriptor();
            int compare = wc1.getName().compareToIgnoreCase(wc2.getName());
            compare = compare != 0 ? compare : wc1ri.getName().compareToIgnoreCase(wc2ri.getName());
            compare = compare != 0 ? compare : wc1ro.getName().compareToIgnoreCase(wc2ro.getName());
            return compare;
        }
        if (e1 instanceof LoadedConfigurationDescriptor && e2 instanceof LoadedConfigurationDescriptor) {
            LoadedConfigurationDescriptor lcd1 = (LoadedConfigurationDescriptor)e1;
            LoadedConfigurationDescriptor lcd2 = (LoadedConfigurationDescriptor)e2;
            return lcd1.componentName.compareToIgnoreCase(lcd2.componentName);
        }
        if (e1 instanceof IComponentSyncContext && e2 instanceof IComponentSyncContext) {
            IComponentSyncContext context1 = (IComponentSyncContext)e1;
            IComponentSyncContext context2 = (IComponentSyncContext)e2;
            IComponent component1 = context1.getComponent();
            IComponent component2 = context2.getComponent();
            ConnectionFacade connIncoming1 = context1.getRemoteIncomingConnection();
            ConnectionFacade connIncoming2 = context2.getRemoteIncomingConnection();
            ConnectionFacade connOutgoing1 = context1.getRemoteOutgoingConnection();
            ConnectionFacade connOutgoing2 = context2.getRemoteOutgoingConnection();
            int compareComponent = component1.getName().compareToIgnoreCase(component2.getName());
            compareComponent = compareComponent != 0 ? compareComponent : connIncoming1.getName().compareToIgnoreCase(connIncoming2.getName());
            compareComponent = compareComponent != 0 ? compareComponent : connOutgoing1.getName().compareToIgnoreCase(connOutgoing2.getName());
            return compareComponent;
        }
        if (e1 instanceof IUnresolvedFolder && e2 instanceof IUnresolvedFolder) {
            IUnresolvedFolder pathName1 = (IUnresolvedFolder)e1;
            IUnresolvedFolder pathName2 = (IUnresolvedFolder)e2;
            return pathName1.getPath().compareToIgnoreCase(pathName2.getPath());
        }
        if (e1 instanceof IActivityFolder && e2 instanceof IActivityFolder) {
            IActivityFolder folder1 = (IActivityFolder)e1;
            IActivityFolder folder2 = (IActivityFolder)e2;
            return folder1.getPath().compareToIgnoreCase(folder2.getPath());
        }
        if (e1 instanceof IRemoteChangeSummary && e2 instanceof IRemoteChangeSummary) {
            IRemoteChangeSummary change1 = (IRemoteChangeSummary)e1;
            IRemoteChangeSummary change2 = (IRemoteChangeSummary)e2;
            return change1.getAfterPath().compareToIgnoreCase(change2.getAfterPath());
        }
        if (e1 instanceof IRemoteActivity && e2 instanceof IRemoteActivity) {
            IRemoteActivity activity1 = (IRemoteActivity)e1;
            IRemoteActivity activity2 = (IRemoteActivity)e2;
            if (activity1 instanceof IOutgoingRemoteActivity && activity1.getActivitySource().getWorkspace() != null && activity1.getChangeSet() != null && PortsCacheManager.getInstance().isPortTargetOfCurrentPort((IChangeSetHandle)activity1.getChangeSet(), activity1.getActivitySource().getTeamRepository(), (IWorkspaceHandle)activity1.getActivitySource().getWorkspace(), activity1.getChangeSet().getComponent())) {
                return -1;
            }
            if (activity2 instanceof IOutgoingRemoteActivity && activity2.getActivitySource().getWorkspace() != null && activity2.getChangeSet() != null && PortsCacheManager.getInstance().isPortTargetOfCurrentPort((IChangeSetHandle)activity2.getChangeSet(), activity2.getActivitySource().getTeamRepository(), (IWorkspaceHandle)activity2.getActivitySource().getWorkspace(), activity2.getChangeSet().getComponent())) {
                return 1;
            }
            return activity1.getActivitySource().getModel().compare(activity1, activity2);
        }
        if (e1 instanceof IOutgoingRemoteActivity && e2 instanceof IOutgoingRemoteActivity) {
            IOutgoingRemoteActivity activity1 = (IOutgoingRemoteActivity)e1;
            IOutgoingRemoteActivity activity2 = (IOutgoingRemoteActivity)e2;
            return activity1.getActivitySource().getModel().compare((IRemoteActivity)activity1, (IRemoteActivity)activity2);
        }
        if (e1 instanceof IBaselineGroup && e2 instanceof IBaselineGroup) {
            IBaselineGroup g1 = (IBaselineGroup)e1;
            IBaselineGroup g2 = (IBaselineGroup)e2;
            return ComponentBaselineUtil.compareTo((IBaselineGroup)g1, (IBaselineGroup)g2);
        }
        if (e1 instanceof VersionableChangeParentNode && e2 instanceof VersionableChangeParentNode) {
            v1 = (VersionableChangeParentNode)e1;
            v2 = (VersionableChangeParentNode)e2;
            String[] v1PathHint = v1.getPathHint();
            String[] v2PathHint = v2.getPathHint();
            if (v1PathHint != null && v2PathHint != null) {
                return PortNodesUtil.getPathString((String[])v1PathHint, (boolean)true).compareToIgnoreCase(PortNodesUtil.getPathString((String[])v2PathHint, (boolean)true));
            }
            if (v1.getFolderUUID() != null && v2.getFolderUUID() != null) {
                return v1.getFolderUUID().compareTo((Object)v2.getFolderUUID());
            }
        }
        if (e1 instanceof VersionableChangeNode && e2 instanceof VersionableChangeNode) {
            v1 = (VersionableChangeNode)e1;
            v2 = (VersionableChangeNode)e2;
            return v1.getName().compareToIgnoreCase(v2.getName());
        }
        if (e1 instanceof PendingPortNode && e2 instanceof PendingPortNode) {
            PendingPortNode p1 = (PendingPortNode)e1;
            PendingPortNode p2 = (PendingPortNode)e2;
            PendingPortsContainerNode parent1 = p1.getParentNode();
            PendingPortsContainerNode parent2 = p2.getParentNode();
            if (parent1 != null && parent2 != null && parent1.equals((Object)parent2)) {
                int index1 = parent1.getChildPendingPorts().indexOf(p1);
                int index2 = parent1.getChildPendingPorts().indexOf(p2);
                return index1 - index2;
            }
        }
        if (e1 instanceof ISubcomponentChange && e2 instanceof ISubcomponentChange) {
            ISubcomponentChange s1 = (ISubcomponentChange)e1;
            ISubcomponentChange s2 = (ISubcomponentChange)e2;
            IComponent c1 = s1.getComponent();
            IComponent c2 = s2.getComponent();
            if (!s1.getChangeType().equals((Object)s2.getChangeType())) {
                if (s1.getChangeType().equals((Object)ISubcomponentChange.ChangeType.Addition)) {
                    return -1;
                }
                return 1;
            }
            if (c1 != null && c2 != null) {
                if (s1.isComponentMissingFromWorkspace() && !s2.isComponentMissingFromWorkspace()) {
                    return 1;
                }
                if (!s1.isComponentMissingFromWorkspace() && s2.isComponentMissingFromWorkspace()) {
                    return -1;
                }
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
            if (c1 != null) {
                return -1;
            }
            if (c2 != null) {
                return 1;
            }
            return s1.getComponentHandle().getItemId().compareTo((Object)s2.getComponentHandle().getItemId());
        }
        int result = super.compare(viewer, e1, e2);
        if (result == 0 && e1 instanceof PatchedDirectory && e2 instanceof PatchedDirectory) {
            PatchedDirectory pd1 = (PatchedDirectory)e1;
            PatchedDirectory pd2 = (PatchedDirectory)e2;
            result = pd1.getPath().toString().compareToIgnoreCase(pd2.getPath().toString());
        }
        return result;
    }

    public static Object findFirstChange(TreeViewer viewer, Object element, Object childMark, boolean childOnly) {
        Object parent;
        Object[] elements;
        ITreeContentProvider provider = (ITreeContentProvider)viewer.getContentProvider();
        ViewerSorter sorter = viewer.getSorter();
        if (element == null) {
            element = viewer.getInput();
        }
        if ((elements = provider.getChildren(element)) != null && elements.length > 0) {
            int i;
            if (sorter != null) {
                sorter.sort((Viewer)viewer, elements);
            }
            int index = 0;
            if (childMark != null) {
                i = 0;
                while (i < elements.length) {
                    if (elements[i] == childMark) {
                        index = i + 1;
                        break;
                    }
                    ++i;
                }
            }
            i = index;
            while (i < elements.length) {
                Object child = elements[i];
                if (ChangesSorter.isChange(child)) {
                    return child;
                }
                if ((child = ChangesSorter.findFirstChange(viewer, child, null, true)) != null) {
                    return child;
                }
                ++i;
            }
        }
        if (!childOnly && (parent = provider.getParent(element)) != null) {
            return ChangesSorter.findFirstChange(viewer, parent, element, false);
        }
        return null;
    }

    public static void findChanges(TreeViewer viewer, Object element, List result) {
        Object[] elements;
        ITreeContentProvider provider = (ITreeContentProvider)viewer.getContentProvider();
        ViewerSorter sorter = viewer.getSorter();
        if (element == null) {
            element = viewer.getInput();
        }
        if ((elements = provider.getChildren(element)) == null || elements.length == 0) {
            return;
        }
        if (sorter != null) {
            sorter.sort((Viewer)viewer, elements);
        }
        int i = 0;
        while (i < elements.length) {
            Object child = elements[i];
            if (ChangesSorter.isChange(child)) {
                result.add(child);
            } else {
                ChangesSorter.findChanges(viewer, child, result);
            }
            ++i;
        }
    }

    public static int compare(IRemoteChangeSummary element, IRemoteChangeSummary other) {
        if (element.getItem() == null || !element.getItem().sameItemId((IItemHandle)other.getItem())) {
            return 0;
        }
        if (element.getActivity() == other.getActivity()) {
            return 0;
        }
        if (element.getActivity().getActivitySource() != other.getActivity().getActivitySource()) {
            return 0;
        }
        IActivitySource source = element.getActivity().getActivitySource();
        List activities = source.getActivities();
        int index1 = activities.indexOf(element.getActivity());
        int index2 = activities.indexOf(other.getActivity());
        if (index1 >= 0 && index2 >= 0) {
            return index1 < index2 ? 1 : -1;
        }
        if (index1 >= 0) {
            return 1;
        }
        if (index2 >= 0) {
            return -1;
        }
        IBaselineGroup bg1 = ComponentSyncUtil.getBaselineGroup((IRemoteActivity)element.getActivity());
        IBaselineGroup bg2 = ComponentSyncUtil.getBaselineGroup((IRemoteActivity)other.getActivity());
        if (bg1 == null || bg2 == null) {
            return 0;
        }
        if (bg1 == bg2) {
            activities = bg1.getActivities();
            index1 = activities.indexOf(element.getActivity());
            index2 = activities.indexOf(other.getActivity());
            if (index1 >= 0 && index2 >= 0) {
                return index1 < index2 ? 1 : -1;
            }
            if (index1 >= 0) {
                return 1;
            }
            if (index2 >= 0) {
                return -1;
            }
            return 0;
        }
        List baselines = source.getBaselines();
        index1 = baselines.indexOf(bg1);
        return index1 < (index2 = baselines.indexOf(bg2)) ? 1 : -1;
    }

    static boolean isChange(Object element) {
        return element instanceof IRemoteChangeSummary || element instanceof ILocalChange || element instanceof IConflictItem || element instanceof ILocalConflictItem;
    }
}

