/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.actions.teamplace.CommonAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UntrackWorkspaceAction
extends CommonAction {
    private static final Log log = LoggingHelper.getLog(UntrackWorkspaceAction.class);

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List selectionList = selection.toList();
        final IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        Set workspaceContexts = ComponentSyncUtil.getWorkspaceContexts((Collection)selectionList);
        final ArrayList<IWorkspace> workspaceList = new ArrayList<IWorkspace>(workspaceContexts.size());
        for (IWorkspaceSyncContext wc : workspaceContexts) {
            IWorkspace ws = wc.getLocal().getResolvedWorkspace();
            if (UntrackWorkspaceAction.isTraceEnabled()) {
                UntrackWorkspaceAction.trace("UntrackWorkspaceAction: Untracking workspace " + ws.getName());
            }
            workspaceList.add(ws);
        }
        this.getOperationRunner().enqueue(Messages.UntrackWorkspaceAction_OperationName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.UntrackWorkspaceAction_OperationName, (int)2);
                manager.setWorkspacesTracked((Collection)workspaceList, false, (IProgressMonitor)progress);
            }
        });
    }

    private static boolean shouldEnable(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        List selectionList = selection.toList();
        Set workspaceContexts = ComponentSyncUtil.getWorkspaceContexts((Collection)selectionList);
        boolean allWorkspacesAreTracked = true;
        for (IWorkspaceSyncContext nextContext : workspaceContexts) {
            IWorkspaceConnection wc = nextContext.getLocal();
            if (manager.isWorkspaceTracked((IWorkspaceHandle)wc.getResolvedWorkspace())) continue;
            allWorkspacesAreTracked = false;
            break;
        }
        return allWorkspacesAreTracked;
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(UntrackWorkspaceAction.shouldEnable((IStructuredSelection)selection));
    }

    private static boolean isTraceEnabled() {
        return log != null && log.isTraceEnabled();
    }

    private static void trace(String message) {
        if (log != null) {
            log.trace((Object)message);
        }
    }
}

