/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.ui.changes.actions.LockAction;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UnlockAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, final IStructuredSelection selection) {
        final Realm realm = Realm.getDefault();
        this.getOperationRunner().enqueue(Messages.UnlockAction_JOB_NAME, (Operation)new RepositoryOperation(ComponentSyncUtil.getTeamRepositories((Collection)selection.toList())){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                IWorkspaceConnection outgoingConnection;
                IComponentSyncContext context;
                IVersionableHandle versionableHandle;
                Set[] result = ComponentSyncUtil.filter((Collection)selection.toList(), (Class[])new Class[]{IRemoteChangeSummary.class, ILocalChange.class, AbstractFileSystemItemWrapper.class});
                HashMap<ITeamRepository, List<LockEntry>> repoBatch = new HashMap<ITeamRepository, List<LockEntry>>();
                for (Object o : result[0]) {
                    if (!(o instanceof IRemoteChangeSummary)) continue;
                    IRemoteChangeSummary rcs = (IRemoteChangeSummary)o;
                    versionableHandle = rcs.getItem();
                    context = ComponentSyncUtil.getContext((Object)rcs);
                    if (context == null || (outgoingConnection = context.getRemoteOutgoingTeamPlace()) == null || !outgoingConnection.isStream() || !UnlockAction.hasComponent(outgoingConnection, context.getComponent())) continue;
                    UnlockAction.addLockEntry(repoBatch, realm, versionableHandle, outgoingConnection, (IComponentHandle)context.getComponent(), outgoingConnection.teamRepository());
                }
                for (Object o : result[1]) {
                    if (!(o instanceof ILocalChange)) continue;
                    ILocalChange localChange = (ILocalChange)o;
                    versionableHandle = localChange.getTarget();
                    context = ComponentSyncUtil.getContext((IComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel(), (ILocalChange)localChange);
                    if (context == null || (outgoingConnection = context.getRemoteOutgoingTeamPlace()) == null || !outgoingConnection.isStream() || !UnlockAction.hasComponent(outgoingConnection, context.getComponent())) continue;
                    UnlockAction.addLockEntry(repoBatch, realm, versionableHandle, outgoingConnection, (IComponentHandle)context.getComponent(), outgoingConnection.teamRepository());
                }
                for (Object o : result[2]) {
                    AbstractFileSystemItemWrapper item;
                    AbstractFileSystemItemWrapper.LockInfo lockInfo;
                    if (!(o instanceof AbstractFileSystemItemWrapper) || !(lockInfo = (item = (AbstractFileSystemItemWrapper)((Object)o)).getLockInfo()).isLocked() || lockInfo.getLockContextConnetion() == null) continue;
                    IWorkspaceConnection wc = lockInfo.getLockContextConnetion();
                    ItemId componentId = item.getWorkspace().fetchComponentId(monitor);
                    if (componentId.equals((Object)ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE))) {
                        problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LockAction_4));
                    }
                    IComponentHandle componentHandle = (IComponentHandle)componentId.toHandle();
                    UnlockAction.addLockEntry(repoBatch, realm, (IVersionableHandle)item.getItem().toHandle(), wc, componentHandle, wc.teamRepository());
                }
                com.ibm.team.filesystem.ide.ui.internal.actions.team.UnlockAction.enqueueUnlockOperation(UnlockAction.this.getOperationRunner(), repoBatch, UnlockAction.this.getContext());
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(LockAction.containsOnlyFiles(((IStructuredSelection)selection).toList()));
    }

    public static void addLockEntry(Map<ITeamRepository, List<LockEntry>> repoBatch, Realm realm, IVersionableHandle handle, IWorkspaceConnection stream, IComponentHandle component, ITeamRepository repo) {
        List<LockEntry> entries = repoBatch.get(repo);
        if (entries == null) {
            entries = new ArrayList<LockEntry>();
            repoBatch.put(repo, entries);
        }
        entries.add(new LockEntry(realm, null, repo, (IWorkspaceHandle)stream.getResolvedWorkspace(), component, handle, null));
    }

    public static boolean hasComponent(IWorkspaceConnection connection, IComponent component) {
        try {
            ICurrentComponentInfo info = connection.getComponentInfo((IComponentHandle)component);
            if (info != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

