/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.ui.changes.dialogs.ActivityDeleteDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnUndoUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UndoChangeAction
extends AbstractActionDelegate {
    private Set[] result;

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (this.result[0].size() != 0) {
            UndoChangeAction.deleteRemoteChangeSummary(shell, this.getOperationRunner(), this.result[0]);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Set[] result;
        super.selectionChanged(action, selection);
        boolean enable = false;
        List list = ((IStructuredSelection)selection).toList();
        Set contexts = ComponentSyncUtil.getContexts((Collection)list);
        if (contexts.size() != 0 && ComponentSyncUtil.allLoggedIn((Collection)contexts) && (result = ComponentSyncUtil.filter((Collection)list, (Class[])new Class[]{IOutgoingRemoteChangeSummary.class, Object.class}))[1].isEmpty() && !result[0].isEmpty()) {
            boolean isActive = true;
            for (IOutgoingRemoteChangeSummary changeSummary : result[0]) {
                IRemoteActivity activity = changeSummary.getActivity();
                if (activity.getActivitySource().getModel().isActive(activity)) continue;
                isActive = false;
                break;
            }
            if (isActive) {
                enable = true;
                this.result = result;
            }
        }
        if (action != null) {
            action.setEnabled(enable);
        }
    }

    public static void deleteRemoteChangeSummary(final Shell shell, IOperationRunner runner, final Collection list) {
        ActivityDeleteDialog deleteDialog = new ActivityDeleteDialog(shell, list, 6);
        if (deleteDialog.open() != 0) {
            return;
        }
        final String name = Messages.UndoChangeAction_0;
        runner.enqueue(name, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                try {
                    monitor.beginTask(Messages.UndoChangeAction_1, 100);
                    Set contexts = ComponentSyncUtil.getContexts((Collection)list);
                    IComponentSyncContext context = (IComponentSyncContext)contexts.toArray()[0];
                    WarnUndoUser problemHandler = new WarnUndoUser(shell, name, false);
                    context.discardChanges(list, (UndoDilemmaHandler)problemHandler, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    context.refresh(false, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                }
                finally {
                    monitor.done();
                }
            }
        });
    }
}

