/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.changes.actions.AcceptChangeSetFromWildAction;
import com.ibm.team.filesystem.ui.changes.actions.StandardAcceptDilemmaHandler;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UnSuspendAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Set[] result = ComponentSyncUtil.filter((Collection)selection.toList(), (Class[])new Class[]{ISuspendedRemoteActivity.class});
        UnSuspendAction.resumeRemoteActivity(this.getContext(), result[0]);
    }

    public static void resumeRemoteActivity(final UIContext context, final Collection<ISuspendedRemoteActivity> activities) {
        final String opName = Messages.UnSuspendAction_0;
        context.getUserOperationRunner().enqueue(opName, (Operation)new RepositoryOperation(ComponentSyncUtil.getTeamRepositories(activities)){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                Set wscs = ComponentSyncUtil.getWorkspaceContexts((Collection)activities);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)wscs.size());
                for (IWorkspaceSyncContext wsc : wscs) {
                    Set elements = ComponentSyncUtil.filter((Collection)activities, (IWorkspaceSyncContext)wsc);
                    WarnWorkspaceUpdate warnWorkspaceUpdate = new WarnWorkspaceUpdate(context, opName, Messages.UnSuspendAction_UNCHECKED_IN_CHANGES_MSG, Messages.UnSuspendAction_CHECK_IN_AND_RESUME, Messages.UnSuspendAction_RESUME);
                    StandardAcceptDilemmaHandler dilemmaHandler = new StandardAcceptDilemmaHandler(context, opName, StandardAcceptDilemmaHandler.AcceptType.RESUME);
                    dilemmaHandler.setPreferredNamespaces(UnSuspendAction.computePreferredNamespaces(elements));
                    List<ItemLocator<IChangeSet>> changeSets = AcceptChangeSetFromWildAction.extractChangeSets(elements);
                    AcceptChangeSetFromWildAction.acceptChanges(warnWorkspaceUpdate, dilemmaHandler, changeSets, (IProgressMonitor)progress.newChild(1));
                }
            }
        });
    }

    private static Map<ItemId<IComponent>, ItemNamespace> computePreferredNamespaces(Collection<ISuspendedRemoteActivity> activities) {
        HashMap result = NewCollection.hashMap();
        for (ISuspendedRemoteActivity next : activities) {
            if (!(next instanceof ISuspendedRemoteActivity)) continue;
            IRemoteActivity activity = (IRemoteActivity)next;
            IComponentSyncContext context = activity.getActivitySource().getModel();
            result.put(PendingChangesUtil.getComponent(context), PendingChangesUtil.getLocalNamespace(context));
        }
        return result;
    }
}

