/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineUtil;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.filesystem.ui.changes.views.ZoomBookmark;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class SyncZoomAction
extends Action
implements IMenuCreator,
LocalWorkspaceChangesView.IBookmarkListener {
    private MenuManager menuManager;
    public Action fullModeAction;
    public Action outgoingWorkItemsZoomAction;
    public Action incomingWorkItemsZoomAction;
    public Action suspendedChangeSetsZoomAction;
    private LocalWorkspaceChangesView viewPart;
    private Action lastSelectedZoomAction;

    public SyncZoomAction(IOperationRunner runner, LocalWorkspaceChangesView viewPart) {
        super(Messages.SyncZoomAction_0);
        this.viewPart = viewPart;
        this.createFullModeAction();
        this.createOutgoingWorkItemsZoomAction();
        this.createIncomingWorkItemsZoomAction();
        this.createSuspendedChangeSetsZoomAction();
        this.setToolTipText(Messages.ChangesViewPage_1);
        this.changed(viewPart.getBookmark());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "com.ibm.team.filesystem.ide.ui.action_refreshpendingchanges");
        this.setMenuCreator(this);
        viewPart.addBookmarkListener(this);
    }

    private void createFullModeAction() {
        this.fullModeAction = new Action(Messages.SyncZoomAction_3, 8){

            public void run() {
                SyncZoomAction.this.viewPart.setFlatMode(false);
                SyncZoomAction.this.viewPart.setFocus();
                SyncZoomAction.this.updateImage();
            }
        };
        this.fullModeAction.setImageDescriptor(this.getImage(ZoomBookmark.FULL));
    }

    private void createOutgoingWorkItemsZoomAction() {
        this.outgoingWorkItemsZoomAction = new Action(Messages.SyncZoomAction_1, 8){

            public void run() {
                SyncZoomAction.this.viewPart.getZoomChangesViewPage().setBookmark(ZoomBookmark.OUTGOING_WORKITEM, true);
                SyncZoomAction.this.viewPart.setFocus();
                SyncZoomAction.this.updateImage();
                SyncZoomAction.this.lastSelectedZoomAction = this;
                if (!Boolean.getBoolean("com.ibm.team.filesystem.ide.ui.doNotExpandBaselinesInWorkItemZoomMode")) {
                    ComponentBaselineUtil.expandBaselines((ComponentBaselineUtil.BaselineDirection)ComponentBaselineUtil.BaselineDirection.OUTGOING);
                }
            }
        };
        this.outgoingWorkItemsZoomAction.setImageDescriptor(this.getImage(ZoomBookmark.OUTGOING_WORKITEM));
    }

    private void createIncomingWorkItemsZoomAction() {
        this.incomingWorkItemsZoomAction = new Action(Messages.SyncZoomAction_5, 8){

            public void run() {
                SyncZoomAction.this.viewPart.getZoomChangesViewPage().setBookmark(ZoomBookmark.INCOMING_WORKITEM, true);
                SyncZoomAction.this.viewPart.setFocus();
                SyncZoomAction.this.updateImage();
                SyncZoomAction.this.lastSelectedZoomAction = this;
                if (!Boolean.getBoolean("com.ibm.team.filesystem.ide.ui.doNotExpandBaselinesInWorkItemZoomMode")) {
                    ComponentBaselineUtil.expandBaselines((ComponentBaselineUtil.BaselineDirection)ComponentBaselineUtil.BaselineDirection.INCOMING);
                }
            }
        };
        this.incomingWorkItemsZoomAction.setImageDescriptor(this.getImage(ZoomBookmark.INCOMING_WORKITEM));
    }

    private void createSuspendedChangeSetsZoomAction() {
        this.suspendedChangeSetsZoomAction = new Action(Messages.SyncZoomAction_2, 8){

            public void run() {
                SyncZoomAction.this.viewPart.getZoomChangesViewPage().setBookmark(ZoomBookmark.SUSPENDED_CHANGESETS, true);
                SyncZoomAction.this.viewPart.setFocus();
                SyncZoomAction.this.updateImage();
                SyncZoomAction.this.lastSelectedZoomAction = this;
            }
        };
        this.suspendedChangeSetsZoomAction.setImageDescriptor(this.getImage(ZoomBookmark.SUSPENDED_CHANGESETS));
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
            this.menuManager = null;
        }
        this.viewPart.removeBookmarkListener(this);
    }

    public Menu getMenu(Control parent) {
        Menu fMenu = null;
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
            fMenu = this.menuManager.createContextMenu(parent);
            this.menuManager.add((IAction)this.fullModeAction);
            this.menuManager.add((IAction)this.outgoingWorkItemsZoomAction);
            this.menuManager.add((IAction)this.incomingWorkItemsZoomAction);
            this.menuManager.add((IAction)this.suspendedChangeSetsZoomAction);
            this.menuManager.update(true);
        } else {
            fMenu = this.menuManager.getMenu();
        }
        return fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private void updateImage() {
        if (this.fullModeAction.isChecked()) {
            this.setImageDescriptor(this.getImage(ZoomBookmark.FULL));
        }
        if (this.outgoingWorkItemsZoomAction.isChecked()) {
            this.setImageDescriptor(this.getImage(ZoomBookmark.OUTGOING_WORKITEM));
        }
        if (this.incomingWorkItemsZoomAction.isChecked()) {
            this.setImageDescriptor(this.getImage(ZoomBookmark.INCOMING_WORKITEM));
        }
        if (this.suspendedChangeSetsZoomAction.isChecked()) {
            this.setImageDescriptor(this.getImage(ZoomBookmark.SUSPENDED_CHANGESETS));
        }
    }

    public void run() {
        ZoomBookmark bookmark = this.viewPart.getBookmark();
        Action nextAction = bookmark == ZoomBookmark.FULL ? (this.lastSelectedZoomAction != null ? this.lastSelectedZoomAction : this.outgoingWorkItemsZoomAction) : this.fullModeAction;
        nextAction.run();
    }

    void reset() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
            this.menuManager = null;
        }
    }

    private ImageDescriptor getImage(ZoomBookmark bookmark) {
        if (bookmark == ZoomBookmark.PENDING_WORKITEM) {
            return ImagePool.TEAM_PLACE_CHANGES;
        }
        if (bookmark == ZoomBookmark.OUTGOING_WORKITEM) {
            return ImagePool.OUTGOING_FOLDER_ICON;
        }
        if (bookmark == ZoomBookmark.INCOMING_WORKITEM) {
            return ImagePool.INCOMING_FOLDER_ICON;
        }
        if (bookmark == ZoomBookmark.SUSPENDED_CHANGESETS) {
            return ImagePool.SUSPEND_FOLDER_ICON;
        }
        if (bookmark == ZoomBookmark.FULL) {
            return ImagePool.CHANGE;
        }
        return null;
    }

    @Override
    public void changed(LocalWorkspaceChangesView.BookmarkEvent event) {
        this.changed(event.newBookmark);
    }

    private void changed(ZoomBookmark newBookmark) {
        this.fullModeAction.setChecked(false);
        this.outgoingWorkItemsZoomAction.setChecked(false);
        this.incomingWorkItemsZoomAction.setChecked(false);
        this.suspendedChangeSetsZoomAction.setChecked(false);
        switch (newBookmark) {
            case FULL: {
                this.fullModeAction.setChecked(true);
                break;
            }
            case OUTGOING_WORKITEM: {
                this.outgoingWorkItemsZoomAction.setChecked(true);
                break;
            }
            case INCOMING_WORKITEM: {
                this.incomingWorkItemsZoomAction.setChecked(true);
                break;
            }
            case SUSPENDED_CHANGESETS: {
                this.suspendedChangeSetsZoomAction.setChecked(true);
            }
        }
        this.updateImage();
    }
}

