/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.dialogs.EditCommentDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class StartNewWorkAction
extends AbstractActionDelegate {
    private IComponentSyncContext context;

    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        EditCommentDialog dialog;
        final IComponentSyncContext context = this.context;
        if (context == null) {
            return;
        }
        final String[] comment = new String[]{""};
        boolean prompt = UiPlugin.getDefault().getPreferenceStore().getBoolean("com.ibm.team.filesystem.ide.ui.prompt_comment_new_change_set");
        if (prompt && (dialog = new EditCommentDialog(shell, ""){

            @Override
            protected void saveOnOk(String value) {
                comment[0] = value;
            }
        }).open() != 0) {
            return;
        }
        final String name = Messages.StartNewWorkAction_StartingNewChangeSetJobName;
        this.getOperationRunner().enqueue(name, (Operation)new RepositoryOperation(context.localTeamRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                WarnCommitUser problemHandler = new WarnCommitUser(shell, name);
                context.createActivityLocalChanges((Collection)Collections.EMPTY_LIST, comment[0], true, (CommitDilemmaHandler)problemHandler, monitor);
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IComponentSyncContext context;
        IStructuredSelection ss;
        super.selectionChanged(action, selection);
        this.context = null;
        boolean enable = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (context = ComponentSyncUtil.getContext((Object)ss.getFirstElement())) != null && context.isLocal() && !context.getOutgoingTeamPlace().isStream()) {
            this.context = context;
            enable = true;
        }
        action.setEnabled(enable);
    }
}

