/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.patches.CreatePatchDilemmaHandler;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ErrorDialog;
import com.ibm.team.filesystem.rcp.core.patches.Patch;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.AcceptChangeSetFromWildAction;
import com.ibm.team.filesystem.ui.changes.actions.ApplyPatchDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.actions.StandardAcceptDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.ApplyPatchUtil;
import com.ibm.team.internal.filesystem.ui.patches.StandardCreatePatchDilemmaHandler;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IChangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;

public class StandardApplyPatchDilemmaHandler
extends ApplyPatchDilemmaHandler {
    private UIContext context;
    private IPartResult<Object> resultCallback;
    private CreatePatchDilemmaHandler createPatchDilemmaHandler;
    private Set<FileChange> nonText = new HashSet<FileChange>();

    public StandardApplyPatchDilemmaHandler(UIContext context) {
        this.context = context;
        this.createPatchDilemmaHandler = new CreatePatchHandler(context);
    }

    public void setCallback(IPartResult<Object> callback) {
        this.resultCallback = callback;
    }

    @Override
    public void patchApplied(final Collection<Patch> pendingContentChanges) {
        this.context.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (StandardApplyPatchDilemmaHandler.this.resultCallback != null) {
                    StandardApplyPatchDilemmaHandler.this.resultCallback.setResult(ApplyPatchUtil.PATCH_RESULT_SUCCESS);
                }
                StandardApplyPatchDilemmaHandler.explainAndShowPatches(StandardApplyPatchDilemmaHandler.this.context, pendingContentChanges);
                if (StandardApplyPatchDilemmaHandler.this.nonText.size() > 0) {
                    IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
                    boolean prompt = prefStore.getBoolean("show_files_not_patched");
                    if (!prompt) {
                        return;
                    }
                    Iterator iter = StandardApplyPatchDilemmaHandler.this.nonText.iterator();
                    IStatus[] stats = new IStatus[StandardApplyPatchDilemmaHandler.this.nonText.size()];
                    int i = 0;
                    while (i < StandardApplyPatchDilemmaHandler.this.nonText.size()) {
                        FileChange fileChange = (FileChange)iter.next();
                        stats[i] = FileSystemStatusUtil.getStatusFor((int)1, (String)fileChange.getFinal().getPath().getName());
                        ++i;
                    }
                    MultiStatus status = new MultiStatus("com.ibm.team.filesystem.client", 0, stats, Messages.StandardApplyPatchDilemmaHandler_4, null);
                    ErrorDialog dialog = new ErrorDialog(StandardApplyPatchDilemmaHandler.this.context.getShell(), Messages.StandardApplyPatchDilemmaHandler_1, Messages.StandardApplyPatchDilemmaHandler_5, 2, (IStatus)status, DetailsDialog.ButtonBar.OkDetails);
                    dialog.initializeToggleButtonDontShowMeThisAgain(null, null);
                    dialog.open(StandardApplyPatchDilemmaHandler.this.context.getDisplay());
                }
            }
        });
    }

    @Override
    public void reportInvalidPatch() {
        this.context.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                new DetailsDialog(StandardApplyPatchDilemmaHandler.this.context.getShell(), Messages.StandardApplyPatchDilemmaHandler_6, Messages.StandardApplyPatchDilemmaHandler_7, 1, DetailsDialog.ButtonBar.Ok).open();
            }
        });
    }

    @Override
    public void duplicateChangeFound() throws OperationCanceledException {
        int dialogResult = new DetailsDialog(this.context.getShell(), Messages.StandardApplyPatchDilemmaHandler_8, Messages.StandardApplyPatchDilemmaHandler_9, 4, DetailsDialog.ButtonBar.OkCancel).open(this.context.getDisplay());
        if (dialogResult != 0) {
            throw new OperationCanceledException();
        }
    }

    @Override
    public void reportNothingToDo() {
        new DetailsDialog(this.context.getShell(), Messages.StandardApplyPatchDilemmaHandler_10, Messages.StandardApplyPatchDilemmaHandler_11, 2, DetailsDialog.ButtonBar.Ok).openAsync(this.context.getDisplay());
    }

    @Override
    public void reportUnmergedRelatedArtifacts() {
        new DetailsDialog(this.context.getShell(), MessageDialogFactory.getTitleForType((int)4), Messages.StandardApplyPatchDilemmaHandler_WarnPatchedLinks, 8, DetailsDialog.ButtonBar.Ok).open(this.context.getDisplay());
    }

    @Override
    public CreatePatchDilemmaHandler getCreatePatchHandler() {
        return this.createPatchDilemmaHandler;
    }

    public static void explainAndShowPatches(UIContext context, Collection<Patch> contentChanges) {
        try {
            MessageDialogWithToggle dialog;
            IPreferenceStore store;
            boolean prompt;
            IViewPart viewPart = context.getPage().showView("com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView");
            LocalWorkspaceChangesView changesView = (LocalWorkspaceChangesView)((Object)Adapters.getAdapter((Object)viewPart, LocalWorkspaceChangesView.class));
            if (changesView != null) {
                changesView.getFullChangesViewPage().showContentChanges(contentChanges);
            }
            if ((prompt = (store = UiPlugin.getDefault().getPreferenceStore()).getBoolean("info_apply_patch")) && (dialog = MessageDialogWithToggle.openInformation((Shell)context.getShell(), (String)Messages.StandardApplyPatchDilemmaHandler_2, (String)Messages.StandardApplyPatchDilemmaHandler_3, (String)Messages.StandardApplyPatchDilemmaHandler_0, (boolean)false, null, null)).getReturnCode() == 0) {
                store.setValue("info_apply_patch", !dialog.getToggleState());
            }
        }
        catch (PartInitException e) {
            IStatus status = StatusUtil.newStatus(StandardAcceptDilemmaHandler.class, (Throwable)e);
            StatusUtil.log((IStatus)status);
            new ErrorDialog(context.getShell(), null, null, 1, status, DetailsDialog.ButtonBar.OkDetails).openAsync(context.getDisplay());
        }
    }

    @Override
    public int changeSetNotFound(List<ItemLocator<IChangeSet>> changeSets, Map<ItemLocator<IChangeSet>, IChangeSet> fetchedChangeSets, Set<ItemLocator<IChangeSet>> notFound) {
        ArrayList<IStatus> stats = new ArrayList<IStatus>();
        for (ItemLocator<IChangeSet> locator : notFound) {
            IStatus status = StatusUtil.newStatus(AcceptChangeSetFromWildAction.class, (String)NLS.bind((String)Messages.AbstractDeliveryHyperlinkHandler_ErrorChangeSetNotAccessableWithLocation, (Object)locator.getItemId().getItemUUID().getUuidValue()));
            stats.add(status);
        }
        boolean allNotFound = changeSets.size() == notFound.size();
        String message = allNotFound ? Messages.StandardApplyPatchDilemmaHandler_NoChangeSetsCouldBeFetched : Messages.StandardApplyPatchDilemmaHandler_NotAllChangeSetsCouldBeFetched;
        ErrorDialog dialog = new ErrorDialog(null, Messages.StandardApplyPatchDilemmaHandler_CannotFindChangeSets, message, allNotFound ? 1 : 2, StatusUtil.newStatus(AcceptChangeSetFromWildAction.class, (String)Messages.AbstractDeliveryHyperlinkHandler_ERROR_CHANGESET_NOTACCESSIBLE, stats), allNotFound ? DetailsDialog.ButtonBar.OkDetails : DetailsDialog.ButtonBar.OkCancelDetails);
        int result = dialog.open(this.context.getDisplay());
        if (result == 0) {
            return 0;
        }
        return 1;
    }

    private class CreatePatchHandler
    extends StandardCreatePatchDilemmaHandler {
        public CreatePatchHandler(UIContext context) {
            super(context);
        }

        @Override
        public Collection<FileChange> nonTextChangesDetected(Collection<FileChange> nonText) throws OperationCanceledException {
            StandardApplyPatchDilemmaHandler.this.nonText.addAll(nonText);
            Collection<FileChange> text = super.nonTextChangesDetected(nonText);
            StandardApplyPatchDilemmaHandler.this.nonText.removeAll(text);
            return text;
        }
    }
}

