/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.ui.changes.actions.AcceptDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.actions.AcceptFailedPart;
import com.ibm.team.filesystem.ui.changes.actions.ApplyPatchDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.actions.StandardApplyPatchDilemmaHandler;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.ShareablesUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;

public class StandardAcceptDilemmaHandler
extends AcceptDilemmaHandler {
    private UIContext context;
    private StandardApplyPatchDilemmaHandler patchDilemmaHandler;
    private Map<ItemId<IComponent>, ItemNamespace> preferredNamespaces = NewCollection.hashMap();
    private AcceptType acceptType;

    public StandardAcceptDilemmaHandler(UIContext context) {
        this(context, Messages.StandardAcceptDilemmaHandler_AcceptingChangeSetsTitle, AcceptType.ACCEPT_CHANGESETS);
    }

    public StandardAcceptDilemmaHandler(UIContext context, String operationName, AcceptType acceptType) {
        this.context = context;
        this.patchDilemmaHandler = new StandardApplyPatchDilemmaHandler(context);
        this.acceptType = acceptType;
    }

    public void setPreferredNamespaces(Map<ItemId<IComponent>, ItemNamespace> namespaces) {
        this.preferredNamespaces = namespaces;
    }

    public AcceptType getAcceptType() {
        return this.acceptType;
    }

    @Override
    public AcceptDilemmaHandler.FailureAction reportFailure(List<ItemLocator<IChangeSet>> failures, final AcceptDilemmaHandler.FailureReason reason, IProgressMonitor monitor) throws OperationCanceledException, OperationFailedException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean allOwnedByMe = true;
        if (reason == AcceptDilemmaHandler.FailureReason.ACTIVE_CHANGE_SETS) {
            Map fetchedChangeSets = ItemFetcher.fetchCurrents(failures, (boolean)false, (IProgressMonitor)progress.newChild(50));
            for (IChangeSet nextChange : fetchedChangeSets.values()) {
                if (this.ownedByMe(nextChange)) continue;
                allOwnedByMe = false;
            }
        }
        final boolean finalAllOwnedByCurrentContributor = allOwnedByMe;
        final AcceptDilemmaHandler.FailureAction[] returnCode = new AcceptDilemmaHandler.FailureAction[]{AcceptDilemmaHandler.FailureAction.SKIP};
        final AcceptType type = this.getAcceptType();
        this.context.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IPartFactory part = reason == AcceptDilemmaHandler.FailureReason.ACTIVE_CHANGE_SETS ? (finalAllOwnedByCurrentContributor ? AcceptFailedPart.acceptFailedYourActivePart() : AcceptFailedPart.acceptFailedActivePart()) : (reason == AcceptDilemmaHandler.FailureReason.GAPS && type != AcceptType.RESUME ? AcceptFailedPart.acceptFailedGapsPart() : (reason == AcceptDilemmaHandler.FailureReason.GAPS && type == AcceptType.RESUME ? AcceptFailedPart.acceptFailedResumeGapsPart() : (reason == AcceptDilemmaHandler.FailureReason.NWAYFORKS && type != AcceptType.RESUME ? AcceptFailedPart.acceptFailedNWayForkPart() : (reason == AcceptDilemmaHandler.FailureReason.NWAYFORKS && type == AcceptType.RESUME ? AcceptFailedPart.acceptFailedResumeNWayForkPart() : AcceptFailedPart.acceptFailedUnknownPart()))));
                Parts.openModalDialog((Shell)StandardAcceptDilemmaHandler.this.context.getShell(), (Object)new IPartResult(){

                    public void setResult(Object result) {
                        if (result == AcceptFailedPart.APPLY_PATCH.getValue()) {
                            returnCode[0] = AcceptDilemmaHandler.FailureAction.APPLY_CONTENT;
                        }
                    }
                }, (IPartFactory)part);
            }
        });
        if (returnCode[0] != AcceptDilemmaHandler.FailureAction.APPLY_CONTENT) {
            throw new OperationCanceledException();
        }
        return returnCode[0];
    }

    private boolean ownedByMe(IChangeSet nextChange) {
        ITeamRepository repository = ClientRepositoryUtil.getRepository((IItemHandle)nextChange);
        return Repositories.getLoggedInContributor(repository).equals((Object)ChangeSetUtil.getAuthor((IChangeSet)nextChange));
    }

    @Override
    public Map<ItemId<IComponent>, WorkspaceNamespace> selectWorkspaces(Set<ItemId<IComponent>> components) throws TeamRepositoryException {
        HashMap result = NewCollection.hashMap();
        HashSet remain = NewCollection.hashSet();
        for (ItemId<IComponent> next : components) {
            ItemNamespace namespace = this.preferredNamespaces.get(next);
            if (namespace instanceof WorkspaceNamespace) {
                result.put(next, (WorkspaceNamespace)namespace);
                continue;
            }
            remain.add(next);
        }
        if (remain.isEmpty()) {
            return result;
        }
        Map<ItemId<IComponent>, WorkspaceNamespace> otherResults = ShareablesUtil.selectTargetWorkspaces(this.context, remain, true, false, Messages.PendingChangesUtil_2);
        for (ItemId next : remain) {
            WorkspaceNamespace nextResult = otherResults.get(next);
            result.put(next, nextResult);
        }
        return result;
    }

    @Override
    public ApplyPatchDilemmaHandler getPatchDilemmaHandler() {
        return this.patchDilemmaHandler;
    }

    @Override
    public void alreadyInHistoryFound() throws OperationCanceledException, OperationFailedException {
        this.context.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialogFactory.showMessage((Shell)StandardAcceptDilemmaHandler.this.context.getShell(), (int)1, (String)Messages.StandardAcceptDilemmaHandler_SkippingChangeSetsTitle, (String)Messages.StandardAcceptDilemmaHandler_SkippingChangeSetsMessage);
            }
        });
    }

    @Override
    public AcceptDilemmaHandler.OverlappingSuspendedResult overlappingSuspendedFound(List<ItemLocator<IChangeSet>> allOverlappingSuspended, IProgressMonitor newChild) throws OperationCanceledException {
        final boolean[] dialogResult = new boolean[1];
        this.context.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                dialogResult[0] = JFaceUtils.showMessageBlocking((String)Messages.StandardAcceptDilemmaHandler_ChangeSetOverlapTitle, (String)Messages.StandardAcceptDilemmaHandler_OverlappingChangesMessage, (String[])new String[]{Messages.StandardAcceptDilemmaHandler_CompleteResumeLabel, Messages.StandardAcceptDilemmaHandler_CancelLabel}, (int)1);
            }
        });
        if (dialogResult[0]) {
            return AcceptDilemmaHandler.OverlappingSuspendedResult.COMPLETE_AND_RESUME;
        }
        throw new OperationCanceledException();
    }

    public static enum AcceptType {
        RESUME,
        ACCEPT_CHANGESETS,
        ACCEPT_COMBINED;

    }
}

