/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISyncFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.adapters.AbstractAdaptableRemoteResource;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;

public class ShowLocalChangesAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        try {
            String viewId = "com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView";
            List syncModelObjects = this.convertSelectionToSyncModel(selection.toList());
            if (syncModelObjects.isEmpty()) {
                String msg;
                String viewName = "Pending Changes";
                IViewDescriptor desc = PlatformUI.getWorkbench().getViewRegistry().find(viewId);
                if (desc != null) {
                    viewName = desc.getLabel();
                }
                if (!MessageDialog.openConfirm((Shell)shell, (String)Messages.ShowLocalChangesAction_NoChangesTitle, (String)(msg = NLS.bind((String)Messages.ShowLocalChangesAction_NoPendingChangesMessage, (Object)viewName)))) {
                    return;
                }
            }
            IViewPart view = page.showView(viewId);
            if (!syncModelObjects.isEmpty() && view instanceof LocalWorkspaceChangesView) {
                ((LocalWorkspaceChangesView)view).getActiveChangesViewPage().setSelection((IStructuredSelection)new StructuredSelection(syncModelObjects));
            }
        }
        catch (PartInitException e) {
            StatusUtil.log(((Object)((Object)this)).getClass(), (Throwable)e);
        }
        catch (CoreException e) {
            StatusUtil.log(((Object)((Object)this)).getClass(), (Throwable)e);
        }
        catch (FileSystemException e) {
            StatusUtil.log(((Object)((Object)this)).getClass(), (Throwable)e);
        }
    }

    protected List convertSelectionToSyncModel(List selection) throws CoreException, FileSystemException {
        ArrayList<Object> resources = new ArrayList<Object>();
        HashMap<String, Integer> folderPaths = new HashMap<String, Integer>();
        HashSet<String> filePaths = new HashSet<String>();
        HashSet<UUID> fileVersionableIds = new HashSet<UUID>();
        HashSet<IComponentSyncContext> contexts = new HashSet<IComponentSyncContext>();
        for (Object o : selection) {
            Object resource;
            if (o instanceof ResourceMapping) {
                ResourceMapping mapping = (ResourceMapping)o;
                ResourceTraversal[] traversals = mapping.getTraversals(null, (IProgressMonitor)TempHelper.MONITOR);
                int j = 0;
                while (j < traversals.length) {
                    ResourceTraversal traversal = traversals[j];
                    int depth = traversal.getDepth();
                    this.collectContextFromResources(folderPaths, filePaths, fileVersionableIds, contexts, Arrays.asList(traversal.getResources()), depth);
                    ++j;
                }
                continue;
            }
            if (o instanceof IResource) {
                resource = (IResource)o;
                resources.add(resource);
                continue;
            }
            if (o instanceof AbstractAdaptableRemoteResource) {
                resource = (AbstractAdaptableRemoteResource)o;
                resources.add(resource);
                continue;
            }
            resource = (IResource)Adapters.getAdapter(o, IResource.class);
            if (resource != null) {
                resources.add(resource);
                continue;
            }
            AbstractAdaptableRemoteResource remoteResource = (AbstractAdaptableRemoteResource)Adapters.getAdapter(o, AbstractAdaptableRemoteResource.class);
            if (remoteResource == null) continue;
            resources.add(remoteResource);
        }
        if (!resources.isEmpty()) {
            this.collectContextFromResources(folderPaths, filePaths, fileVersionableIds, contexts, resources, 2);
        }
        ArrayList toSelect = new ArrayList();
        for (IComponentSyncContext context : contexts) {
            ShowLocalChangesAction.collectElementsToSelect(folderPaths, filePaths, fileVersionableIds, context, toSelect);
        }
        return toSelect;
    }

    protected void collectContextFromResources(Map<String, Integer> folderPaths, Set<String> filePaths, Set<UUID> fileVersionableIds, Set<IComponentSyncContext> contexts, List<? extends IAdaptable> resources, int depth) throws FileSystemException {
        int k = 0;
        while (k < resources.size()) {
            IAdaptable resource = resources.get(k);
            IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
            IComponentSyncContext context = ComponentSyncUtil.getContext((IShareable)shareable);
            if (context != null) {
                contexts.add(context);
                if (shareable.getResourceType((IProgressMonitor)TempHelper.MONITOR) == ResourceType.FILE) {
                    String fileFullPath = resource instanceof IResource ? ((IResource)resource).getFullPath().toString() : shareable.getFullPath().toString();
                    filePaths.add(fileFullPath);
                    IVersionableHandle versionable = shareable.getVersionable((IProgressMonitor)TempHelper.MONITOR);
                    if (versionable != null) {
                        fileVersionableIds.add(versionable.getItemId());
                    }
                } else {
                    String path;
                    if (resource instanceof IResource) {
                        path = ((IResource)resource).getFullPath().makeRelative().toString();
                    } else {
                        String[] segments = shareable.getLocalPath().segments();
                        if (segments == null || segments.length < 1) {
                            path = new String();
                        } else {
                            StringBuffer buf = new StringBuffer(segments[0]);
                            int i = 1;
                            while (i < segments.length) {
                                buf.append(String.valueOf('/') + segments[i]);
                                ++i;
                            }
                            path = buf.toString();
                        }
                    }
                    Integer prevDepth = folderPaths.put(path, depth);
                    if (prevDepth != null && prevDepth > depth) {
                        folderPaths.put(path, prevDepth);
                    }
                }
            }
            ++k;
        }
    }

    protected static void collectElementsToSelect(Map<String, Integer> folderPaths, Set<String> filePaths, Set<UUID> fileVersionableIds, IComponentSyncContext context, List toSelect) {
        ShowLocalChangesAction.collectElementsToSelect(folderPaths, filePaths, fileVersionableIds, context.getUnresolvedSource(), toSelect);
        ShowLocalChangesAction.collectElementsToSelect(folderPaths, fileVersionableIds, (IActivitySource)context.getOutgoingActivitySource(), toSelect);
        ShowLocalChangesAction.collectElementsToSelect(folderPaths, fileVersionableIds, (IActivitySource)context.getIncomingActivitySource(), toSelect);
    }

    private static void collectElementsToSelect(Map<String, Integer> folderPaths, Set<String> filePaths, Set<UUID> fileVersionableIds, IUnresolvedSource source, List toSelect) {
        Collection folders = source.getFolders();
        ShowLocalChangesAction.collectFoldersToSelect(folderPaths, folders, toSelect);
        for (IUnresolvedFolder folder : folders) {
            for (IVersionableHandle versionable : folder.getVersionables()) {
                if (!fileVersionableIds.contains(versionable.getItemId())) continue;
                toSelect.addAll(folder.getChildren(versionable));
            }
            for (ILocalChange localChange : folder.getLocalChanges()) {
                if (!ShowLocalChangesAction.isFolderChange(localChange, folderPaths.keySet())) continue;
                toSelect.add(localChange);
            }
        }
    }

    private static boolean isFolderChange(ILocalChange localChange, Set<String> folderPaths) {
        if (localChange.getTarget() instanceof IFolderHandle) {
            for (String folderPath : folderPaths) {
                if (!localChange.getPath().equals((Object)new RelativeLocation(new Path(folderPath).segments()))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isFolderChange(IRemoteChangeSummary change, Set<String> folderPaths) {
        if (change.getItem() instanceof IFolderHandle) {
            for (String folderPath : folderPaths) {
                if (!new Path(change.getAfterPath()).makeRelative().equals((Object)new Path(folderPath).makeRelative())) continue;
                return true;
            }
        }
        return false;
    }

    private static void collectFoldersToSelect(Map<String, Integer> folderPaths, Collection<? extends ISyncFolder> folders, List toSelect) {
        for (ISyncFolder iSyncFolder : folders) {
            String syncFolderPath = iSyncFolder.getPath();
            for (String selectedFolder : folderPaths.keySet()) {
                if (!syncFolderPath.contains(selectedFolder) || !ShowLocalChangesAction.matchFolderPath(folderPaths, ShowLocalChangesAction.extractPath(syncFolderPath, selectedFolder))) continue;
                toSelect.add(iSyncFolder);
            }
        }
    }

    private static String extractPath(String path, String selectedPath) {
        int index = path.indexOf(selectedPath);
        if (index == -1) {
            return path;
        }
        return path.substring(index, path.length());
    }

    private static boolean matchFolderPath(Map<String, Integer> folderPaths, String path) {
        int i;
        Integer depth = folderPaths.get(path);
        if (depth != null) {
            return true;
        }
        do {
            if ((i = path.lastIndexOf(47)) != -1) continue;
            return false;
        } while ((depth = folderPaths.get(path = path.substring(0, i))) == null || depth != 2);
        return true;
    }

    private static void collectElementsToSelect(Map<String, Integer> folderPaths, Set<UUID> fileVersionableIds, IActivitySource source, List toSelect) {
        ShowLocalChangesAction.collectElementsToSelect(folderPaths, fileVersionableIds, source.getActivities(), toSelect);
        for (IBaselineGroup baseline : source.getBaselines()) {
            ShowLocalChangesAction.collectElementsToSelect(folderPaths, fileVersionableIds, baseline.getActivities(), toSelect);
        }
    }

    private static void collectElementsToSelect(Map<String, Integer> folderPaths, Set<UUID> fileVersionableIds, List<IRemoteActivity> activities, List toSelect) {
        for (IRemoteActivity activity : activities) {
            ShowLocalChangesAction.collectFoldersToSelect(folderPaths, activity.getFolders(), toSelect);
            for (IRemoteChangeSummary change : activity.getChanges()) {
                if (fileVersionableIds.contains(change.getItem().getItemId())) {
                    toSelect.add(change);
                }
                if (!ShowLocalChangesAction.isFolderChange(change, folderPaths.keySet())) continue;
                toSelect.add(change);
            }
        }
    }

    protected Object adaptEditorInput(IEditorInput input) {
        return Adapters.getAdapter((Object)input, IResource.class);
    }
}

