/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class ShowComponentInPendingChangesViewAction
extends AbstractActionDelegate {
    private void attachListeners(Shell shell, IWorkbenchPage page, WorkspaceComponentWrapper componentWrapper) {
        ComponentSyncContextListener listener = new ComponentSyncContextListener(shell, page, componentWrapper);
        FileSystemResourcesPlugin.getComponentSyncModel().addGenericListener((Object)"componentSyncContexts", (IListener)listener);
    }

    private void detachListeners(IListener listener) {
        FileSystemResourcesPlugin.getComponentSyncModel().removeGenericListener((Object)"componentSyncContexts", listener);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object object = selection.getFirstElement();
        if (object == null) {
            return;
        }
        WorkspaceComponentWrapper componentWrapper = (WorkspaceComponentWrapper)Adapters.getAdapter((Object)object, WorkspaceComponentWrapper.class);
        if (componentWrapper == null) {
            return;
        }
        IActiveWorkspaceManager workspaceManager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        if (!workspaceManager.isActive((IWorkspaceHandle)componentWrapper.getWorkspace())) {
            this.attachListeners(shell, page, componentWrapper);
            workspaceManager.activate((IWorkspaceHandle)componentWrapper.getWorkspace());
        } else {
            this.selectComponent(shell, page, componentWrapper);
        }
    }

    protected void selectComponent(Shell shell, IWorkbenchPage page, WorkspaceComponentWrapper componentWrapper) {
        try {
            IViewPart viewPart = page.showView("com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView");
            IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
            IComponentSyncContext[] componentSyncContexts = model.getComponentSyncContexts((IConnection)componentWrapper.getWorkspaceConnection(), componentWrapper.getComponentHandle());
            if (componentSyncContexts.length != 1) {
                return;
            }
            LocalWorkspaceChangesView pendingChangesView = (LocalWorkspaceChangesView)viewPart;
            pendingChangesView.getActiveChangesViewPage().setSelection((IStructuredSelection)new StructuredSelection((Object)componentSyncContexts[0]));
            IStructuredSelection activeSelection = pendingChangesView.getActiveSelection();
            if (activeSelection == null || activeSelection.isEmpty()) {
                String componentName = componentWrapper.getComponent().getName();
                String workspaceName = componentWrapper.getWorkspaceConnection().getName();
                String dialogTitle = Messages.ShowComponentInPendingChangesViewActionErrorTitle;
                String dialogMessage = componentWrapper.getWorkspaceConnection().isStream() ? NLS.bind((String)Messages.ShowComponentInPendingChangesViewAction_WarningMessageStream, (Object)componentName, (Object)workspaceName) : NLS.bind((String)Messages.ShowComponentInPendingChangesViewAction_WarningMessageWorkspace, (Object)componentName, (Object)workspaceName);
                MessageDialog.openWarning((Shell)shell, (String)dialogTitle, (String)dialogMessage);
            }
        }
        catch (PartInitException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
    }

    private class ComponentSyncContextListener
    implements IListener {
        private Shell shell;
        private IWorkbenchPage page;
        private WorkspaceComponentWrapper componentWrapper;

        protected ComponentSyncContextListener(Shell shell, IWorkbenchPage page, WorkspaceComponentWrapper componentWrapper) {
            this.shell = shell;
            this.page = page;
            this.componentWrapper = componentWrapper;
        }

        public void handleEvents(List events) {
            for (Object o : events) {
                PropertyChangeEvent event;
                if (!(o instanceof PropertyChangeEvent) || !(event = (PropertyChangeEvent)o).getEventType().equals("com.ibm.team.repository.PropertyAddMany") || !(event.getNewValue() instanceof List)) continue;
                List newValues = (List)event.getNewValue();
                for (Object newValue : newValues) {
                    if (!(newValue instanceof IComponentSyncContext)) continue;
                    IComponentSyncContext componentSyncContext = (IComponentSyncContext)newValue;
                    IComponent component = componentSyncContext.getComponent();
                    if (component == null || component.sameItemId((IItemHandle)this.componentWrapper.getComponentHandle())) {
                        // empty if block
                    }
                    try {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ShowComponentInPendingChangesViewAction.this.selectComponent(ComponentSyncContextListener.this.shell, ComponentSyncContextListener.this.page, ComponentSyncContextListener.this.componentWrapper);
                            }
                        });
                    }
                    finally {
                        ShowComponentInPendingChangesViewAction.this.detachListeners(this);
                    }
                    return;
                }
            }
        }
    }
}

