/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryViewUtil;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ShowBaselinesInWorkspaceComponentAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        boolean shouldEnable = true;
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() != 1) {
            shouldEnable = false;
        } else {
            ISubcomponentChange subcomponentChange;
            Object o = ss.getFirstElement();
            if (o instanceof ISubcomponentChange && ((subcomponentChange = (ISubcomponentChange)o).isComponentInaccessible() || subcomponentChange.isComponentMissingFromWorkspace())) {
                shouldEnable = false;
            }
        }
        action.setEnabled(shouldEnable);
        super.selectionChanged(action, selection);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        IComponent component = null;
        IWorkspaceConnection connection = null;
        Object o = selection.getFirstElement();
        if (o instanceof IComponentSyncContext) {
            IComponentSyncContext csc = (IComponentSyncContext)o;
            component = csc.getComponent();
            if (csc.isOfType(64)) {
                connection = csc.getRemoteIncomingConnection().getCachedConnection();
            } else if (csc.isOfType(32)) {
                connection = csc.getRemoteOutgoingConnection().getCachedConnection();
            }
            if (connection == null) {
                connection = csc.getOutgoingConnection();
            }
        } else if (o instanceof ISubcomponentChange) {
            ISubcomponentChange changeNode = (ISubcomponentChange)o;
            component = changeNode.getComponent();
            connection = changeNode.getContainingWorkspaceConnection();
        }
        if (component != null && connection instanceof IWorkspaceConnection) {
            IWorkspaceConnection wc = connection;
            WorkspaceComponentWrapper wrapper = WorkspaceComponentWrapper.newWrapper(wc, component);
            HistoryViewUtil.showBaselinesInWorkspace(this.getContext(), wrapper);
        } else {
            MessageDialogFactory.showMessage((Shell)shell, (int)1, (String)Messages.ShowBaselinesInWorkspaceComponentAction_CannotShowBaselinesTitle, (String)Messages.ShowBaselinesInWorkspaceComponentAction_MissingComponentMessage);
        }
    }
}

