/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.dialogs.EditCommentDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;

public class SaveIntoNewActivityAction {
    public void run(Shell shell, Collection localChanges, CommitDilemmaHandler problemHandler) {
        EditCommentDialog dialog;
        if (localChanges.size() == 0 || !ComponentSyncUtil.sameComponent((Collection)localChanges)) {
            return;
        }
        ILocalSynchronizationManager syncManager = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
        ILocalChange localChange = (ILocalChange)localChanges.iterator().next();
        IComponentSyncContext context = ComponentSyncUtil.getContext((IComponentSyncModel)syncManager.getComponentSyncModel(), (ILocalChange)localChange);
        final String[] comment = new String[]{""};
        boolean prompt = UiPlugin.getDefault().getPreferenceStore().getBoolean("com.ibm.team.filesystem.ide.ui.prompt_comment_new_change_set");
        if (prompt && (dialog = new EditCommentDialog(shell, ""){

            @Override
            protected void saveOnOk(String value) {
                comment[0] = value;
            }
        }).open() != 0) {
            return;
        }
        SaveIntoNewActivityAction.createActivityAndSave(context, localChanges, Messages.SaveIntoNewActivityAction_CheckinText, problemHandler, comment[0]);
    }

    public static void createActivityAndSave(final IComponentSyncContext context, final Collection localChanges, String description, final CommitDilemmaHandler problemHandler, final String comment) {
        final String name = Messages.SaveIntoNewActivityAction_CheckinChangesProgressName;
        Job job = new Job(description){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        monitor.beginTask(name, 100);
                        context.createActivityLocalChanges(localChanges, comment, true, problemHandler, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        context.refresh(false, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    }
                    catch (FileSystemException e) {
                        IStatus iStatus = StatusUtil.newStatus((Object)((Object)this), (String)name, (Throwable)e);
                        monitor.done();
                        return iStatus;
                    }
                    catch (TeamRepositoryException e) {
                        IStatus iStatus = StatusUtil.newStatus((Object)((Object)this), (String)name, (Throwable)e);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

