/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.ui.changes.actions.CheckIntoChangeSetAction;
import com.ibm.team.filesystem.ui.changes.actions.SaveIntoNewActivityAction;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class SaveIntoActivityContributionItem
extends ContributionItem {
    Collection<ILocalChange> localChanges;
    MenuItem newActivityItem;
    private Image createChangeSetIcon = null;
    LocalWorkspaceChangesViewLabelProvider labelProvider;
    ILabelDecorator labelDecorator;
    IOperationRunner jobRunner = new JobRunner(true);

    public SaveIntoActivityContributionItem(LocalWorkspaceChangesViewLabelProvider labelProvider, ILabelDecorator labelDecorator) {
        this.labelProvider = labelProvider;
        this.labelDecorator = labelDecorator;
    }

    public void setSelection(IStructuredSelection selection) {
        this.localChanges = SaveIntoActivityContributionItem.getLocalChanges(selection);
    }

    public boolean isNeeded() {
        return this.localChanges != null && !this.localChanges.isEmpty();
    }

    public boolean isDynamic() {
        return true;
    }

    private boolean shouldEnable() {
        IContextHandle contextHandle = null;
        IComponentHandle component = null;
        for (ILocalChange localChange : this.localChanges) {
            IContextHandle h = localChange.getConnection();
            IComponentHandle c = localChange.getComponent();
            if (contextHandle == null) {
                contextHandle = h;
            }
            if (component == null) {
                component = c;
            }
            if (h.sameItemId((IItemHandle)contextHandle) && c.sameItemId((IItemHandle)component)) continue;
            return false;
        }
        return true;
    }

    public boolean isDirty() {
        return true;
    }

    public void fill(Menu menu, int index) {
        if (this.localChanges == null) {
            return;
        }
        MenuItem item = new MenuItem(menu, 64, index);
        item.setText(Messages.SaveIntoActivityContributionItem_0);
        final Shell shell = menu.getShell();
        final String name = Messages.SaveIntoActivityContributionItem_1;
        Menu subMenu = new Menu((Decorations)shell, 4);
        item.setMenu(subMenu);
        if (this.createChangeSetIcon == null) {
            this.createChangeSetIcon = ImagePool.CREATE_CHANGE.createImage();
        }
        int i = 0;
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        List activities = ComponentSyncUtil.getCheckInActivities((IComponentSyncModel)model, this.localChanges);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                MenuItem item = (MenuItem)event.widget;
                if (item == SaveIntoActivityContributionItem.this.newActivityItem) {
                    WarnCommitUser problemHandler = new WarnCommitUser(shell, name);
                    SaveIntoNewActivityAction action = new SaveIntoNewActivityAction();
                    action.run(shell, SaveIntoActivityContributionItem.this.localChanges, problemHandler);
                    return;
                }
                IOutgoingRemoteActivity activity = (IOutgoingRemoteActivity)item.getData();
                IComponentSyncContext compareChanges = activity.getActivitySource().getModel();
                CheckIntoChangeSetAction.run(shell, compareChanges, activity, SaveIntoActivityContributionItem.this.localChanges);
            }
        };
        for (IRemoteActivity activity : activities) {
            ++i;
            MenuItem menuItem = new MenuItem(subMenu, 8);
            menuItem.setText(SaveIntoActivityContributionItem.convertToOneLine(LocalWorkspaceChangesViewLabelProvider.getLabel(activity)));
            Image image = this.labelDecorator.decorateImage(this.labelProvider.getRegularImage(activity), (Object)activity);
            if (image != null) {
                menuItem.setImage(image);
            }
            menuItem.setData((Object)activity);
            menuItem.addListener(13, listener);
        }
        if (i > 0) {
            new MenuItem(subMenu, 2);
        }
        this.newActivityItem = new MenuItem(subMenu, 8);
        this.newActivityItem.setText(Messages.SaveIntoActivityContributionItem_3);
        this.newActivityItem.setEnabled(this.shouldEnable());
        this.newActivityItem.addListener(13, listener);
        this.newActivityItem.setImage(this.createChangeSetIcon);
    }

    private static String convertToOneLine(String string) {
        int rIndex = string.indexOf(13);
        int nIndex = string.indexOf(10);
        if (rIndex == -1) {
            return nIndex == -1 ? string : string.substring(0, nIndex);
        }
        if (nIndex == -1 || rIndex <= nIndex) {
            return string.substring(0, rIndex);
        }
        return string.substring(0, nIndex);
    }

    static Collection getLocalChanges(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        List list = selection.toList();
        for (Object elt : list) {
            if (elt instanceof IUnresolvedSource || elt instanceof ILocalChange || elt instanceof IUnresolvedFolder) continue;
            return null;
        }
        return ComponentSyncUtil.filter((Collection)list, (Class[])new Class[]{ILocalChange.class})[0];
    }

    public void dispose() {
        if (this.createChangeSetIcon != null) {
            this.createChangeSetIcon.dispose();
            this.createChangeSetIcon = null;
        }
        super.dispose();
    }
}

