/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IApplyAcceptedOperation;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnApplyAcceptedUser;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.changes.dialogs.MoveConflictedItemsDialog;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnUndoUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ListDialog;

public class ResolveWithProposed
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        ResolveWithProposed.resolveWithProposed(shell, this.getOperationRunner(), selection);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        IStructuredSelection ss = (IStructuredSelection)selection;
        Set[] filtered = ComponentSyncUtil.filter((Collection)ss.toList(), (Class[])new Class[]{IConflictItem.class, ILocalConflictItem.class});
        Set wscs = ComponentSyncUtil.getWorkspaceContexts((Collection)filtered[0]);
        wscs.addAll(ComponentSyncUtil.getWorkspaceContexts((Collection)filtered[1]));
        action.setEnabled(wscs.size() == 1);
    }

    static List<IConflictItem> getConflictItems(Collection<IComponentSyncContext> contexts, Collection<ILogicalConflict> logicalChanges) {
        ArrayList<IConflictItem> result = new ArrayList<IConflictItem>();
        block0: for (ILogicalChange iLogicalChange : logicalChanges) {
            for (IComponentSyncContext context : contexts) {
                IConflictItem match = null;
                Collection conflictItems = context.getOutgoingActivitySource().getConflictItems();
                for (IConflictItem conflictItem : conflictItems) {
                    if (conflictItem.getLogicalChange() != iLogicalChange) continue;
                    match = conflictItem;
                    break;
                }
                if (match == null) continue;
                result.add(match);
                continue block0;
            }
        }
        return result;
    }

    public static String getName(ILogicalConflict conflict, int id) {
        String[] pathHint = conflict.getPathHint();
        if (pathHint.length > 1) {
            return pathHint[pathHint.length - 1];
        }
        return "$" + System.currentTimeMillis() + "_" + id;
    }

    public static ListDialog createConflictDialog(Shell shell, Collection<ILogicalChange> conflictItems, String title, String message) {
        ListDialog dialog = new ListDialog(shell);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider((ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new LocalWorkspaceChangesViewLabelProvider(false), (ILabelDecorator)new LocalSynchronizeDecorator(false)));
        dialog.setInput(conflictItems);
        dialog.setBlockOnOpen(true);
        dialog.setMessage(message);
        dialog.setTitle(title);
        return dialog;
    }

    public static void resolveWithProposed(Shell shell, IOperationRunner operationRunner, IStructuredSelection selection) {
        Set[] filtered = ComponentSyncUtil.filter((Collection)selection.toList(), (Class[])new Class[]{IConflictItem.class, ILocalConflictItem.class});
        Set conflictItems = filtered[0];
        Set localConflictItems = filtered[1];
        if (!conflictItems.isEmpty() && !localConflictItems.isEmpty()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            int code = JFaceUtils.showMessageButtonsBlocking((String)Messages.ResolveWithProposed_0, (String)Messages.ResolveAction_description, (String[])new String[]{Messages.ResolveAction_LocalConflict, Messages.ResolveAction_RemoteConflict, Messages.PreferencesListener_14}, (int)4, (int)2);
            switch (code) {
                case 0: {
                    ResolveWithProposed.resolveWithProposedLocalConflicts(shell, operationRunner, localConflictItems);
                    break;
                }
                case 1: {
                    ResolveWithProposed.resolveWithProposedConflicts(shell, operationRunner, conflictItems);
                }
            }
            return;
        }
        if (!conflictItems.isEmpty()) {
            ResolveWithProposed.resolveWithProposedConflicts(shell, operationRunner, conflictItems);
        }
        ResolveWithProposed.resolveWithProposedLocalConflicts(shell, operationRunner, localConflictItems);
    }

    private static void resolveWithProposedLocalConflicts(final Shell shell, IOperationRunner operationRunner, final Collection<ILocalConflictItem> localConflictItems) {
        if (localConflictItems.size() == 0) {
            return;
        }
        MessageDialog undoDialog = new MessageDialog(shell, Messages.ReplaceAction_0, null, Messages.ReplaceAction_1, 3, new String[]{Messages.ActivityDeleteDialog_32, Messages.ActivityDeleteDialog_33}, 1);
        if (undoDialog.open() != 0) {
            return;
        }
        final String name = Messages.ReplaceAction_2;
        operationRunner.enqueue(name, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ArrayList<ILocalChange> toUndo = new ArrayList<ILocalChange>(localConflictItems.size());
                toUndo.addAll(this.findLocalChanges(localConflictItems, (IProgressMonitor)progress));
                try {
                    WarnUndoUser problemHandler = new WarnUndoUser(shell, name, true);
                    FileSystemCore.getSharingManager().getLocalChangeManager().undoChanges(toUndo.toArray(new ILocalChange[toUndo.size()]), IRepositoryResolver.EXISTING_SHARED, (UndoDilemmaHandler)problemHandler, (IProgressMonitor)progress.newChild(100));
                }
                finally {
                    progress.done();
                }
            }

            private Collection<ILocalChange> findLocalChanges(Collection<ILocalConflictItem> localConflicts, IProgressMonitor monitor) throws FileSystemException {
                ArrayList<ILocalChange> result = new ArrayList<ILocalChange>(localConflicts.size());
                for (ILocalConflictItem conflict : localConflicts) {
                    Collection shareables = FileSystemCore.getSharingManager().findShareables((IComponentHandle)conflict.getComponentSyncContext().getComponent(), conflict.getItem(), monitor);
                    for (IShareable shareable : shareables) {
                        ILocalChange deleteChange;
                        ILocalChange localChange = shareable.getChange(monitor);
                        if (localChange == null || localChange.getType() == 0) continue;
                        result.add(localChange);
                        if (conflict.getDeletedDuringReplay() == null || (deleteChange = FileSystemCore.getSharingManager().getLocalChangeManager().getPendingChange(shareable.getShare(monitor), conflict.getDeletedDuringReplay())) == null) continue;
                        result.add(deleteChange);
                    }
                }
                return result;
            }
        });
    }

    private static void resolveWithProposedConflicts(final Shell shell, IOperationRunner operationRunner, final Collection<IConflictItem> conflictItems) {
        if (!MessageDialog.openConfirm((Shell)shell, (String)Messages.ResolveWithProposed_ConfirmProposedTitle, (String)Messages.ResolveWithProposed_ConfirmProposedMessage)) {
            return;
        }
        operationRunner.enqueue(Messages.ResolveWithProposed_ResolveProposedJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ResolveWithProposed_ResolvingProposedProgressName, (int)100);
                Set contexts = ComponentSyncUtil.getContexts((Collection)conflictItems);
                Set wscs = ComponentSyncUtil.getWorkspaceContexts((Collection)conflictItems);
                if (wscs.size() != 1) {
                    throw new IllegalStateException();
                }
                IConflictItem conflictItem = (IConflictItem)conflictItems.iterator().next();
                ComponentSyncContext context = (ComponentSyncContext)conflictItem.getOutgoingActivitySource().getModel();
                IWorkspaceConnection wc = context.getOutgoingTeamPlace();
                ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
                Collection changes = ComponentConflictUtil.getChanges((Collection)conflictItems);
                final IApplyAcceptedOperation op = IOperationFactory.instance.getApplyAcceptedOperation((ApplyAcceptedDilemmaHandler)new WarnApplyAcceptedUser(shell, Messages.ResolveWithProposed_ResolveProposedTitle));
                op.setContext(wc, conflictReport);
                op.addChangesToResolve(changes);
                Collection needParentForResolution = op.needParentForResolution();
                needParentForResolution.removeAll(op.needContentToRemoved());
                if (!needParentForResolution.isEmpty()) {
                    final boolean[] doit = new boolean[1];
                    final List<IConflictItem> needed = ResolveWithProposed.getConflictItems(contexts, needParentForResolution);
                    shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MoveConflictedItemsDialog dialog = new MoveConflictedItemsDialog(shell, needed);
                            if (dialog.open() != 0) {
                                return;
                            }
                            Hashtable<IComponentSyncContext, MoveConflictedItemsDialog.MoveConflictedItemInfo> result = dialog.getResult();
                            for (IConflictItem conflictItem : needed) {
                                String name;
                                IComponentSyncContext context = conflictItem.getOutgoingActivitySource().getModel();
                                MoveConflictedItemsDialog.MoveConflictedItemInfo info = result.get(context);
                                ILogicalConflict deletedConflict = (ILogicalConflict)conflictItem.getLogicalChange();
                                UUID uuid = deletedConflict.item().getItemId();
                                IFolderHandle parent = (IFolderHandle)info.newFolders.get(uuid);
                                if (parent == null) {
                                    parent = (IFolderHandle)info.oldFolders.get(uuid);
                                }
                                if ((name = info.newNames.get(uuid)) == null) {
                                    name = conflictItem.getResourceName(false);
                                }
                                op.setParentForResolution(deletedConflict, parent, name);
                                doit[0] = true;
                            }
                        }
                    });
                    if (!doit[0]) {
                        return;
                    }
                }
                op.run((IProgressMonitor)progress.newChild(90));
            }
        });
    }
}

