/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalConflict;
import com.ibm.team.filesystem.client.IMarkAsMergedOperation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IResolveLocalConflictsAsMergedOperation;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ListDetailsDialog;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnResolveAsMergedUser;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ResolveWithMineAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        ResolveWithMineAction.resolveWithMine(shell, this.getOperationRunner(), selection);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        IStructuredSelection ss = (IStructuredSelection)selection;
        Set[] filtered = ComponentSyncUtil.filter((Collection)ss.toList(), (Class[])new Class[]{IConflictItem.class, ILocalConflictItem.class});
        Set wscs = ComponentSyncUtil.getWorkspaceContexts((Collection)filtered[0]);
        wscs.addAll(ComponentSyncUtil.getWorkspaceContexts((Collection)filtered[1]));
        action.setEnabled(wscs.size() == 1);
    }

    public static void resolveWithMine(Shell shell, IOperationRunner operationRunner, IStructuredSelection selection) {
        Set[] filtered = ComponentSyncUtil.filter((Collection)selection.toList(), (Class[])new Class[]{IConflictItem.class, ILocalConflictItem.class});
        Set conflictItems = filtered[0];
        Set localConflictItems = filtered[1];
        if (!conflictItems.isEmpty() && !localConflictItems.isEmpty()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            int code = JFaceUtils.showMessageButtonsBlocking((String)Messages.ResolveWithMineAction_2, (String)Messages.ResolveAction_description, (String[])new String[]{Messages.ResolveAction_LocalConflict, Messages.ResolveAction_RemoteConflict, Messages.PreferencesListener_14}, (int)4, (int)2);
            switch (code) {
                case 0: {
                    ResolveWithMineAction.resolveWithMineLocalConflicts(shell, operationRunner, localConflictItems);
                    break;
                }
                case 1: {
                    ResolveWithMineAction.resolveWithMineConflicts(shell, operationRunner, conflictItems);
                }
            }
            return;
        }
        if (!conflictItems.isEmpty()) {
            ResolveWithMineAction.resolveWithMineConflicts(shell, operationRunner, conflictItems);
        }
        ResolveWithMineAction.resolveWithMineLocalConflicts(shell, operationRunner, localConflictItems);
    }

    static void resolveWithMineLocalConflicts(Shell shell, IOperationRunner operationRunner, Collection<ILocalConflictItem> localConflictItems) {
        if (localConflictItems.isEmpty()) {
            return;
        }
        final Collection<ILocalConflict> conflictDescriptors = ResolveWithMineAction.getLocalConflictDescriptors(localConflictItems);
        operationRunner.enqueue(Messages.ResolveWithMineAction_2, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                IResolveLocalConflictsAsMergedOperation removeOp = IOperationFactory.instance.getResolveLocalConflictsAsMergedOperation();
                removeOp.addConflictsToResolve(conflictDescriptors);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ResolveWithMineAction_3, (int)100);
                removeOp.run((IProgressMonitor)progress.newChild(90));
            }
        });
    }

    private static Collection<ILocalConflict> getLocalConflictDescriptors(Collection<ILocalConflictItem> conflictItems) {
        ArrayList<ILocalConflict> result = new ArrayList<ILocalConflict>(conflictItems.size());
        for (ILocalConflictItem localConflictItem : conflictItems) {
            ILocalConflict descriptor = localConflictItem.getLocalConflict();
            result.add(descriptor);
        }
        return result;
    }

    private static void resolveWithMineConflicts(final Shell shell, IOperationRunner operationRunner, final Collection<IConflictItem> conflictItems) {
        if (conflictItems.isEmpty()) {
            return;
        }
        operationRunner.enqueue(Messages.ResolveWithMineAction_2, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ResolveWithMineAction_3, (int)100);
                IConflictItem conflictItem = (IConflictItem)conflictItems.iterator().next();
                ComponentSyncContext context = (ComponentSyncContext)conflictItem.getOutgoingActivitySource().getModel();
                IWorkspaceConnection wc = context.getOutgoingTeamPlace();
                ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
                WarnResolveAsMergedUser problemHandler = new WarnResolveAsMergedUser(shell, Messages.ResolveWithMineAction_2){

                    public int confirmMarkAsMerged(final Collection<ILogicalChange> changes) {
                        final int[] result = new int[]{1};
                        Display display = PlatformUI.getWorkbench().getDisplay();
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ListDetailsDialog dialog = new ListDetailsDialog(shell, Messages.ResolveWithMineAction_0, Messages.ResolveWithMineAction_1, 4, DetailsDialog.ButtonBar.YesNoDetails, changes);
                                dialog.setDefaultButtonId(3);
                                dialog.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new LocalWorkspaceChangesViewLabelProvider(false), (ILabelDecorator)new LocalSynchronizeDecorator(false)));
                                dialog.create();
                                result[0] = dialog.open() == 2 ? 0 : 1;
                            }
                        });
                        return result[0];
                    }
                };
                Collection changes = ComponentConflictUtil.getChanges((Collection)conflictItems);
                if (changes.isEmpty()) {
                    return;
                }
                IMarkAsMergedOperation mergedOp = IOperationFactory.instance.getMarkAsMergedOperation((MarkAsMergedDilemmaHandler)problemHandler);
                mergedOp.setContext(wc, conflictReport);
                mergedOp.addChangesToResolve(changes);
                mergedOp.run((IProgressMonitor)progress.newChild(90));
            }
        });
    }
}

