/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.WorkspaceUpdateUtil;
import com.ibm.team.filesystem.ui.changes.actions.DeliverAndOverrideAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ReplaceWorkspaceWithFlowTarget
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable;
        super.selectionChanged(action, selection);
        List list = ((IStructuredSelection)selection).toList();
        Set[] filter = ComponentSyncUtil.filter((Collection)list, (Class[])new Class[]{IComponentSyncContext.class, Object.class});
        ArrayList<Integer> types = new ArrayList<Integer>(Arrays.asList(6, 36));
        boolean bl = enable = filter[1].isEmpty() && ComponentSyncUtil.getWorkspaceContexts((Collection)list).size() == 1 && ComponentSyncUtil.allAnyType((Collection)filter[0], types);
        if (enable) {
            IWorkspaceSyncContext wsc = (IWorkspaceSyncContext)ComponentSyncUtil.getWorkspaceContexts((Collection)list).iterator().next();
            IWorkspaceConnection wc = wsc.getLocal();
            IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
            if (!manager.isWorkspaceTracked((IWorkspaceHandle)wc.getResolvedWorkspace())) {
                enable = false;
            }
        }
        action.setEnabled(enable);
        action.setText(NLS.bind((String)Messages.ReplaceWorkspaceWithFlowTarget_0, (Object)DeliverAndOverrideAction.getTargetName(list, true)));
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final List selectionToReplace = selection.toList();
        final boolean replacingAll = selectionToReplace.size() == 1 && selectionToReplace.get(0) instanceof IWorkspaceSyncContext;
        Set[] filter = ComponentSyncUtil.filter((Collection)selectionToReplace, (Class[])new Class[]{IComponentSyncContext.class, Object.class});
        if (ComponentSyncUtil.hasComponentContextTwins((Collection)filter[0])) {
            JFaceUtils.showMessage((String)Messages.ReplaceWorkspaceWithFlowTarget_3, (String)Messages.ContextTwinsSelected_0, (int)2);
            return;
        }
        if (!WorkspaceUtil.confirmUnresolvedAndConflictsForReplace(shell, selectionToReplace)) {
            return;
        }
        this.getOperationRunner().enqueue(Messages.ReplaceWorkspaceWithFlowTarget_1, (Operation)new RepositoryOperation(ComponentSyncUtil.getTeamRepositories((Collection)selectionToReplace)){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                WarnWorkspaceUpdate warnWorkspaceUpdate = new WarnWorkspaceUpdate(ReplaceWorkspaceWithFlowTarget.this.getContext(), Messages.ReplaceWorkspaceWithFlowTarget_1, Messages.ReplaceWorkspaceWithFlowTarget_UncheckedInChangesDialogMessage, Messages.ReplaceWorkspaceWithFlowTarget_UncheckedInChangesDialogCheckInButton, Messages.ReplaceWorkspaceWithFlowTarget_UncheckedInChangesDialogReplaceButton){

                    @Override
                    public int noBackupBaselineForComponent(Collection<ConfigurationFacade> configurations, IProgressMonitor monitor) {
                        return this.noBackupBaselineForReplace(configurations, monitor);
                    }

                    @Override
                    public int componentInMultipleHierarchies(IWorkspaceConnection workspace, Collection<IComponentHandle> selectedComponents, Collection<IComponentHandle> subcomponents, IProgressMonitor monitor) {
                        if (replacingAll) {
                            return 0;
                        }
                        return this.componentInMultipleHierarchiesForReplace(workspace, selectedComponents, subcomponents, selectionToReplace, monitor);
                    }

                    @Override
                    public int inaccessibleComponentsNotInSeedWorkspace(Collection<ConfigurationFacade> inaccessibleComponents, IProgressMonitor monitor) {
                        return this.inaccessibleComponentsNotInSeedWorkspaceForReplace(inaccessibleComponents, monitor);
                    }
                };
                WorkspaceUpdateUtil.accept((Collection)selectionToReplace, (WorkspaceUpdateDilemmaHandler)warnWorkspaceUpdate, (boolean)true, (boolean)true, (IProgressMonitor)monitor);
            }
        });
    }
}

