/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.wizards.component.SelectSnapshotWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ReplaceWithSnapshotAction
extends AbstractActionDelegate {
    List<IWorkspaceSyncContext> validSelection = null;

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean enabled = false;
        this.validSelection = this.getValidSelection(selection);
        if (this.validSelection.size() == 1) {
            IWorkspaceSyncContext wsc = this.validSelection.iterator().next();
            IWorkspaceConnection wc = wsc.getLocal();
            IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
            if (manager.isWorkspaceTracked((IWorkspaceHandle)wc.getResolvedWorkspace())) {
                enabled = true;
            }
        }
        action.setEnabled(enabled);
    }

    private List<IWorkspaceSyncContext> getValidSelection(ISelection selection) {
        ArrayList<IWorkspaceSyncContext> validSelection = new ArrayList<IWorkspaceSyncContext>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object element : ss) {
                if (!(element instanceof IWorkspaceSyncContext)) continue;
                IWorkspaceSyncContext context = (IWorkspaceSyncContext)element;
                validSelection.add(context);
            }
        }
        return validSelection;
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final IWorkspaceSyncContext context = this.validSelection.get(0);
        if (!WorkspaceUtil.confirmUnresolvedAndConflictsForReplace(shell, Collections.singletonList(context))) {
            return;
        }
        SelectSnapshotWizard wizard = new SelectSnapshotWizard(context.teamRepository());
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
        if (wizardDialog.open() != 0) {
            return;
        }
        final SnapshotWrapper snapshotWrapper = wizard.getSnapshot();
        if (snapshotWrapper != null) {
            this.getOperationRunner().enqueue(Messages.ReplaceWithSnapshotAction_0, (Operation)new RepositoryOperation(context.teamRepository()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                    WarnWorkspaceUpdate dilemmaHandler = new WarnWorkspaceUpdate(ReplaceWithSnapshotAction.this.getContext(), Messages.ReplaceWithSnapshotAction_1){

                        @Override
                        public int noBackupBaselineForComponent(Collection<ConfigurationFacade> configurations, IProgressMonitor monitor) {
                            return this.noBackupBaselineForReplace(configurations, monitor);
                        }

                        @Override
                        public int componentInMultipleHierarchies(IWorkspaceConnection workspace, Collection<IComponentHandle> selectedComponents, Collection<IComponentHandle> subcomponents, IProgressMonitor monitor) {
                            return 0;
                        }

                        @Override
                        public int inaccessibleComponentsNotInSeedWorkspace(Collection<ConfigurationFacade> inaccessibleComponents, IProgressMonitor monitor) {
                            return this.inaccessibleComponentsNotInSeedWorkspaceForReplace(inaccessibleComponents, monitor);
                        }
                    };
                    IWorkspaceUpdateOperation op = IOperationFactory.instance.getWorkspaceUpdateOperation((WorkspaceUpdateDilemmaHandler)dilemmaHandler);
                    IWorkspaceConnection workspace = context.getLocal();
                    ITeamRepository repo = context.teamRepository();
                    IBaselineSet snapshot = snapshotWrapper.getSnapshot();
                    op.replace(workspace, repo, (IBaselineSetHandle)snapshot);
                    op.run(monitor);
                }
            });
        }
    }
}

