/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.actions.ReplaceComponentAction;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.internal.filesystem.ui.wizards.component.SelectComponentWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.wizards.WizardDialogWithCustomButtons;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ReplaceComponentWithWorkspaceComponentAction
extends ReplaceComponentAction {
    @Override
    protected void run(Shell shell, IWorkbenchPage page, WorkspaceComponentWrapper workspaceComponent) {
        boolean hierarchyAware = FileSystemCore.getComponentHierarchyManager().isHierarchicalComponentsEnabled(workspaceComponent.getRepository());
        ComponentConfigurationPickerWizard.ConfigurationPickerInput wizardInput = new ComponentConfigurationPickerWizard.ConfigurationPickerInput(ComponentConfigurationPickerWizard.ConfigurationPickerInput.ConfigurationPickerMode.REPLACE_COMPONENT, hierarchyAware);
        ITeamRepository repository = workspaceComponent.getRepository();
        IWorkspace workspace = workspaceComponent.getWorkspace();
        ComponentWrapper componentWrapper = new ComponentWrapper(repository, workspaceComponent.getComponent());
        String wizardTitle = Messages.ReplaceComponentWithWorkspaceComponentAction_0;
        String wizardDescription = Messages.ReplaceComponentWithWorkspaceComponentAction_1;
        SelectComponentWizard wizard = new SelectComponentWizard(wizardInput, repository, (IWorkspaceHandle)workspace, componentWrapper, wizardTitle, wizardDescription);
        WizardDialogWithCustomButtons wizardDialog = new WizardDialogWithCustomButtons(shell, (IWizard)wizard, wizard.needsProgressMonitor(), true);
        wizardDialog.open();
        WorkspaceNamespace replacement = wizard.getResult();
        boolean hierarchicalReplace = wizard.isReplaceWithHierarchy();
        if (replacement != null) {
            ReplaceComponentWithWorkspaceComponentAction.performReplace(workspaceComponent.getNamespace(), replacement, hierarchicalReplace, this.getContext());
        }
    }

    public static void performReplace(final WorkspaceNamespace toReplace, final WorkspaceNamespace replacementSource, final boolean hierarchicalReplace, final UIContext uiContext) {
        String jobName = Messages.ReplaceComponentAction_ReplacingComponentJobName;
        uiContext.getUserOperationRunner().enqueue(jobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                WarnWorkspaceUpdate dilemmaHandler = new WarnWorkspaceUpdate(uiContext, Messages.ReplaceComponentAction_OPERATION_TITLE, Messages.ReplaceComponentWithWorkspaceComponentAction_REPLACE_MESSAGE, Messages.ReplaceComponentWithWorkspaceComponentAction_CHECKIN_AND_REPLACE_BUTTON, Messages.ReplaceComponentWithWorkspaceComponentAction_REPLACE_BUTTON){

                    @Override
                    public int noBackupBaselineForComponent(Collection<ConfigurationFacade> configurations, IProgressMonitor monitor) {
                        return this.noBackupBaselineForReplace(configurations, monitor);
                    }

                    @Override
                    public int componentInMultipleHierarchies(IWorkspaceConnection workspace, Collection<IComponentHandle> selectedComponents, Collection<IComponentHandle> subcomponents, IProgressMonitor monitor) {
                        return this.componentInMultipleHierarchiesForReplace(workspace, selectedComponents, subcomponents, Collections.singletonList(toReplace), monitor);
                    }

                    @Override
                    public int inaccessibleComponentsNotInSeedWorkspace(Collection<ConfigurationFacade> inaccessibleComponents, IProgressMonitor monitor) {
                        return this.inaccessibleComponentsNotInSeedWorkspaceForReplace(inaccessibleComponents, monitor);
                    }
                };
                IWorkspaceUpdateOperation op = IOperationFactory.instance.getWorkspaceUpdateOperation((WorkspaceUpdateDilemmaHandler)dilemmaHandler);
                IWorkspaceConnection workspaceConnection = toReplace.getWorkspaceConnection((IProgressMonitor)progress.newChild(5));
                IWorkspaceConnection sourceWorkspace = replacementSource.getWorkspaceConnection((IProgressMonitor)progress.newChild(5));
                List<IComponentHandle> componentToReplace = Collections.singletonList((IComponentHandle)toReplace.getComponentId().toHandle());
                op.replace(workspaceConnection, sourceWorkspace, componentToReplace, hierarchicalReplace);
                op.run((IProgressMonitor)progress.newChild(90));
            }
        });
    }
}

