/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.actions.ReplaceComponentAction;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.BaselineSelectionDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.adapters.WrapperUtil;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ReplaceComponentWithBaselineAction
extends ReplaceComponentAction {
    @Override
    protected void run(Shell shell, IWorkbenchPage page, final WorkspaceComponentWrapper component) {
        ItemNamespace namespace = WrapperUtil.getNamespaceFor(component);
        boolean hierarchyAware = FileSystemCore.getComponentHierarchyManager().isHierarchicalComponentsEnabled(component.getRepository());
        BaselineSelectionDialog.getBaseline(new ComponentConfigurationPickerWizard.ConfigurationPickerInput(ComponentConfigurationPickerWizard.ConfigurationPickerInput.ConfigurationPickerMode.REPLACE_COMPONENT, hierarchyAware), this.getContext(), Messages.ReplaceComponentWithBaselineAction_0, namespace, new IPartResult<BaselineSelectionDialog.BaselineSelectionDialogResult>(){

            public void setResult(BaselineSelectionDialog.BaselineSelectionDialogResult result) {
                ReplaceComponentWithBaselineAction.replaceFromBaseline(component.getNamespace(), result.getBaselineNamespace(), result.isHierarchicalBaselineReplace(), ReplaceComponentWithBaselineAction.this.getContext());
            }
        });
    }

    public static void replaceFromBaseline(final WorkspaceNamespace toReplace, final BaselineNamespace replacementSource, final boolean hierarchicalReplace, final UIContext uiContext) {
        String jobName = Messages.ReplaceComponentAction_ReplacingComponentJobName;
        uiContext.getUserOperationRunner().enqueue(jobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                WarnWorkspaceUpdate dilemmaHandler = new WarnWorkspaceUpdate(uiContext, Messages.ReplaceComponentAction_OPERATION_TITLE, Messages.ReplaceComponentWithWorkspaceComponentAction_REPLACE_MESSAGE, Messages.ReplaceComponentWithWorkspaceComponentAction_CHECKIN_AND_REPLACE_BUTTON, Messages.ReplaceComponentWithWorkspaceComponentAction_REPLACE_BUTTON){

                    @Override
                    public int noBackupBaselineForComponent(Collection<ConfigurationFacade> configurations, IProgressMonitor monitor) {
                        return this.noBackupBaselineForReplace(configurations, monitor);
                    }

                    @Override
                    public int componentInMultipleHierarchies(IWorkspaceConnection workspace, Collection<IComponentHandle> selectedComponents, Collection<IComponentHandle> subcomponents, IProgressMonitor monitor) {
                        return this.componentInMultipleHierarchiesForReplace(workspace, selectedComponents, subcomponents, Collections.singletonList(toReplace), monitor);
                    }

                    @Override
                    public int inaccessibleComponentsNotInSeedWorkspace(Collection<ConfigurationFacade> inaccessibleComponents, IProgressMonitor monitor) {
                        return this.inaccessibleComponentsNotInSeedWorkspaceForReplace(inaccessibleComponents, monitor);
                    }
                };
                IWorkspaceUpdateOperation op = IOperationFactory.instance.getWorkspaceUpdateOperation((WorkspaceUpdateDilemmaHandler)dilemmaHandler);
                IWorkspaceConnection workspaceConnection = toReplace.getWorkspaceConnection((IProgressMonitor)progress.newChild(5));
                IBaselineConnection baselineConnection = replacementSource.getBaselineConnection((IProgressMonitor)progress.newChild(5));
                if (hierarchicalReplace) {
                    op.replaceFromHierarchicalBaseline(workspaceConnection, baselineConnection);
                } else {
                    op.replace(workspaceConnection, baselineConnection);
                }
                op.run((IProgressMonitor)progress.newChild(90));
            }
        });
    }
}

