/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnUndoUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ReplaceAction
extends AbstractActionDelegate {
    private Set<ILocalChange> localChanges = Collections.emptySet();

    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final Set<ILocalChange> localChanges = this.localChanges;
        if (localChanges.size() == 0) {
            return;
        }
        MessageDialog undoDialog = new MessageDialog(shell, Messages.ReplaceAction_0, null, Messages.ReplaceAction_1, 3, new String[]{Messages.ActivityDeleteDialog_32, Messages.ActivityDeleteDialog_33}, 1);
        if (undoDialog.open() != 0) {
            return;
        }
        final String name = Messages.ReplaceAction_2;
        this.getOperationRunner().enqueue(name, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ArrayList toUndo = new ArrayList(localChanges.size());
                toUndo.addAll(localChanges);
                try {
                    WarnUndoUser problemHandler = new WarnUndoUser(shell, name, true);
                    FileSystemCore.getSharingManager().getLocalChangeManager().undoChanges(toUndo.toArray(new ILocalChange[toUndo.size()]), IRepositoryResolver.EXISTING_SHARED, (UndoDilemmaHandler)problemHandler, (IProgressMonitor)progress.newChild(100));
                }
                finally {
                    progress.done();
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        List list = ((IStructuredSelection)selection).toList();
        Set[] result = ComponentSyncUtil.filter((Collection)list, (Class[])new Class[]{ILocalChange.class, Object.class});
        if (result[0].size() != 0 && result[1].size() == 0) {
            this.localChanges = result[0];
            action.setEnabled(true);
        } else {
            this.localChanges = Collections.emptySet();
            action.setEnabled(false);
        }
    }
}

