/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.ui.changes.RenameChangeSetUtil;
import com.ibm.team.filesystem.ui.changes.dialogs.EditCommentDialog;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RenameChangeSetAction
extends AbstractActionDelegate {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        IChangeSetHandle changeSet = (IChangeSetHandle)Adapters.getAdapter((Object)selection.getFirstElement(), IChangeSetHandle.class);
        if (changeSet == null) {
            ChangeSetWrapper wrapper = (ChangeSetWrapper)((Object)Adapters.getAdapter((Object)selection.getFirstElement(), ChangeSetWrapper.class));
            if (wrapper != null) {
                changeSet = wrapper.getChangeSet();
            } else {
                return;
            }
        }
        final ITeamRepository repo = (ITeamRepository)changeSet.getOrigin();
        IChangeSet cachedChangeSet = (IChangeSet)repo.itemManager().getSharedItemIfKnown((IItemHandle)changeSet);
        String currentComment = "";
        if (cachedChangeSet != null) {
            currentComment = cachedChangeSet.getComment();
            if (RenameChangeSetUtil.ownerIsLoggedIn(repo, cachedChangeSet, true, this.getOperationRunner()) != 0) {
                return;
            }
        }
        final IChangeSetHandle finalChangeSet = changeSet;
        EditCommentDialog dialog = new EditCommentDialog(shell, currentComment){

            @Override
            protected void saveOnOk(String value) {
                RenameChangeSetAction.this.rename(shell, repo, finalChangeSet, value);
            }
        };
        dialog.open();
    }

    private void rename(Shell shell, final ITeamRepository repo, final IChangeSetHandle set, final String comment) {
        this.getOperationRunner().enqueue(Messages.RenameChangeSetAction_1, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                IChangeSet changeSet = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)set, 0, (IProgressMonitor)progress.newChild(1));
                if (RenameChangeSetUtil.ownerIsLoggedIn(repo, changeSet, true, RenameChangeSetAction.this.getOperationRunner()) == 0) {
                    try {
                        SCMPlatform.getWorkspaceManager((ITeamRepository)repo).setComment(set, comment, (IProgressMonitor)progress.newChild(1));
                    }
                    catch (TeamRepositoryException e) {
                        Throwable cause = e.getCause();
                        if (cause != null && cause instanceof ConnectionException) {
                            RenameChangeSetUtil.showConnectionRefusedDialog();
                        }
                        throw e;
                    }
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean containsSourceChangeSet = false;
        Object[] objectArray = ((IStructuredSelection)selection).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ChangeSetWrapper && ((ChangeSetWrapper)((Object)o)).isSourceChangeSet()) {
                containsSourceChangeSet = true;
                break;
            }
            ++n2;
        }
        action.setEnabled(!containsSourceChangeSet);
    }
}

