/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.changes.dialogs.ActivityDeleteDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RemoveSuspendedActivityAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Set[] result = ComponentSyncUtil.filter((Collection)selection.toList(), (Class[])new Class[]{ISuspendedRemoteActivity.class});
        RemoveSuspendedActivityAction.removeRemoteActivity(shell, this.getOperationRunner(), result[0]);
    }

    public static void removeRemoteActivity(Shell shell, IOperationRunner runner, final Collection<ISuspendedRemoteActivity> activities) {
        ActivityDeleteDialog deleteDialog = new ActivityDeleteDialog(shell, activities, 2);
        if (deleteDialog.open() != 0) {
            return;
        }
        final String name = Messages.RemoveSuspendedActivityAction_0;
        runner.enqueue(name, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                try {
                    monitor.beginTask(name, activities.size());
                    for (IWorkspaceSyncContext wsc : ComponentSyncUtil.getWorkspaceContexts((Collection)activities)) {
                        IWorkspaceConnection wc = wsc.getLocal();
                        Set toSuspend = ComponentSyncUtil.filter((Collection)activities, (IWorkspaceSyncContext)wsc);
                        List changeSetHandles = ComponentSyncUtil.getChangeSetHandles((Collection)toSuspend);
                        wc.removeSuspended((Collection)changeSetHandles, (IProgressMonitor)new SubProgressMonitor(monitor, toSuspend.size()));
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }
}

