/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.rcp.ui.internal.util.PropertyChangeNotifier;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.labelProviders.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.MixedTypeComparator;
import com.ibm.team.repository.rcp.ui.internal.viewers.Query;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class RefreshSandboxDialog
extends TrayDialog {
    private final AbstractSetWithListeners<ISandbox> sandboxes;
    private final SelectedItems selection = new SelectedItems();
    private SimpleTreeViewer viewer;
    private final String title;

    public RefreshSandboxDialog(Shell parentShell, final ISandbox sandbox, String title) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
        this.sandboxes = new AbstractSetWithListeners<ISandbox>(){

            protected Collection<ISandbox> computeElements() {
                return Collections.singletonList(sandbox);
            }
        };
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setSize(600, 400);
        Rectangle shellBounds = newShell.getParent().getBounds();
        Point dialogSize = newShell.getSize();
        newShell.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
    }

    public Collection<IShareable> getShareables() {
        return this.selection.getSelectedShareables();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 0);
        label.setText(Messages.RefreshSandboxDialog_0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        this.viewer = this.createViewer(composite);
        this.viewer.getTree().addListener(13, new Listener(){

            public void handleEvent(final Event event) {
                if (event.detail == 32) {
                    BusyIndicator.showWhile((Display)event.display, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TreeItem item = (TreeItem)event.item;
                            Object data = item.getData();
                            if (data instanceof FileStorageItem) {
                                RefreshSandboxDialog.this.updateSelection((FileStorageItem)data, item.getChecked());
                            }
                            if (data instanceof ISandbox) {
                                RefreshSandboxDialog.this.updateSelection((ISandbox)data, item.getChecked());
                            }
                        }
                    });
                }
            }
        });
        this.viewer.setInput(this.sandboxes);
        final IPropertyChangeListener sandboxSelectionListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                RefreshSandboxDialog.this.updateCheckStateForSandboxSelection(RefreshSandboxDialog.this.selection.isSandboxSelected);
            }
        };
        this.selection.addPropertyChangeListener(sandboxSelectionListener);
        final ISetChangeListener selectedItemListener = new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                RefreshSandboxDialog.this.updateCheckState(event.diff);
            }
        };
        this.selection.getSelectedItems().addSetChangeListener(selectedItemListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RefreshSandboxDialog.this.selection.removePropertyChangeListener(sandboxSelectionListener);
                RefreshSandboxDialog.this.selection.getSelectedItems().removeSetChangeListener(selectedItemListener);
            }
        });
        this.updateCheckStateForSandboxSelection(this.selection.isSandboxSelected);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.dialog_refreshsandbox");
        return composite;
    }

    protected void updateCheckStateForSandboxSelection(boolean isSandboxSelected) {
        TreeItem[] items;
        TreeItem[] treeItemArray = items = this.getTree().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem sandboxItem = treeItemArray[n2];
            sandboxItem.setChecked(isSandboxSelected || !this.selection.getSelectedItems().isEmpty());
            sandboxItem.setGrayed(!isSandboxSelected && !this.selection.getSelectedItems().isEmpty());
            ++n2;
        }
        this.updateEnablement();
    }

    void updateCheckState(SetDiff diff) {
        this.removeChecksForItems(diff.getRemovals());
        this.addChecksForItems(diff.getAdditions());
        this.updateEnablement();
    }

    private void updateEnablement() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(!this.selection.isEmpty());
        }
    }

    private void addChecksForItems(Set additions) {
        TreeItem[] items;
        TreeItem[] treeItemArray = items = this.getTree().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem sandboxItem = treeItemArray[n2];
            this.addChecksForItems(sandboxItem, additions);
            ++n2;
        }
    }

    private void addChecksForItems(TreeItem parentItem, Set additions) {
        TreeItem[] items = parentItem.getItems();
        boolean childChecked = false;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            FileStorageItem fileItem = this.toFileStorageItem(treeItem);
            if (fileItem != null) {
                if (additions.contains(fileItem)) {
                    treeItem.setChecked(true);
                    treeItem.setGrayed(false);
                } else {
                    HashSet children = new HashSet();
                    for (Object child : additions) {
                        FileStorageItem fsi;
                        if (!(child instanceof FileStorageItem) || !fileItem.isParentOf(fsi = (FileStorageItem)child)) continue;
                        children.add(child);
                    }
                    if (!children.isEmpty()) {
                        this.addChecksForItems(treeItem, children);
                    }
                }
            }
            if (treeItem.getChecked()) {
                childChecked = true;
            }
            ++n2;
        }
        if (childChecked) {
            parentItem.setChecked(true);
            parentItem.setGrayed(true);
        }
    }

    protected final Tree getTree() {
        return this.viewer.getTree();
    }

    private void removeChecksForItems(Set removals) {
        TreeItem[] items;
        if (removals.isEmpty()) {
            return;
        }
        TreeItem[] treeItemArray = items = this.getTree().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem sandboxItem = treeItemArray[n2];
            this.removeChecksForItems(sandboxItem, removals);
            ++n2;
        }
    }

    private void removeChecksForItems(TreeItem parentItem, Collection removals) {
        TreeItem[] items = parentItem.getItems();
        boolean allGone = true;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            FileStorageItem item = this.toFileStorageItem(treeItem);
            if (item != null) {
                if (removals.contains(item)) {
                    treeItem.setChecked(false);
                    treeItem.setGrayed(false);
                } else {
                    this.recursiveRemoveChecksForItems(treeItem, item, removals);
                }
            }
            if (treeItem.getChecked()) {
                allGone = false;
            }
            ++n2;
        }
        if (allGone) {
            parentItem.setChecked(false);
            parentItem.setGrayed(false);
        }
    }

    private FileStorageItem toFileStorageItem(TreeItem treeItem) {
        Object data = treeItem.getData();
        if (data instanceof FileStorageItem) {
            return (FileStorageItem)data;
        }
        return null;
    }

    protected void recursiveRemoveChecksForItems(TreeItem parentItem, FileStorageItem parent, Collection removals) {
        HashSet<FileStorageItem> children = new HashSet<FileStorageItem>();
        for (Object child : removals) {
            FileStorageItem childItem;
            if (!(child instanceof FileStorageItem) || !parent.isParentOf(childItem = (FileStorageItem)child)) continue;
            children.add(childItem);
        }
        if (!children.isEmpty()) {
            this.removeChecksForItems(parentItem, children);
        }
    }

    void updateSelection(ISandbox data, boolean checked) {
        this.selection.setSelection(data, checked);
    }

    void updateSelection(FileStorageItem item, boolean checked) {
        this.selection.setSelection(item, checked);
    }

    protected SimpleTreeViewer createViewer(Composite composite) {
        Tree tree = new Tree(composite, 2848);
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 200).applyTo((Control)tree);
        SimpleTreeViewer viewer = new SimpleTreeViewer(tree, this.createContentProvider());
        viewer.setSorter(this.createSorter());
        viewer.setLabelProvider(this.createLabelProvider());
        return viewer;
    }

    private Comparator createSorter() {
        return new MixedTypeComparator().put(ISandbox.class, (Comparator)new Comparator<ISandbox>(){

            @Override
            public int compare(ISandbox o1, ISandbox o2) {
                return o1.getRoot().toOSString().compareToIgnoreCase(o2.getRoot().toOSString());
            }
        }).put(FileStorageItem.class, (Comparator)new Comparator<FileStorageItem>(){

            @Override
            public int compare(FileStorageItem o1, FileStorageItem o2) {
                return o1.getDisplayString().compareToIgnoreCase(o2.getDisplayString());
            }
        });
    }

    private IViewerLabelProvider createLabelProvider() {
        return new SandboxTreeLabelProvider();
    }

    private ITreeProvider createContentProvider() {
        return new SandboxTreeProvider();
    }

    private static class FileStorageItem {
        private final IFileStorage fileStorage;
        private final ResourceType type;
        private final boolean isShareRoot;

        public FileStorageItem(IFileStorage fileStorage, ResourceType type, boolean isShareRoot) {
            this.fileStorage = fileStorage;
            this.type = type;
            this.isShareRoot = isShareRoot;
        }

        public ResourceType getType() {
            return this.type;
        }

        public String getName() {
            return this.fileStorage.getName();
        }

        public List<FileStorageItem> getChildren(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ArrayList<FileStorageItem> children = new ArrayList<FileStorageItem>();
                if (this.type.equals((Object)ResourceType.FOLDER)) {
                    Collection fsc = this.fileStorage.getChildren(true, (IProgressMonitor)progress.newChild(50));
                    progress.setWorkRemaining(fsc.size());
                    for (IFileStorage fs : fsc) {
                        ResourceType resourceType = fs.getResourceType((IProgressMonitor)progress.newChild(1));
                        children.add(new FileStorageItem(fs, resourceType, false));
                    }
                }
                return children;
            }
            catch (FileSystemException e) {
                throw new InvocationTargetException(e);
            }
        }

        public String getDisplayString() {
            if (this.isShareRoot) {
                return this.fileStorage.getShareable().getLocalPath().toString();
            }
            return this.fileStorage.getName();
        }

        public IShareable getShareable() {
            return this.fileStorage.getShareable();
        }

        public int hashCode() {
            return this.fileStorage.getShareable().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileStorageItem other = (FileStorageItem)obj;
            return !(this.fileStorage == null ? other.fileStorage != null : !this.fileStorage.getShareable().equals((Object)other.fileStorage.getShareable()));
        }

        public boolean isParentOf(FileStorageItem item) {
            return this.getShareable().getFullPath().isPrefixOf(item.getShareable().getFullPath());
        }
    }

    private class FileStorageItemQuery
    extends Query<FileStorageItem> {
        private final FileStorageItem item;

        public FileStorageItemQuery(FileStorageItem item) {
            super((IOperationRunner)new JobRunner(true));
            this.item = item;
        }

        public String getName() {
            return this.item.getName();
        }

        public List<FileStorageItem> computeResult(IProgressMonitor monitor) throws InvocationTargetException {
            return this.item.getChildren(monitor);
        }
    }

    private class SandboxTreeLabelProvider
    extends BaseLabelProvider {
        private SandboxTreeLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof ISandbox) {
                ISandbox sandbox = (ISandbox)element;
                label.setText(sandbox.getRoot().toOSString());
                label.setImage(this.getImage(UiPlugin.getFileSystemImageDescriptor(null)));
            }
            if (element instanceof FileStorageItem) {
                FileStorageItem item = (FileStorageItem)element;
                label.setText(item.getDisplayString());
                label.setImage(this.getImageForItem(item));
            }
        }

        private Image getImageForItem(FileStorageItem item) {
            ResourceType type = item.getType();
            if (type == null || type.equals((Object)ResourceType.FOLDER)) {
                return this.getImage(UiPlugin.getFileSystemImageDescriptor(null));
            }
            if (type.equals((Object)ResourceType.FILE)) {
                return this.getImage(UiPlugin.getFileSystemImageDescriptor(item.getName()));
            }
            return this.getImage(ImagePool.SYMBOLIC_LINK);
        }
    }

    private class SandboxTreeProvider
    implements ITreeProvider {
        private SandboxTreeProvider() {
        }

        public ISetWithListeners getChildren(Object element) {
            FileStorageItem item;
            ResourceType type;
            if (element instanceof ISetWithListeners) {
                return (ISetWithListeners)element;
            }
            if (element instanceof ISandbox) {
                ISandbox sandbox = (ISandbox)element;
                return new ShareQuery(sandbox);
            }
            if (element instanceof FileStorageItem && (type = (item = (FileStorageItem)element).getType()) != null && type.equals((Object)ResourceType.FOLDER)) {
                return new FileStorageItemQuery(item);
            }
            return null;
        }
    }

    private static class SelectedFileStorageItems
    extends AbstractSetWithListeners<FileStorageItem> {
        private Set<FileStorageItem> selectedItems = new HashSet<FileStorageItem>();

        private SelectedFileStorageItems() {
        }

        protected Collection<FileStorageItem> computeElements() {
            return this.selectedItems;
        }

        public void removeAll() {
            HashSet<FileStorageItem> removed = new HashSet<FileStorageItem>();
            removed.addAll(this.selectedItems);
            this.selectedItems.clear();
            this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), removed));
        }

        public void add(FileStorageItem item) {
            HashSet<FileStorageItem> removed = new HashSet<FileStorageItem>();
            Iterator<FileStorageItem> iterator = this.selectedItems.iterator();
            while (iterator.hasNext()) {
                FileStorageItem other = iterator.next();
                if (!other.isParentOf(item) && !item.isParentOf(other)) continue;
                iterator.remove();
                removed.add(other);
            }
            this.selectedItems.add(item);
            this.fireSetChange(Diffs.createSetDiff(Collections.singleton(item), removed));
        }

        public void remove(FileStorageItem item) {
            HashSet<FileStorageItem> removed = new HashSet<FileStorageItem>();
            Iterator<FileStorageItem> iterator = this.selectedItems.iterator();
            while (iterator.hasNext()) {
                FileStorageItem other = iterator.next();
                if (!item.isParentOf(other) && !item.equals(other)) continue;
                iterator.remove();
                removed.add(other);
            }
            this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), removed));
        }
    }

    private static class SelectedItems
    extends PropertyChangeNotifier {
        private boolean isSandboxSelected = true;
        private final SelectedFileStorageItems selectedItems = new SelectedFileStorageItems();
        public static final String SANDBOX_SELECTION_PROPERTY = "SandboxSelectionProperty";

        private SelectedItems() {
        }

        public Collection<IShareable> getSelectedShareables() {
            if (this.isSandboxSelected) {
                return Collections.emptyList();
            }
            if (!this.selectedItems.isEmpty()) {
                ArrayList<IShareable> result = new ArrayList<IShareable>();
                Iterator iterator = this.selectedItems.iterator();
                while (iterator.hasNext()) {
                    FileStorageItem item = (FileStorageItem)iterator.next();
                    result.add(item.getShareable());
                }
                return result;
            }
            return null;
        }

        public void setSelection(ISandbox sandbox, boolean checked) {
            this.selectedItems.removeAll();
            this.isSandboxSelected = checked;
            this.firePropertyChange(SANDBOX_SELECTION_PROPERTY, !checked, checked);
        }

        public void setSelection(FileStorageItem item, boolean checked) {
            if (this.isSandboxSelected) {
                this.isSandboxSelected = false;
            }
            if (checked) {
                this.selectedItems.add(item);
            } else {
                this.selectedItems.remove(item);
            }
        }

        public SelectedFileStorageItems getSelectedItems() {
            return this.selectedItems;
        }

        public boolean isEmpty() {
            return this.selectedItems.isEmpty() && !this.isSandboxSelected;
        }
    }

    private class ShareQuery
    extends Query<FileStorageItem> {
        private final ISandbox sandbox;

        public ShareQuery(ISandbox sandbox) {
            super((IOperationRunner)new JobRunner(true));
            this.sandbox = sandbox;
        }

        public String getName() {
            return this.sandbox.getRoot().toOSString();
        }

        public List<FileStorageItem> computeResult(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IShare[] allShares = this.sandbox.allShares((IProgressMonitor)progress.newChild(50));
                ArrayList<FileStorageItem> children = new ArrayList<FileStorageItem>();
                progress.setWorkRemaining(allShares.length);
                IShare[] iShareArray = allShares;
                int n = allShares.length;
                int n2 = 0;
                while (n2 < n) {
                    IShare share = iShareArray[n2];
                    IShareable shareable = share.getShareable();
                    IFileStorage fs = ((Shareable)shareable).getFileStorage();
                    ResourceType resourceType = fs.getResourceType((IProgressMonitor)progress.newChild(1));
                    children.add(new FileStorageItem(fs, resourceType, true));
                    ++n2;
                }
                return children;
            }
            catch (FileSystemException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

