/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Trace;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.OfflineManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.RefreshSandboxDialog;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RefreshSandboxAction
extends Action
implements IMenuCreator,
ICopyFileAreaListener,
IPropertyChangeListener {
    private MenuManager menuManager;
    private Action findRemoteChangesAndSandboxes;
    private Action findRemoteChangesAction;
    private IOperationRunner runner;
    private final Shell shell;
    private IPreferenceStore prefStore;

    public RefreshSandboxAction(Shell shell, IOperationRunner runner) {
        this.shell = shell;
        this.runner = runner;
        this.prefStore = UiPlugin.getDefault().getPreferenceStore();
        this.prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setText(Messages.LocalWorkspaceChangesView_5);
        this.setImageDescriptor(this.getRefreshIcon());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "com.ibm.team.filesystem.ide.ui.action_refreshpendingchanges");
        this.createLocalChangesAction();
        this.createRemoteChangesAction();
        this.setMenuCreator(this);
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        sharingManager.addListener((ICopyFileAreaListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("prefs_pending_changes_refresh_action".equals(property)) {
            this.setImageDescriptor(this.getRefreshIcon());
            this.setToolTipText(this.getToolTipText());
        }
    }

    public ImageDescriptor getRefreshIcon() {
        ImageDescriptor icon = ImagePool.REFRESH_ICON;
        String prefValue = this.prefStore.getString("prefs_pending_changes_refresh_action");
        if (prefValue.equals("SANDBOXES") && FileSystemCore.getSharingManager().getRegisteredSandboxes().size() != 0) {
            icon = ImagePool.REFRESH_SANDBOX_ENABLED_ICON;
        }
        return icon;
    }

    public String getToolTipText() {
        String tooltipText = Messages.LocalWorkspaceChangesView_4;
        String prefValue = this.prefStore.getString("prefs_pending_changes_refresh_action");
        if (prefValue.equals("SANDBOXES") && FileSystemCore.getSharingManager().getRegisteredSandboxes().size() != 0) {
            int count = FileSystemCore.getSharingManager().getRegisteredSandboxes().size();
            tooltipText = count > 1 ? Messages.RefreshSandboxAction_FindAllLocalChanges : Messages.RefreshSandboxAction_0;
        }
        return tooltipText;
    }

    private void createRemoteChangesAction() {
        this.findRemoteChangesAction = new Action(Messages.RefreshSandboxAction_FindAllRemoteChanges){

            public void run() {
                List<ITeamRepository> repos = Arrays.asList(FileSystemResourcesPlugin.getComponentSyncModel().getTeamRepositories());
                RefreshSandboxAction.this.runner.enqueue(Messages.LocalWorkspaceChangesView_1, (Operation)new RepositoryOperation(repos){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                        RefreshSandboxAction.this.refreshRemoteChanges(monitor, problems);
                    }
                });
            }
        };
        this.findRemoteChangesAction.setActionDefinitionId("com.ibm.team.filesystem.ide.ui.command.findAllRemoteChanges");
        this.findRemoteChangesAction.setImageDescriptor(ImagePool.REFRESH_ICON);
    }

    private void refreshRemoteChanges(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
        long start = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
        try {
            try {
                IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
                IWorkspaceSyncContext[] workspaceSyncContexts = model.getWorkspaceSyncContexts();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + workspaceSyncContexts.length));
                problems.setProblemSummary(Messages.LocalWorkspaceChangesView_2, Messages.LocalWorkspaceChangesView_3);
                OfflineManager.getInstance().requestUpdate();
                model.refresh(true, (IProgressMonitor)progress.newChild(1));
                IWorkspaceSyncContext[] iWorkspaceSyncContextArray = workspaceSyncContexts;
                int n = workspaceSyncContexts.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkspaceSyncContext workspaceSyncContext = iWorkspaceSyncContextArray[n2];
                    ActiveWorkspaceManager manager = ActiveWorkspaceManager.getInstance();
                    if (manager.isWorkspaceTracked((IWorkspaceHandle)workspaceSyncContext.getLocal().getResolvedWorkspace())) {
                        workspaceSyncContext.getLocal().refresh((IProgressMonitor)progress.newChild(1));
                    } else if (ModelUtil.TRACE_REFRESH) {
                        ModelUtil.log((String)String.format("%s.refreshRemoteChanges(): Skipping untracked workspace %s", ((Object)((Object)this)).getClass().getSimpleName(), workspaceSyncContext.getLocal().getResolvedWorkspace().getName()));
                    }
                    ++n2;
                }
            }
            catch (FileSystemException e) {
                problems.reportProblem(FileSystemStatusUtil.getStatusFor((Throwable)e));
                if (Trace.LOG_ELAPSED_TIME) {
                    Trace.endTrace((long)start, (String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":refreshRemoteChanges()"));
                }
            }
        }
        finally {
            if (Trace.LOG_ELAPSED_TIME) {
                Trace.endTrace((long)start, (String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":refreshRemoteChanges()"));
            }
        }
    }

    private static void refreshLocalChangesFiltered(ISandbox[] sandboxes, ILocalChangeManager.RefreshType traversalType, ISharingManager sharingManager, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + sandboxes.length));
        ActiveWorkspaceManager manager = ActiveWorkspaceManager.getInstance();
        ArrayList allShares = new ArrayList();
        ArrayList<IShare> nonExcludedShares = new ArrayList<IShare>();
        ISandbox[] iSandboxArray = sandboxes;
        int n = sandboxes.length;
        int n2 = 0;
        while (n2 < n) {
            IShare[] shares;
            ISandbox sandbox = iSandboxArray[n2];
            IShare[] iShareArray = shares = sandbox.allShares((IProgressMonitor)progress.newChild(1));
            int n3 = shares.length;
            int n4 = 0;
            while (n4 < n3) {
                boolean isUntrackedWorkspace;
                IShare share = iShareArray[n4];
                IContextHandle contextHandle = share.getSharingDescriptor().getConnectionHandle();
                boolean bl = isUntrackedWorkspace = contextHandle instanceof IWorkspaceHandle && !manager.isWorkspaceTracked((IWorkspaceHandle)contextHandle);
                if (!isUntrackedWorkspace) {
                    SharingManager.getInstance().remindSandboxListener(share);
                    nonExcludedShares.add(share);
                }
                ++n4;
            }
            allShares.addAll(nonExcludedShares);
            ++n2;
        }
        if (!allShares.isEmpty()) {
            sharingManager.getLocalChangeManager().refreshChanges(allShares.toArray(new IShare[allShares.size()]), traversalType, true, (IProgressMonitor)progress.newChild(100));
        }
    }

    private void createLocalChangesAction() {
        this.findRemoteChangesAndSandboxes = new Action(Messages.RefreshSandboxAction_FindAllLocalChanges){

            public void run() {
                RefreshSandboxAction.this.runner.enqueue(Messages.RefreshSandboxAction_FindAllLocalChangeTsask, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                        ISharingManager sharingManager = FileSystemCore.getSharingManager();
                        Collection sandboxes = sharingManager.getRegisteredSandboxes();
                        if (!sandboxes.isEmpty()) {
                            boolean refreshEclipseResources;
                            RefreshSandboxAction.refreshLocalChangesFiltered(sandboxes.toArray(new ISandbox[sandboxes.size()]), (refreshEclipseResources = UiPlugin.getDefault().getPluginPreferences().getBoolean("prefs_skip_eclipse_resources_whenrefreshing")) ? ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN : ILocalChangeManager.RefreshType.OPTIMIZED_TRAVERSAL, sharingManager, (IProgressMonitor)progress.newChild(1));
                        }
                        RefreshSandboxAction.this.refreshRemoteChanges((IProgressMonitor)progress.newChild(1), problems);
                    }
                });
            }
        };
        this.findRemoteChangesAndSandboxes.setActionDefinitionId("com.ibm.team.filesystem.ide.ui.command.findAllLocalChanges");
        this.findRemoteChangesAndSandboxes.setImageDescriptor(ImagePool.REFRESH_SANDBOX_ENABLED_ICON);
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
            this.menuManager = null;
        }
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        sharingManager.removeListener((ICopyFileAreaListener)this);
        if (this.prefStore != null) {
            this.prefStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public Menu getMenu(Control parent) {
        Menu menu;
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
            menu = this.menuManager.createContextMenu(parent);
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    MenuItem[] items = menu.getItems();
                    if (items.length <= 1) {
                        return;
                    }
                    int count = FileSystemCore.getSharingManager().getRegisteredSandboxes().size();
                    int defaultItem = 0;
                    String prefValue = RefreshSandboxAction.this.prefStore.getString("prefs_pending_changes_refresh_action");
                    if (prefValue.equals("SANDBOXES") && count != 0) {
                        defaultItem = 1;
                    }
                    menu.setDefaultItem(items[defaultItem]);
                    String text = count > 1 ? Messages.RefreshSandboxAction_FindAllLocalChanges : Messages.RefreshSandboxAction_0;
                    items[1].setText(text);
                    items[1].setEnabled(count != 0);
                }
            });
            this.menuManager.add((IAction)this.findRemoteChangesAction);
            this.menuManager.add((IAction)this.findRemoteChangesAndSandboxes);
            ISharingManager sharingManager = FileSystemCore.getSharingManager();
            Collection sandboxes = sharingManager.getRegisteredSandboxes();
            if (sandboxes.size() > 0) {
                this.menuManager.add((IContributionItem)new Separator());
                this.addSandboxesToMenu(this.menuManager, sandboxes);
            }
            this.menuManager.update(true);
        } else {
            menu = this.menuManager.getMenu();
        }
        return menu;
    }

    private void addSandboxesToMenu(MenuManager menuManager, Collection<ISandbox> sandboxes) {
        ArrayList<ISandbox> result = new ArrayList<ISandbox>(sandboxes);
        Collections.sort(result, new Comparator<ISandbox>(){

            @Override
            public int compare(ISandbox o1, ISandbox o2) {
                return o1.getRoot().toOSString().compareTo(o2.getRoot().toOSString());
            }
        });
        for (ISandbox sandbox : result) {
            menuManager.add(this.createRefreshActionFor(sandbox));
        }
    }

    private IAction createRefreshActionFor(final ISandbox sandbox) {
        String title = NLS.bind((String)Messages.RefreshSandboxAction_FindLocalChangesInSandbox, (Object)sandbox.getRoot().toOSString());
        Action refresh = new Action(title){

            public void run() {
                final Collection<IShareable> shareables = RefreshSandboxAction.this.promptForSharablesToRefresh(sandbox, Messages.RefreshSandboxAction_1);
                if (shareables == null) {
                    return;
                }
                RefreshSandboxAction.this.runner.enqueue(NLS.bind((String)Messages.RefreshSandboxAction_FindLocalChangesInSandboxTask, (Object)sandbox.getRoot().toOSString()), (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        if (shareables.isEmpty()) {
                            RefreshSandboxAction.this.refreshSandbox(sandbox, monitor);
                        } else {
                            RefreshSandboxAction.this.refreshShareables(shareables, monitor);
                        }
                    }
                });
            }
        };
        return refresh;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void run() {
        Action actionToRun = this.findRemoteChangesAction;
        String prefValue = this.prefStore.getString("prefs_pending_changes_refresh_action");
        if (prefValue.equals("SANDBOXES") && FileSystemCore.getSharingManager().getRegisteredSandboxes().size() != 0) {
            actionToRun = this.findRemoteChangesAndSandboxes;
        }
        actionToRun.run();
    }

    void reset() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
            this.menuManager = null;
        }
        this.setImageDescriptor(this.getRefreshIcon());
        this.setToolTipText(this.getToolTipText());
    }

    public void change(ICopyFileAreaEvent[] events) {
        boolean reset = false;
        ICopyFileAreaEvent[] iCopyFileAreaEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ICopyFileAreaEvent event = iCopyFileAreaEventArray[n2];
            if (event.getReason() == 9 || event.getReason() == 10) {
                reset = true;
                break;
            }
            ++n2;
        }
        if (reset) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RefreshSandboxAction.this.reset();
                }
            });
        }
    }

    Collection<IShareable> promptForSharablesToRefresh(ISandbox sandbox, String title) {
        RefreshSandboxDialog dialog = new RefreshSandboxDialog(this.getShell(), sandbox, title);
        int result = dialog.open();
        if (result == 0) {
            return dialog.getShareables();
        }
        return null;
    }

    private void refreshShareables(Collection<IShareable> shareables, IProgressMonitor monitor) throws FileSystemException {
        long start = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        boolean refreshEclipseResources = UiPlugin.getDefault().getPluginPreferences().getBoolean("prefs_skip_eclipse_resources_whenrefreshing");
        ((LocalChangeManager)sharingManager.getLocalChangeManager()).refreshChanges(shareables, refreshEclipseResources ? ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN : ILocalChangeManager.RefreshType.OPTIMIZED_TRAVERSAL, monitor);
        if (Trace.LOG_ELAPSED_TIME) {
            Trace.endTrace((long)start, (String)(String.valueOf(((Object)((Object)this)).getClass().getName()) + ":refreshShareables()"));
        }
    }

    void refreshSandbox(ISandbox sandbox, IProgressMonitor monitor) throws FileSystemException {
        long start = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        boolean refreshEclipseResources = UiPlugin.getDefault().getPluginPreferences().getBoolean("prefs_skip_eclipse_resources_whenrefreshing");
        sharingManager.getLocalChangeManager().refreshChanges(new ISandbox[]{sandbox}, refreshEclipseResources ? ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN : ILocalChangeManager.RefreshType.OPTIMIZED_TRAVERSAL, monitor);
        if (Trace.LOG_ELAPSED_TIME) {
            Trace.endTrace((long)start, (String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":refreshSandbox()"));
        }
    }

    public Shell getShell() {
        return this.shell;
    }
}

