/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ConfigurationChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenShareableInExternalCompareOperation;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnOpenInExternalCompare;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenShareableInExternalCompareAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        IStructuredSelection ss = this.getStructuredSelection();
        action.setEnabled(this.isValidSelection(ss));
    }

    public void run(Shell shell, IWorkbenchPage workbenchPage, IStructuredSelection ss) {
        if (this.isValidSelection(ss)) {
            Object element = ss.getFirstElement();
            ILocalChange localChange = (ILocalChange)element;
            this.openInExternalTool(localChange);
        }
    }

    public boolean isValidSelection(IStructuredSelection ss) {
        Object element;
        boolean isValidSelection = false;
        if (ss.size() == 1 && (element = ss.getFirstElement()) instanceof ILocalChange) {
            ILocalChange localChange = (ILocalChange)element;
            isValidSelection = ComponentSyncUtil.isRemoteContentAccessible((ILocalChange)localChange);
        }
        return isValidSelection;
    }

    public void openInExternalTool(final ILocalChange localChange) {
        OpenInExternalCompareAction.ExternalCommandLinePreference externalCommandLinePreference = OpenInExternalCompareAction.get2WayLocalCompareCommandLine();
        final String commandLine = externalCommandLinePreference.getCommandLine();
        if (commandLine == null) {
            Shell shell = this.getContext().getShell();
            externalCommandLinePreference.openPreferenceDialog(shell, null);
            return;
        }
        this.getOperationRunner().enqueue(Messages.OpenShareableInExternalCompareAction_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IShareable shareable = localChange.getShareable();
                ArrayList problemsFound = new ArrayList();
                boolean getVersionIds = OpenInCompareAction.showVersionIdForCompare();
                ConfigurationChange configChange = ConfigurationChangeFactory.createChange(Collections.singletonList(localChange), (boolean)true, problemsFound, (boolean)getVersionIds, (IProgressMonitor)progress.newChild(10));
                for (IStatus toReport : problemsFound) {
                    problems.reportProblem(toReport);
                }
                FileChange diff = (FileChange)configChange.getChanges().iterator().next();
                FileState remoteFileState = diff.getInitial();
                OpenShareableInExternalCompareOperation externalCompareOperation = new OpenShareableInExternalCompareOperation(commandLine, shareable, remoteFileState, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(OpenShareableInExternalCompareAction.this.getContext()));
                externalCompareOperation.run(monitor);
            }
        });
    }
}

