/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.ide.ui.internal.compare.DelegatingSaveableCompareEditorInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ConfigurationChangeFactory;
import com.ibm.team.filesystem.ui.changes.actions.ICompareEditorListener;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.actions.CompareWithAction;
import com.ibm.team.internal.filesystem.ui.util.EditorUtils;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.OperationManager;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;

public class OpenShareableInCompareAction
extends Action {
    private IWorkbenchPage workbenchPage;
    private ISelection selection;
    private ICompareEditorListener listener;
    private IReusableEditor editor;

    public OpenShareableInCompareAction(IWorkbenchPage workbenchPage, ISelection selection, IReusableEditor editor, ICompareEditorListener listener) {
        this.workbenchPage = workbenchPage;
        this.selection = selection;
        this.editor = editor;
        this.listener = listener;
    }

    public OpenShareableInCompareAction(IWorkbenchPage page, ISelection selection) {
        this(page, selection, null, null);
    }

    public void run() {
        StructuredSelection ss;
        Object firstElement;
        if (this.selection instanceof StructuredSelection && (firstElement = (ss = (StructuredSelection)this.selection).getFirstElement()) instanceof ILocalChange) {
            ILocalChange change = (ILocalChange)firstElement;
            if (!OpenShareableInCompareAction.isOpenable(change)) {
                return;
            }
            OpenShareableInCompareAction.openInEditor(UIContext.createPageContext((Shell)this.workbenchPage.getWorkbenchWindow().getShell(), (IWorkbenchPage)this.workbenchPage), change, this.editor, this.listener);
        }
    }

    public static void openInEditor(UIContext context, ILocalChange change) {
        OpenShareableInCompareAction.openInEditor(context, change, null, null);
    }

    public static void openInEditor(final UIContext context, final ILocalChange change, final IReusableEditor editor, final ICompareEditorListener listener) {
        final Display d = Display.getCurrent();
        OperationManager.runOperation((String)Messages.OpenShareableInCompareAction_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ArrayList problemsFound = new ArrayList();
                boolean getVersionIds = OpenInCompareAction.showVersionIdForCompare();
                ConfigurationChange configChange = ConfigurationChangeFactory.createChange(Collections.singletonList(change), (boolean)true, problemsFound, (boolean)getVersionIds, (IProgressMonitor)progress.newChild(85));
                if (!problemsFound.isEmpty()) {
                    for (IStatus toReport : problemsFound) {
                        problems.reportProblem(toReport);
                    }
                }
                if (configChange.getChanges().isEmpty()) {
                    return;
                }
                FileChange diff = (FileChange)configChange.getChanges().iterator().next();
                final FileState before = diff.getInitial();
                IShareable after = null;
                String customLabel = null;
                IShareable shareable = change.getShareable();
                if (shareable != null) {
                    ResourceType resourceType = shareable.getResourceType((IProgressMonitor)progress.newChild(5));
                    if (resourceType == ResourceType.FILE || resourceType == ResourceType.SYMBOLIC_LINK || OpenShareableInCompareAction.isOpenable(change)) {
                        after = shareable;
                        customLabel = CompareWithAction.computeRemoteFilename(after.getLocalPath().getName(), shareable.getShare((IProgressMonitor)progress.newChild(10)).getSharingDescriptor().getConnectionName());
                    } else {
                        customLabel = CompareWithAction.computeRemoteFilename(change.getPath().getName(), shareable.getShare((IProgressMonitor)progress.newChild(10)).getSharingDescriptor().getConnectionName());
                    }
                }
                final IShareable finalShareable = after;
                final String customRightLabel = customLabel;
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page = context.getPage();
                        CompareEditorInput editorInput = DelegatingSaveableCompareEditorInput.createInput(page, finalShareable, before, customRightLabel, false);
                        if (editor != null) {
                            IEditorReference editorReference = EditorUtils.getEditorReference((IEditorPart)editor, page);
                            if (editorReference != null && !editorReference.isDirty() && !editorReference.isPinned()) {
                                OpenInCompareAction.openCompareEditor(editorInput, page, editor);
                            } else {
                                OpenInCompareAction.openCompareEditor(editorInput, page);
                            }
                        } else {
                            OpenInCompareAction.openCompareEditor(editorInput, page);
                        }
                        if (listener != null) {
                            listener.created(editorInput);
                            IReusableEditor newEditor = (IReusableEditor)page.findEditor((IEditorInput)editorInput);
                            listener.setEditor(newEditor);
                        }
                    }
                });
            }
        });
    }

    public static boolean isOpenable(ILocalChange change) {
        IShareable shareable = change.getShareable();
        if (shareable == null) {
            return false;
        }
        return change.getTarget() instanceof IFileItemHandle || change.getTarget() instanceof ISymbolicLinkHandle || OpenShareableInCompareAction.hasPropertyChange(change) || OpenShareableInCompareAction.isCreationOrDeletion(change);
    }

    private static boolean isCreationOrDeletion(ILocalChange change) {
        return (change.getType() & 4) > 0 || (change.getType() & 2) > 0;
    }

    private static boolean hasPropertyChange(ILocalChange change) {
        return (change.getType() & 0x20) > 0;
    }
}

