/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeNode;
import com.ibm.team.filesystem.ui.editor.PartUtil;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.changenodes.IChangeNode;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenRemoteFileAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        IRemoteChangeSummary change;
        Object element = this.getElement(selection);
        if (element == null) {
            return;
        }
        FileItemWrapper fileWrapper = null;
        if (element instanceof FileItemWrapper) {
            fileWrapper = (FileItemWrapper)((Object)element);
        }
        if (element instanceof IRemoteChangeSummary) {
            change = (IRemoteChangeSummary)element;
            IChangeSummary changeSummary = change.getChangeSummary();
            if (changeSummary == null || !(changeSummary.afterState() instanceof IFileItemHandle)) {
                return;
            }
            IActivitySource source = change.getActivity().getActivitySource();
            IWorkspaceConnection wc = change.getActivity().getActivitySource().getModel().getTeamPlace(source);
            IComponent component = change.getActivity().getActivitySource().getModel().getComponent();
            IFileItemHandle fileItem = (IFileItemHandle)changeSummary.afterState();
            fileWrapper = new FileItemWrapper(new StateId((IItemHandle)fileItem), change.getAfterPath(), (ItemNamespace)WorkspaceNamespace.create((IWorkspaceConnection)wc, (IComponentHandle)component));
        } else if (element instanceof ILocalChange) {
            change = (ILocalChange)element;
            IFileItemHandle fileItem = (IFileItemHandle)change.getTarget();
            IComponentSyncContext context = ComponentSyncUtil.getContext((IComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel(), (ILocalChange)change);
            fileWrapper = new FileItemWrapper(new StateId((IItemHandle)fileItem), change.getPath().getName(), (ItemNamespace)WorkspaceNamespace.create((IWorkspaceConnection)context.getOutgoingTeamPlace(), (IComponentHandle)change.getComponent()));
        } else if (element instanceof ChangeNode) {
            ChangeNode node = (ChangeNode)element;
            ItemNamespace namespace = node.getNamespace();
            IVersionableHandle state = node.getState();
            if (state != null) {
                fileWrapper = new FileItemWrapper(new StateId(state.getItemType(), state.getItemId(), state.getStateId()), "", namespace);
            }
        }
        if (fileWrapper == null) {
            return;
        }
        final FileItemWrapper fiw = fileWrapper;
        PartSiteJobRunner runner = page != null ? new PartSiteJobRunner(page.getActivePart().getSite(), true) : new JobRunner(true);
        runner.enqueue(Messages.OpenRemoteFileAction_0, (Operation)new RepositoryOperation(ComponentSyncUtil.getTeamRepository((Object)element)){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                JFaceUtils.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PartUtil.openEditor(OpenRemoteFileAction.this.getContext(), fiw);
                    }
                });
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.getElement((IStructuredSelection)selection) != null);
    }

    private Object getElement(IStructuredSelection selection) {
        if (selection.size() == 1) {
            IChangeNode node;
            IVersionableHandle handle;
            IRemoteChangeSummary change;
            Object element = selection.getFirstElement();
            if (element instanceof IRemoteChangeSummary && (change = (IRemoteChangeSummary)element).getChangeSummary() != null && change.getChangeSummary().afterState() instanceof IFileItemHandle) {
                return element;
            }
            if (element instanceof ILocalChange && (handle = (change = (ILocalChange)element).getTarget()) instanceof IFileItemHandle) {
                return element;
            }
            if (element instanceof FileItemWrapper) {
                return element;
            }
            if (element instanceof ChangeNode && (node = (IChangeNode)element).getState() != null) {
                return element;
            }
        }
        return null;
    }
}

