/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ide.ui.internal.editorfactory.SandboxEditorInputFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.ui.editor.EditorTuple;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

public class OpenLocalFileAction
extends AbstractActionDelegate {
    private Set[] selection;

    public void run(final Shell shell, final IWorkbenchPage page, IStructuredSelection xyzzy) {
        if (this.selection == null) {
            return;
        }
        final Set changes = this.selection[0];
        final Set localConflictItems = this.selection[2];
        final Set conflictItems = this.selection[3];
        if (!(changes.isEmpty() && localConflictItems.isEmpty() && conflictItems.isEmpty())) {
            this.getOperationRunner().enqueue(Messages.OpenLocalFileAction_0, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(changes.size() + localConflictItems.size() + conflictItems.size()));
                    final ArrayList<IShareable> shareables = new ArrayList<IShareable>();
                    for (IRemoteChangeSummary change : changes) {
                        IShareable shareable = ComponentSyncUtil.findShareable((IRemoteChangeSummary)change, (IProgressMonitor)progress.newChild(1));
                        if (shareable == null) continue;
                        shareables.add(shareable);
                    }
                    ISharingManager sharingManager = FileSystemCore.getSharingManager();
                    for (ILocalConflictItem item : localConflictItems) {
                        for (IShareable shareable : sharingManager.findShareables(item.getItem(), (IProgressMonitor)progress.newChild(1))) {
                            if (shareable == null) continue;
                            shareables.add(shareable);
                        }
                    }
                    for (IConflictItem conflictItem : conflictItems) {
                        IShareable shareable;
                        shareable = ComponentSyncUtil.findShareable((IAbstractConflictItem)conflictItem, (boolean)true, (IProgressMonitor)progress.newChild(1));
                        if (shareable == null) continue;
                        shareables.add(shareable);
                    }
                    new UIJob(Messages.OpenLocalFileAction_1){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (shareables.isEmpty()) {
                                MessageDialog.openWarning((Shell)shell, (String)Messages.OpenLocalFileAction_2, (String)Messages.OpenLocalFileAction_200);
                                return Status.OK_STATUS;
                            }
                            for (IShareable shareable : shareables) {
                                OpenLocalFileAction.openLocalFile(shell, page, shareable);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            });
        }
        for (ILocalChange change : this.selection[1]) {
            if (change.isType(4)) {
                MessageDialog.openWarning((Shell)shell, (String)Messages.OpenLocalFileAction_6, (String)Messages.OpenLocalFileAction_7);
                return;
            }
            OpenLocalFileAction.openLocalFile(shell, page, change.getShareable());
        }
    }

    public static void openLocalFile(Shell shell, IWorkbenchPage page, IShareable shareable) {
        try {
            if (!shareable.exists((IProgressMonitor)TempHelper.MONITOR)) {
                MessageDialog.openWarning((Shell)shell, (String)Messages.OpenLocalFileAction_2, (String)Messages.OpenLocalFileAction_3);
                return;
            }
        }
        catch (FileSystemException e) {
            MessageDialog.openWarning((Shell)shell, (String)Messages.OpenLocalFileAction_2, (String)e.getMessage());
        }
        EditorTuple tuple = SandboxEditorInputFactory.getInstance().createEditorInput(shell, page, shareable);
        if (tuple == null) {
            return;
        }
        try {
            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)tuple.getEditorInput(), (String)tuple.getEditorId());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)shell, (String)"Could not open editor", (String)NLS.bind((String)"Failed to open editor for {0}", (Object)shareable.getLocalPath().getName()), (IStatus)e.getStatus());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean enable = false;
        this.selection = null;
        List list = ((IStructuredSelection)selection).toList();
        Set[] result = ComponentSyncUtil.filter((Collection)list, (Class[])new Class[]{IRemoteChangeSummary.class, ILocalChange.class, ILocalConflictItem.class, IConflictItem.class, Object.class});
        if (result[4].isEmpty()) {
            boolean allFiles = true;
            if (!result[0].isEmpty()) {
                for (IRemoteChangeSummary remoteChange : result[0]) {
                    if (remoteChange.getItem() instanceof IFileItemHandle) continue;
                    allFiles = false;
                    break;
                }
            }
            if (!result[1].isEmpty()) {
                for (ILocalChange localChange : result[1]) {
                    if (localChange.getTarget() instanceof IFileItemHandle) continue;
                    allFiles = false;
                    break;
                }
            }
            if (!result[3].isEmpty()) {
                for (ILocalConflictItem localConflict : result[2]) {
                    if (localConflict.getItem() instanceof IFileItemHandle) continue;
                    allFiles = false;
                    break;
                }
            }
            if (!result[3].isEmpty()) {
                for (IConflictItem conflictChange : result[3]) {
                    if (conflictChange.getItem() instanceof IFileItemHandle) continue;
                    allFiles = false;
                    break;
                }
            }
            this.selection = result;
            enable = allFiles;
        }
        if (action != null) {
            action.setEnabled(enable);
        }
    }
}

