/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ConfigurationChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FileChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.compare.ExternalCompareToolManager;
import com.ibm.team.filesystem.rcp.core.internal.compare.IExternalCompareTool;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenFileItemInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenShareableInExternalCompareOperation;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnOpenInExternalCompare;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class OpenInExternalCompareAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        IStructuredSelection ss = this.getStructuredSelection();
        action.setEnabled(this.isValidSelection(ss));
    }

    public void run(Shell shell, IWorkbenchPage workbenchPage, IStructuredSelection ss) {
        if (this.isValidSelection(ss)) {
            IRemoteChangeSummary change = (IRemoteChangeSummary)ss.getFirstElement();
            this.openInExternalTool(change);
        }
    }

    public boolean isValidSelection(IStructuredSelection ss) {
        if (ss.size() != 1) {
            return false;
        }
        Object element = ss.getFirstElement();
        if (element instanceof IRemoteChangeSummary) {
            IRemoteChangeSummary remoteChangeSummary = (IRemoteChangeSummary)element;
            IChangeSummary changeSummary = remoteChangeSummary.getChangeSummary();
            return changeSummary != null && !(changeSummary.item() instanceof IFolderHandle);
        }
        return false;
    }

    public void openInExternalTool(final IRemoteChangeSummary change) {
        final IChangeSummary changeSummary = change.getChangeSummary();
        final Shell shell = this.getContext().getShell();
        if (changeSummary.isChangeType(8) && !changeSummary.isChangeType(4)) {
            String oldPath = OpenInExternalCompareAction.getPathString(changeSummary, true);
            String newPath = OpenInExternalCompareAction.getPathString(changeSummary, false);
            MessageDialog.openInformation((Shell)shell, (String)Messages.OpenInExternalCompareAction_0, (String)NLS.bind((String)Messages.OpenInExternalCompareAction_1, (Object)newPath, (Object)oldPath));
            return;
        }
        this.getOperationRunner().enqueue(Messages.OpenInExternalCompareAction_2, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                boolean remoteCompare;
                String commandLine;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IShareable[] shareables = new IShareable[1];
                try {
                    IVersionableHandle remote;
                    IShareable shareable = ComponentSyncUtil.findShareable((IRemoteChangeSummary)change, (IProgressMonitor)progress.newChild(5));
                    IChangeSet changeSet = change.getActivity().getChangeSet();
                    if (shareable != null && change instanceof IOutgoingRemoteChangeSummary && changeSet != null && changeSet.isActive() && (remote = shareable.getRemote((IProgressMonitor)progress.newChild(5))) != null && remote.sameStateId((IItemHandle)changeSummary.afterState()) && shareable.getResourceType((IProgressMonitor)progress.newChild(5)) == ResourceType.FILE) {
                        shareables[0] = shareable;
                    }
                }
                catch (FileSystemException shareable) {
                }
                catch (TeamRepositoryException shareable) {
                    // empty catch block
                }
                if ((commandLine = OpenInExternalCompareAction.this.getCommandLine(shell, remoteCompare = shareables[0] == null)) == null) {
                    return;
                }
                progress.setWorkRemaining(100);
                boolean getVersionIds = OpenInCompareAction.showVersionIdForCompare();
                if (shareables[0] != null) {
                    FileState fileState = FileChangeFactory.createFromRemoteSummary((IRemoteChangeSummary)change, (boolean)false, (boolean)getVersionIds, (IProgressMonitor)progress.newChild(20)).getInitial();
                    OpenShareableInExternalCompareOperation externalCompareOperation = new OpenShareableInExternalCompareOperation(commandLine, shareables[0], fileState, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(OpenInExternalCompareAction.this.getContext()));
                    externalCompareOperation.run((IProgressMonitor)progress.newChild(80));
                } else {
                    Collection changes = ConfigurationChangeFactory.createChangeForSummaries(Collections.singletonList(change), (boolean)false, (boolean)getVersionIds, (IProgressMonitor)progress.newChild(20)).getChanges();
                    if (changes.isEmpty()) {
                        SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)shell, null, (String)Messages.OpenInExternalCompareAction_3);
                            }
                        });
                        return;
                    }
                    FileChange fileChange = (FileChange)changes.iterator().next();
                    FileState leftFileState = fileChange.getFinal();
                    String leftLabel = Messages.OpenInExternalCompareAction_4;
                    String rightLabel = NLS.bind((String)Messages.OpenInExternalCompareAction_5, (Object)change.getActivity().getActivitySource().getName());
                    FileState rightFileState = fileChange.getInitial();
                    OpenFileItemInExternalCompareOperation externalCompareOperation = new OpenFileItemInExternalCompareOperation(commandLine, leftFileState, leftLabel, rightFileState, rightLabel, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(OpenInExternalCompareAction.this.getContext()));
                    externalCompareOperation.run((IProgressMonitor)progress.newChild(80));
                }
            }
        });
    }

    private String getCommandLine(final Shell shell, boolean remoteCompare) {
        final ExternalCommandLinePreference externalCommandLinePreference = remoteCompare ? OpenInExternalCompareAction.get2WayRemoteCompareCommandLine() : OpenInExternalCompareAction.get2WayLocalCompareCommandLine();
        String commandLine = externalCommandLinePreference.getCommandLine();
        if (commandLine == null) {
            SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!shell.isDisposed()) {
                        externalCommandLinePreference.openPreferenceDialog(shell, null);
                    }
                }
            });
            return null;
        }
        return commandLine;
    }

    public static ExternalCommandLinePreference get2WayLocalCompareCommandLine() {
        IExternalCompareTool toolUsed;
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        boolean preferenceError = false;
        String errorTitle = null;
        String errorMessage = null;
        String nameOfToolUsed = store.getString("external_compare_previously_selected_compare_tool");
        if (nameOfToolUsed == null || nameOfToolUsed.equals("") || ExternalCompareToolManager.getToolByName((String)nameOfToolUsed) == null) {
            preferenceError = true;
            errorTitle = Messages.OpenShareableInExternalCompareAction_PREFERENCE_DESCRIPTION_0;
            errorMessage = Messages.OpenShareableInExternalCompareAction_PREFERENCE_DESCRIPTION_1;
        }
        if ((toolUsed = ExternalCompareToolManager.getToolByName((String)nameOfToolUsed)) != null) {
            if (!preferenceError && !toolUsed.doesToolSupport2WayCompare()) {
                preferenceError = true;
                errorTitle = Messages.OpenShareableInExternalCompareAction_PREFERENCE_DESCRIPTION_2;
                errorMessage = Messages.OpenShareableInExternalCompareAction_PREFERENCE_DESCRIPTION_3;
            }
            String executablePath = store.getString(toolUsed.get2WayCompareExecutablePathPrefKey());
            if (!preferenceError && executablePath == null || executablePath.equals("") || !new File(executablePath).exists()) {
                preferenceError = true;
                errorTitle = Messages.OpenShareableInExternalCompareAction_PREFERENCE_DESCRIPTION_4;
                errorMessage = Messages.OpenShareableInExternalCompareAction_PREFERENCE_DESCRIPTION_5;
            }
            String localCompareArgs = store.getString(toolUsed.get2WayLocalCompareArgumentsPrefKey());
            if (!preferenceError && localCompareArgs == null || localCompareArgs.length() <= 0) {
                preferenceError = true;
                errorTitle = Messages.OpenShareableInExternalCompareAction_PREFERENCE_DESCRIPTION_6;
                errorMessage = Messages.OpenShareableInExternalCompareAction_PREFERENCE_DESCRIPTION_7;
            }
        }
        if (preferenceError) {
            return new ExternalCommandLinePreference(errorTitle, errorMessage);
        }
        return new ExternalCommandLinePreference("\"" + store.getString(toolUsed.get2WayCompareExecutablePathPrefKey()) + "\" " + store.getString(toolUsed.get2WayLocalCompareArgumentsPrefKey()));
    }

    public static ExternalCommandLinePreference get2WayRemoteCompareCommandLine() {
        IExternalCompareTool toolUsed;
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        boolean preferenceError = false;
        String errorTitle = null;
        String errorMessage = null;
        String nameOfToolUsed = store.getString("external_compare_previously_selected_compare_tool");
        if (nameOfToolUsed == null || nameOfToolUsed.equals("") || ExternalCompareToolManager.getToolByName((String)nameOfToolUsed) == null) {
            preferenceError = true;
            errorTitle = Messages.OpenInExternalCompareAction_PREFERENCE_DESCRIPTION_0;
            errorMessage = Messages.OpenInExternalCompareAction_PREFERENCE_DESCRIPTION_1;
        }
        if ((toolUsed = ExternalCompareToolManager.getToolByName((String)nameOfToolUsed)) != null) {
            if (!preferenceError && !toolUsed.doesToolSupport2WayCompare()) {
                preferenceError = true;
                errorTitle = Messages.OpenInExternalCompareAction_PREFERENCE_DESCRIPTION_2;
                errorMessage = Messages.OpenInExternalCompareAction_PREFERENCE_DESCRIPTION_3;
            }
            String executablePath = store.getString(toolUsed.get2WayCompareExecutablePathPrefKey());
            if (!preferenceError && executablePath == null || executablePath.equals("") || !new File(executablePath).exists()) {
                preferenceError = true;
                errorTitle = Messages.OpenInExternalCompareAction_PREFERENCE_DESCRIPTION_4;
                errorMessage = Messages.OpenInExternalCompareAction_PREFERENCE_DESCRIPTION_5;
            }
            String argCheck = store.getString(toolUsed.get2WayRemoteCompareArgumentsPrefKey());
            if (!preferenceError && argCheck == null || argCheck.length() <= 0) {
                preferenceError = true;
                errorTitle = Messages.OpenInExternalCompareAction_PREFERENCE_DESCRIPTION_6;
                errorMessage = Messages.OpenInExternalCompareAction_PREFERENCE_DESCRIPTION_7;
            }
        }
        if (preferenceError) {
            return new ExternalCommandLinePreference(errorTitle, errorMessage);
        }
        return new ExternalCommandLinePreference("\"" + store.getString(toolUsed.get2WayCompareExecutablePathPrefKey()) + "\" " + store.getString(toolUsed.get2WayRemoteCompareArgumentsPrefKey()));
    }

    public static ExternalCommandLinePreference get3WayCommandLine() {
        IExternalCompareTool toolUsed;
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        boolean preferenceError = false;
        String errorTitle = null;
        String errorMessage = null;
        String nameOfToolUsed = store.getString("external_compare_previously_selected_compare_tool");
        if (nameOfToolUsed == null || nameOfToolUsed.equals("") || ExternalCompareToolManager.getToolByName((String)nameOfToolUsed) == null) {
            preferenceError = true;
            errorTitle = Messages.OpenConflictInExternalCompareAction_PREFERENCE_DESCRIPTION_0;
            errorMessage = Messages.OpenConflictInExternalCompareAction_PREFERENCE_DESCRIPTION_1;
        }
        if ((toolUsed = ExternalCompareToolManager.getToolByName((String)nameOfToolUsed)) != null) {
            if (!preferenceError && !toolUsed.doesToolSupport3WayMerge()) {
                preferenceError = true;
                errorTitle = Messages.OpenConflictInExternalCompareAction_PREFERENCE_DESCRIPTION_2;
                errorMessage = Messages.OpenConflictInExternalCompareAction_PREFERENCE_DESCRIPTION_3;
            }
            String executablePath = store.getString(toolUsed.get3WayMergeExecutablePathPrefKey());
            if (!preferenceError && executablePath == null || executablePath.equals("") || !new File(executablePath).exists()) {
                preferenceError = true;
                errorTitle = Messages.OpenConflictInExternalCompareAction_PREFERENCE_DESCRIPTION_4;
                errorMessage = Messages.OpenConflictInExternalCompareAction_PREFERENCE_DESCRIPTION_5;
            }
            String argCheck = store.getString(toolUsed.get3WayMergeArgumentsPrefKey());
            if (!preferenceError && argCheck == null || argCheck.length() <= 0) {
                preferenceError = true;
                errorTitle = Messages.OpenConflictInExternalCompareAction_PREFERENCE_DESCRIPTION_6;
                errorMessage = Messages.OpenConflictInExternalCompareAction_PREFERENCE_DESCRIPTION_7;
            }
        }
        if (preferenceError) {
            return new ExternalCommandLinePreference(errorTitle, errorMessage);
        }
        return new ExternalCommandLinePreference("\"" + store.getString(toolUsed.get3WayMergeExecutablePathPrefKey()) + "\" " + store.getString(toolUsed.get3WayMergeArgumentsPrefKey()));
    }

    public static String getPathString(IChangeSummary changeSummary, boolean beforeState) {
        String[] pathHint;
        if (beforeState) {
            pathHint = changeSummary.getPathHint();
        } else {
            pathHint = changeSummary.getNewPathHint();
            if (pathHint == null) {
                pathHint = changeSummary.getPathHint();
            }
        }
        StringBuffer path = new StringBuffer();
        int i = 0;
        while (i < pathHint.length) {
            path.append('/').append(pathHint[i]);
            ++i;
        }
        return path.toString();
    }

    public static class ExternalCommandLinePreference {
        private String commandLine;
        private String errorTitle;
        private String errorMessage;

        public ExternalCommandLinePreference(String commandLine) {
            this.commandLine = commandLine;
        }

        public ExternalCommandLinePreference(String errorTitle, String errorMessage) {
            this.errorTitle = errorTitle;
            this.errorMessage = errorMessage;
        }

        public String getCommandLine() {
            return this.commandLine;
        }

        public void openPreferenceDialog(Shell shell) {
            this.openPreferenceDialog(shell, null);
        }

        public void openPreferenceDialog(Shell shell, Object data) {
            boolean result = MessageDialog.openConfirm((Shell)shell, (String)this.errorTitle, (String)this.errorMessage);
            if (result) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"com.ibm.team.filesystem.ide.ui.internal.preferences.ExternalCompareToolsPreferencePage", null, (Object)data);
                dialog.open();
            }
        }
    }
}

