/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.ide.ui.internal.compare.DelegatingSaveableCompareEditorInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ConfigurationChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FileChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.filesystem.rcp.ui.internal.compare.AbstractCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStateComputer;
import com.ibm.team.filesystem.ui.changes.actions.ICompareEditorListener;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.actions.CompareWithAction;
import com.ibm.team.internal.filesystem.ui.util.EditorUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class OpenInCompareAction
extends Action {
    private static final String TEAM_UI_BUNDLE_ID = "org.eclipse.team.ui";
    private static final String REUSE_OPEN_COMPARE_EDITORS_PREFERENCE = "org.eclipse.team.ui.reuse_open_compare_editors";
    private IWorkbenchPage workbenchPage;
    private ISelection selection;
    private ICompareEditorListener listener;
    private IReusableEditor editor;

    public OpenInCompareAction(IWorkbenchPage page, ISelection selection, IReusableEditor editor, ICompareEditorListener listener) {
        this.selection = selection;
        this.workbenchPage = page;
        this.editor = editor;
        this.listener = listener;
    }

    public OpenInCompareAction(IWorkbenchPage workbenchPage, ISelection selection) {
        this(workbenchPage, selection, null, null);
    }

    public void run() {
        StructuredSelection ss;
        Object firstElement;
        if (this.selection instanceof StructuredSelection && (firstElement = (ss = (StructuredSelection)this.selection).getFirstElement()) instanceof IRemoteChangeSummary) {
            IWorkbenchPart part;
            final IRemoteChangeSummary change = (IRemoteChangeSummary)firstElement;
            if (!OpenInCompareAction.isOpenable(change)) {
                return;
            }
            IChangeSummary changeSummary = change.getChangeSummary();
            if (changeSummary.isChangeType(8) && !changeSummary.isChangeType(4)) {
                String oldPath = OpenInCompareAction.getPathString(changeSummary, true);
                String newPath = OpenInCompareAction.getPathString(changeSummary, false);
                MessageBox messageBox = new MessageBox(this.workbenchPage.getActivePart().getSite().getShell(), 34);
                messageBox.setText(Messages.OpenInCompareAction_0);
                messageBox.setMessage(NLS.bind((String)Messages.OpenInCompareAction_1, (Object)newPath, (Object)oldPath));
                messageBox.open();
                return;
            }
            ITeamRepository repo = change.getActivity().getActivitySource().getModel().localTeamRepository();
            JobRunner runner = new JobRunner(true);
            if (this.workbenchPage != null && (part = this.workbenchPage.getActivePart()) != null) {
                runner = new PartSiteJobRunner(part.getSite(), true);
            }
            final Display display = Display.getCurrent();
            runner.enqueue(Messages.OpenInCompareAction_2, (Operation)new RepositoryOperation(repo){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    CompareEditorInput input;
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    IShareable shareable = OpenInCompareAction.this.findShareableWithMatchingRemote(change, progress.newChild(10));
                    if (shareable != null) {
                        boolean getVersionIds = FileStateComputer.showVersionIdForCompare();
                        FileState fileState = FileChangeFactory.createFromRemoteSummary((IRemoteChangeSummary)change, (boolean)false, (boolean)getVersionIds, (IProgressMonitor)progress.newChild(90)).getInitial();
                        String customRightLabel = null;
                        IWorkspaceConnection connection = change.getActivity().getActivitySource().getModel().getWorkspaceSyncContext().getLocal();
                        if (connection != null) {
                            customRightLabel = CompareWithAction.computeRemoteFilenameWithVersionId(fileState.getPath().getName(), OpenInCompareAction.this.getVersionId(fileState), connection.getName());
                        }
                        input = DelegatingSaveableCompareEditorInput.createInput(OpenInCompareAction.this.workbenchPage, shareable, fileState, customRightLabel, false);
                    } else {
                        boolean getVersionIds = FileStateComputer.showVersionIdForCompare();
                        Collection changes = ConfigurationChangeFactory.createChangeForSummaries(Collections.singletonList(change), (boolean)false, (boolean)getVersionIds, (IProgressMonitor)progress.newChild(90)).getChanges();
                        if (!changes.isEmpty()) {
                            FileChange fileChange = (FileChange)changes.iterator().next();
                            FileChangeEditorInput fileChangeEditorInput = FileChangeEditorInput.createFrom((FileChange)fileChange);
                            fileChangeEditorInput.setLabels(Messages.OpenInCompareAction_5, NLS.bind((String)Messages.OpenInCompareAction_6, (Object)change.getActivity().getActivitySource().getName()));
                            input = fileChangeEditorInput;
                        } else {
                            input = null;
                        }
                    }
                    SWTUtil.greedyExec((Display)display, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (input != null) {
                                OpenInCompareAction.openCompareEditor(input, OpenInCompareAction.this.workbenchPage, OpenInCompareAction.this.editor);
                                if (OpenInCompareAction.this.listener != null) {
                                    OpenInCompareAction.this.listener.created(input);
                                    OpenInCompareAction.this.editor = (IReusableEditor)OpenInCompareAction.this.workbenchPage.findEditor((IEditorInput)input);
                                    OpenInCompareAction.this.listener.setEditor(OpenInCompareAction.this.editor);
                                }
                            } else {
                                MessageDialog.openInformation((Shell)OpenInCompareAction.this.workbenchPage.getWorkbenchWindow().getShell(), null, (String)Messages.OpenInCompareAction_4);
                            }
                        }
                    });
                }
            });
        }
    }

    private String getVersionId(FileState fileState) {
        IPreferenceStore store = RcpUiPlugin.getDefault().getPreferenceStore();
        boolean showLongIdentifier = store.getBoolean("pref_show_version_identifiers_repository_id");
        if (OpenInCompareAction.showVersionIdForCompare() && fileState != null) {
            if (showLongIdentifier) {
                return fileState.getLongVersionId();
            }
            return fileState.getShortVersionId();
        }
        return "";
    }

    private IShareable findShareableWithMatchingRemote(IRemoteChangeSummary change, SubMonitor progress) {
        progress.setWorkRemaining(10);
        IChangeSet changeSet = change.getActivity().getChangeSet();
        if (change instanceof IOutgoingRemoteChangeSummary && changeSet != null && changeSet.isActive()) {
            try {
                IVersionableHandle remote;
                IShareable shareable = ComponentSyncUtil.findShareable((IRemoteChangeSummary)change, (IProgressMonitor)progress.newChild(5));
                if (shareable != null && (remote = shareable.getRemote((IProgressMonitor)progress.newChild(5))) != null && remote.sameStateId((IItemHandle)change.getChangeSummary().afterState())) {
                    return shareable;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static IReusableEditor openCompareEditor(CompareEditorInput input, IWorkbenchPage page) {
        IReusableEditor editor = OpenInCompareAction.findReusableEditor(input, page);
        OpenInCompareAction.internalOpenCompareEditor(input, page, editor);
        return editor;
    }

    public static IReusableEditor findReusableEditor(CompareEditorInput input, IWorkbenchPage page) {
        IEditorPart part;
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IReusableEditor re;
            part = editorRefs[i].getEditor(false);
            if (part instanceof IReusableEditor && input.equals((re = (IReusableEditor)part).getEditorInput())) {
                return re;
            }
            ++i;
        }
        if (OpenInCompareAction.isReuseOpenEditor()) {
            i = 0;
            while (i < editorRefs.length) {
                part = editorRefs[i].getEditor(false);
                if (part != null && part instanceof IReusableEditor && !part.isDirty() && OpenInCompareAction.isCompatibleInput(part.getEditorInput())) {
                    return (IReusableEditor)part;
                }
                ++i;
            }
        }
        return null;
    }

    private static boolean isCompatibleInput(IEditorInput editorInput) {
        return editorInput instanceof AbstractCompareEditorInput || editorInput instanceof DelegatingSaveableCompareEditorInput;
    }

    private static boolean isReuseOpenEditor() {
        return new ScopedPreferenceStore((IScopeContext)new InstanceScope(), TEAM_UI_BUNDLE_ID).getBoolean(REUSE_OPEN_COMPARE_EDITORS_PREFERENCE);
    }

    public static void openCompareEditor(CompareEditorInput input, IWorkbenchPage page, IReusableEditor editor) {
        if (editor == null) {
            editor = OpenInCompareAction.findReusableEditor(input, page);
        }
        OpenInCompareAction.internalOpenCompareEditor(input, page, editor);
    }

    private static void internalOpenCompareEditor(CompareEditorInput input, IWorkbenchPage page, IReusableEditor editor) {
        if (page == null || input == null) {
            return;
        }
        if (editor != null) {
            IEditorReference editorReference = EditorUtils.getEditorReference((IEditorPart)editor, page);
            if (editorReference != null && !editorReference.isDirty() && !editorReference.isPinned()) {
                IEditorInput otherInput = editor.getEditorInput();
                if (otherInput.equals(input)) {
                    OpenInCompareAction.showEditor(page, editor);
                } else {
                    CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)editor);
                    OpenInCompareAction.showEditor(page, editor);
                }
            } else {
                CompareUI.openCompareEditorOnPage((CompareEditorInput)input, (IWorkbenchPage)page);
            }
        } else {
            CompareUI.openCompareEditorOnPage((CompareEditorInput)input, (IWorkbenchPage)page);
        }
    }

    private static void showEditor(final IWorkbenchPage page, final IReusableEditor editor) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (OpenStrategy.activateOnOpen()) {
                    page.activate((IWorkbenchPart)editor);
                } else {
                    page.bringToTop((IWorkbenchPart)editor);
                }
            }
        });
    }

    public static IPath getPath(IChangeSummary changeSummary, boolean beforeState) {
        return Path.fromOSString((String)OpenInCompareAction.getPathString(changeSummary, beforeState));
    }

    public static String getPathString(IChangeSummary changeSummary, boolean beforeState) {
        String[] pathHint;
        if (beforeState) {
            pathHint = changeSummary.getPathHint();
        } else {
            pathHint = changeSummary.getNewPathHint();
            if (pathHint == null) {
                pathHint = changeSummary.getPathHint();
            }
        }
        StringBuffer path = new StringBuffer();
        int i = 0;
        while (i < pathHint.length) {
            path.append('/').append(pathHint[i]);
            ++i;
        }
        return path.toString();
    }

    public static boolean isOpenable(IRemoteChangeSummary change) {
        IChangeSummary changeSummary = change.getChangeSummary();
        return changeSummary != null && (!(changeSummary.item() instanceof IFolderHandle) || changeSummary.isModificationChange(16) || changeSummary.isChangeType(1) || changeSummary.isChangeType(2));
    }

    public static boolean showVersionIdForCompare() {
        IPreferenceStore store = RcpUiPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("pref_show_version_identifiers_compare");
    }
}

