/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenFileItemInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnOpenInExternalCompare;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenFileChangeInExternalCompareAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        IStructuredSelection ss = this.getStructuredSelection();
        action.setEnabled(this.isValidSelection(ss));
    }

    public void run(Shell shell, IWorkbenchPage workbenchPage, IStructuredSelection ss) {
        if (this.isValidSelection(ss)) {
            Object element = ss.getFirstElement();
            this.openInExternalTool((FileChange)element);
        }
    }

    public boolean isValidSelection(IStructuredSelection ss) {
        FileChange fileChange;
        Object element;
        boolean isValidSelection = false;
        if (ss.size() == 1 && (element = ss.getFirstElement()) instanceof FileChange && !(fileChange = (FileChange)element).isFolder()) {
            isValidSelection = true;
        }
        return isValidSelection;
    }

    private void openInExternalTool(final FileChange fileChange) {
        final OpenInExternalCompareAction.ExternalCommandLinePreference externalCommandLinePreference = OpenInExternalCompareAction.get2WayRemoteCompareCommandLine();
        final String commandLine = externalCommandLinePreference.getCommandLine();
        if (commandLine == null) {
            final Shell shell = this.getContext().getShell();
            SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!shell.isDisposed()) {
                        externalCommandLinePreference.openPreferenceDialog(shell, null);
                    }
                }
            });
            return;
        }
        this.getOperationRunner().enqueue(Messages.OpenInExternalCompareAction_2, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                FileState leftFileState = fileChange.getFinal();
                FileState rightFileState = fileChange.getInitial();
                String leftLabel = " " + Messages.OpenAction_0;
                String rightLabel = " " + Messages.OpenAction_1;
                OpenFileItemInExternalCompareOperation externalCompareOperation = new OpenFileItemInExternalCompareOperation(commandLine, leftFileState, leftLabel, rightFileState, rightLabel, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(OpenFileChangeInExternalCompareAction.this.getContext()));
                externalCompareOperation.run(monitor);
            }
        });
    }
}

