/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenConflictInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnOpenConflictInExternalCompare;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenConflictInExternalCompareAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        IStructuredSelection ss = this.getStructuredSelection();
        action.setEnabled(this.isValidSelection(ss));
    }

    public void run(Shell shell, IWorkbenchPage workbenchPage, IStructuredSelection ss) {
        if (!this.isValidSelection(ss)) {
            return;
        }
        Object element = ss.getFirstElement();
        this.openInExternalTool((IAbstractConflictItem)element);
    }

    public boolean isValidSelection(IStructuredSelection ss) {
        IVersionableHandle target;
        Object element;
        boolean isValidSelection = false;
        IAbstractConflictItem conflict = null;
        if (ss.size() == 1 && (element = ss.getFirstElement()) instanceof IAbstractConflictItem && ((target = (conflict = (IAbstractConflictItem)element).getItem()) instanceof IFileItemHandle || target instanceof ISymbolicLinkHandle)) {
            isValidSelection = true;
        }
        return isValidSelection;
    }

    public void openInExternalTool(final IAbstractConflictItem conflict) {
        OpenInExternalCompareAction.ExternalCommandLinePreference externalCommandLinePreference = OpenInExternalCompareAction.get3WayCommandLine();
        final String commandLine = externalCommandLinePreference.getCommandLine();
        if (commandLine == null) {
            Shell shell = this.getContext().getShell();
            externalCommandLinePreference.openPreferenceDialog(shell, null);
            return;
        }
        this.getOperationRunner().enqueue(Messages.OpenConflictInExternalCompareAction_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                OpenConflictInExternalCompareOperation externalCompareOperation = new OpenConflictInExternalCompareOperation(commandLine, conflict, (OpenInExternalCompareDilemmaHandler)new WarnOpenConflictInExternalCompare(OpenConflictInExternalCompareAction.this.getContext(), conflict));
                externalCompareOperation.run(monitor);
            }
        });
    }
}

