/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.ide.ui.internal.compare.DelegatingSaveableCompareEditorInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.ui.changes.actions.ICompareEditorListener;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;

public class OpenConflictInCompareAction
extends Action {
    private IStructuredSelection selection;
    private ICompareEditorListener listener;
    private final IWorkbenchPage page;
    private IReusableEditor editor;

    public OpenConflictInCompareAction(IWorkbenchPage page, IStructuredSelection selection, IReusableEditor editor, ICompareEditorListener listener) {
        this.page = page;
        this.selection = selection;
        this.editor = editor;
        this.listener = listener;
    }

    public OpenConflictInCompareAction(IWorkbenchPage page, IStructuredSelection selection) {
        this(page, selection, null, null);
    }

    public void run() {
        List list = this.selection.toList();
        if (list.size() != 1) {
            return;
        }
        Object o = list.get(0);
        if (o instanceof IAbstractConflictItem) {
            MessageBox messageBox;
            final IAbstractConflictItem conflict = (IAbstractConflictItem)o;
            if (!OpenConflictInCompareAction.isOpenable(conflict)) {
                return;
            }
            if (conflict.isChangeType(8)) {
                messageBox = new MessageBox(this.page.getActivePart().getSite().getShell(), 34);
                messageBox.setText(Messages.OpenConflictInCompareAction_0);
                messageBox.setMessage(NLS.bind((String)Messages.OpenConflictInCompareAction_1, (Object)conflict.getName(false)));
                messageBox.open();
            }
            if (conflict instanceof IConflictItem && ((IConflictItem)conflict).getItemConflictReport() == null) {
                return;
            }
            if (conflict.getProposedContributorState() == null && conflict.getSelectedContributorState() == null) {
                messageBox = new MessageBox(this.page.getActivePart().getSite().getShell(), 34);
                messageBox.setText(Messages.OpenConflictInCompareAction_4);
                messageBox.setMessage(Messages.OpenConflictInCompareAction_5);
                messageBox.open();
                return;
            }
            new Job(Messages.OpenConflictInCompareAction_6){

                protected IStatus run(IProgressMonitor monitor) {
                    CompareEditorInput input = DelegatingSaveableCompareEditorInput.createInput(OpenConflictInCompareAction.this.page, conflict, false);
                    OpenInCompareAction.openCompareEditor(input, OpenConflictInCompareAction.this.page, OpenConflictInCompareAction.this.editor);
                    OpenConflictInCompareAction.this.editor = (IReusableEditor)OpenConflictInCompareAction.this.page.findEditor((IEditorInput)input);
                    if (OpenConflictInCompareAction.this.listener != null) {
                        OpenConflictInCompareAction.this.listener.created(input);
                        OpenConflictInCompareAction.this.listener.setEditor(OpenConflictInCompareAction.this.editor);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public static IPath getPath(ILogicalChange logicalChange, boolean beforeState) {
        return Path.fromOSString((String)OpenConflictInCompareAction.getPathString(logicalChange, beforeState));
    }

    public static String getPathString(ILogicalChange logicalChange, boolean beforeState) {
        String[] pathHint;
        if (beforeState) {
            pathHint = logicalChange.getPathHint();
        } else {
            pathHint = logicalChange.getNewPathHint();
            if (pathHint == null) {
                pathHint = logicalChange.getPathHint();
            }
        }
        StringBuffer path = new StringBuffer();
        int i = 0;
        while (i < pathHint.length) {
            path.append('/').append(pathHint[i]);
            ++i;
        }
        return path.toString();
    }

    public static boolean isOpenable(IAbstractConflictItem conflict) {
        return conflict.getItem() instanceof IFileItemHandle || conflict.getItem() instanceof ISymbolicLinkHandle || conflict.isModificationChange(16) || conflict.isChangeType(1) || conflict.isChangeType(2);
    }
}

