/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ide.ui.internal.compare.DelegatingSaveableCompareEditorInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.Collection;
import java.util.Set;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenConflictEditorsAction
extends AbstractActionDelegate {
    static int MAX_OPEN = 10;

    public void run(Shell shell, final IWorkbenchPage page, IStructuredSelection selection) {
        final Collection<IConflictItem> conflictItems = OpenConflictEditorsAction.getConflictItems(selection);
        if (conflictItems == null) {
            return;
        }
        PartSiteJobRunner runner = page != null ? new PartSiteJobRunner(page.getActivePart().getSite(), true) : new JobRunner(true);
        runner.enqueue(Messages.OpenConflictEditorsAction_0, (Operation)new RepositoryOperation(ComponentSyncUtil.getTeamRepositories(conflictItems)){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                JFaceUtils.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int n = 0;
                        for (IConflictItem conflictItem : conflictItems) {
                            CompareEditorInput input = DelegatingSaveableCompareEditorInput.createInput(page, (IAbstractConflictItem)conflictItem, false);
                            OpenInCompareAction.openCompareEditor(input, page);
                            if (++n >= MAX_OPEN) break;
                        }
                    }
                });
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        Collection<IConflictItem> conflictItems = OpenConflictEditorsAction.getConflictItems((IStructuredSelection)selection);
        action.setEnabled(conflictItems != null);
        String text = conflictItems != null && conflictItems.size() > MAX_OPEN ? NLS.bind((String)Messages.OpenConflictEditorsAction_OpenFirstConflictEditors, (Object)MAX_OPEN) : Messages.OpenConflictEditorsAction_OpenConflictEditor;
        action.setText(text);
    }

    private static Collection<IConflictItem> getConflictItems(IStructuredSelection selection) {
        IComponentSyncContext context;
        Collection conflictItems;
        Set contexts = ComponentSyncUtil.getContexts((Collection)selection.toList());
        if (contexts.size() == 1 && !(conflictItems = ComponentConflictUtil.getModModConflictItems((IComponentSyncContext)(context = (IComponentSyncContext)contexts.iterator().next()))).isEmpty()) {
            return conflictItems;
        }
        return null;
    }
}

