/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.oslc.OslcLinkWrapper;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.ui.actions.OpenChangeRequestAction;
import com.ibm.team.filesystem.ui.changes.actions.CompareFileChangesAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenConflictInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenShareableInCompareAction;
import com.ibm.team.filesystem.ui.changes.views.zoom.ZoomRootUtil;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.IZoomWorkItemRoot;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetLinkWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.openactions.IWorkbenchRunnable;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.Collections;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object[] elements;
        if (selection.size() == 1) {
            IWorkbenchRunnable genericOpenAction;
            ChangeSetLinkWrapper linkWrapper;
            IItem item;
            Action compareAction;
            IZoomWorkItemRoot workItem;
            Object o = selection.getFirstElement();
            if (o instanceof IZoomWorkItemRoot) {
                workItem = (IZoomWorkItemRoot)o;
                o = (IFileSystemWorkItem)ZoomRootUtil.getAny(workItem.getElements());
            }
            if (o instanceof IFileSystemWorkItem) {
                workItem = (IFileSystemWorkItem)o;
                IWorkbenchRunnable genericOpenAction2 = com.ibm.team.repository.rcp.ui.openactions.OpenAction.getActionFor((Object)(o = workItem.getWorkItem()));
                if (genericOpenAction2 != null) {
                    genericOpenAction2.run(shell, page, (IStructuredSelection)new StructuredSelection(o));
                }
            } else if (o instanceof IRemoteChangeSummary) {
                compareAction = new OpenInCompareAction(page, (ISelection)selection);
                compareAction.run();
            } else if (o instanceof ILocalChange) {
                compareAction = new OpenShareableInCompareAction(page, (ISelection)selection);
                compareAction.run();
            } else if (o instanceof IAbstractConflictItem) {
                compareAction = new OpenConflictInCompareAction(page, selection);
                compareAction.run();
            } else if (o instanceof FileChange) {
                FileChangeEditorInput input = FileChangeEditorInput.createFrom((FileChange)((FileChange)o));
                input.setLabels(Messages.OpenAction_0, Messages.OpenAction_1);
                OpenInCompareAction.openCompareEditor((CompareEditorInput)input, page);
            } else if (o instanceof ChangeSetLinkWrapper && (item = (linkWrapper = (ChangeSetLinkWrapper)((Object)o)).getItem()) != null && (genericOpenAction = com.ibm.team.repository.rcp.ui.openactions.OpenAction.getActionFor((Object)item)) != null) {
                genericOpenAction.run(shell, page, (IStructuredSelection)new StructuredSelection((Object)item));
            }
            if (o instanceof OslcLinkWrapper) {
                OpenChangeRequestAction.open(this.getContext(), Collections.singletonList((OslcLinkWrapper)o));
            }
        }
        if (selection.size() == 2 && (elements = selection.toArray())[0] instanceof IRemoteChangeSummary && elements[1] instanceof IRemoteChangeSummary) {
            IRemoteChangeSummary rcs1 = (IRemoteChangeSummary)elements[0];
            IRemoteChangeSummary rcs2 = (IRemoteChangeSummary)elements[1];
            CompareFileChangesAction.showInCompare(this.getContext(), rcs1, rcs2, true);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object[] elements;
        super.selectionChanged(action, selection);
        boolean enable = false;
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() == 1) {
            Object elt = ss.getFirstElement();
            if (elt instanceof IFileSystemWorkItem) {
                enable = true;
            }
            if (elt instanceof IZoomWorkItemRoot && ((IZoomWorkItemRoot)elt).getWorkItem() != null) {
                enable = true;
            }
            if (elt instanceof IRemoteChangeSummary) {
                IRemoteChangeSummary change = (IRemoteChangeSummary)elt;
                enable = OpenInCompareAction.isOpenable(change);
            }
            if (elt instanceof ILocalChange) {
                enable = OpenShareableInCompareAction.isOpenable((ILocalChange)elt);
            }
            if (elt instanceof IAbstractConflictItem) {
                enable = OpenConflictInCompareAction.isOpenable((IAbstractConflictItem)elt);
            }
            if (elt instanceof FileChange) {
                enable = true;
            }
            if (elt instanceof OslcLinkWrapper) {
                enable = true;
            }
            if (elt instanceof ChangeSetLinkWrapper) {
                enable = true;
            }
        }
        if (ss.size() == 2 && (elements = ss.toArray())[0] instanceof IRemoteChangeSummary && elements[1] instanceof IRemoteChangeSummary) {
            IRemoteChangeSummary rcs1 = (IRemoteChangeSummary)elements[0];
            IRemoteChangeSummary rcs2 = (IRemoteChangeSummary)elements[1];
            enable = rcs1.getItem().sameItemId((IItemHandle)rcs2.getItem()) && rcs1.getItem() instanceof IFileItemHandle && rcs1.getActivity().getActivitySource() == rcs2.getActivity().getActivitySource();
        }
        action.setEnabled(enable);
    }
}

