/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.dialogs.EditCommentDialog;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnUpdateUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class MoveToActivityContributionItem
extends ContributionItem {
    Collection changes;
    MenuItem newActivityItem;
    private Image createChangeSetIcon = null;
    LocalWorkspaceChangesViewLabelProvider labelProvider;
    ILabelDecorator labelDecorator;

    public MoveToActivityContributionItem(LocalWorkspaceChangesViewLabelProvider labelProvider, ILabelDecorator labelDecorator) {
        this.labelProvider = labelProvider;
        this.labelDecorator = labelDecorator;
    }

    public void setSelection(IStructuredSelection selection) {
        this.changes = MoveToActivityContributionItem.getChanges(selection);
    }

    public boolean isNeeded() {
        if (this.changes == null) {
            return false;
        }
        Set contexts = ComponentSyncUtil.getContexts((Collection)this.changes);
        return contexts.size() == 1;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isDirty() {
        return true;
    }

    public void fill(Menu menu, int index) {
        if (this.changes == null) {
            return;
        }
        Set contexts = ComponentSyncUtil.getContexts((Collection)this.changes);
        if (contexts.size() != 1) {
            return;
        }
        final IComponentSyncContext context = (IComponentSyncContext)contexts.iterator().next();
        MenuItem item = new MenuItem(menu, 64, index);
        item.setText(Messages.MoveToActivityContributionItem_0);
        Menu subMenu = new Menu((Decorations)menu.getShell(), 4);
        item.setMenu(subMenu);
        if (this.createChangeSetIcon == null) {
            this.createChangeSetIcon = ImagePool.CREATE_CHANGE.createImage();
        }
        List activities = ComponentSyncUtil.getMoveToActivities((IComponentSyncContext)context, (Collection)this.changes);
        final Shell shell = menu.getShell();
        Listener listener = new Listener(){
            boolean prompt = UiPlugin.getDefault().getPreferenceStore().getBoolean("com.ibm.team.filesystem.ide.ui.prompt_comment_new_change_set");

            public void handleEvent(Event event) {
                EditCommentDialog dialog;
                MenuItem item = (MenuItem)event.widget;
                final IOutgoingRemoteActivity activity = item == MoveToActivityContributionItem.this.newActivityItem ? null : (IOutgoingRemoteActivity)item.getData();
                final String[] comment = new String[]{""};
                if (activity == null && this.prompt && (dialog = new EditCommentDialog(shell, ""){

                    @Override
                    protected void saveOnOk(String value) {
                        comment[0] = value;
                    }
                }).open() != 0) {
                    return;
                }
                Job job = new Job(Messages.MoveToActivityContributionItem_1){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            try {
                                monitor.beginTask(Messages.MoveToActivityContributionItem_2, 100);
                                IOutgoingRemoteActivity newActivity = context.relocate((this).MoveToActivityContributionItem.this.changes, (IRemoteActivity)activity, (UpdateDilemmaHandler)new WarnUpdateUser(shell, this.getName()), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                context.refresh(false, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                if (activity == null && prompt) {
                                    context.setComment((IRemoteActivity)newActivity, comment[0], monitor);
                                }
                            }
                            catch (FileSystemException e) {
                                IStatus iStatus = FileSystemStatusUtil.getStatusFor((Throwable)e);
                                monitor.done();
                                return iStatus;
                            }
                            catch (TeamRepositoryException e) {
                                IStatus iStatus = FileSystemStatusUtil.getStatusFor((Throwable)e);
                                monitor.done();
                                return iStatus;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        };
        int i = 0;
        for (IRemoteActivity activity : activities) {
            ++i;
            MenuItem menuItem = new MenuItem(subMenu, 8);
            menuItem.setText(LocalWorkspaceChangesViewLabelProvider.getLabel(activity));
            Image image = this.labelDecorator.decorateImage(this.labelProvider.getRegularImage(activity), (Object)activity);
            if (image != null) {
                menuItem.setImage(image);
            }
            menuItem.setData((Object)activity);
            menuItem.addListener(13, listener);
        }
        if (i > 0) {
            new MenuItem(subMenu, 2);
        }
        this.newActivityItem = new MenuItem(subMenu, 8);
        this.newActivityItem.setText(Messages.MoveToActivityContributionItem_3);
        this.newActivityItem.addListener(13, listener);
        this.newActivityItem.setImage(this.createChangeSetIcon);
    }

    static Collection getChanges(IStructuredSelection selection) {
        Set changeSummaries;
        if (selection == null) {
            return null;
        }
        Set[] result = ComponentSyncUtil.filter((Collection)selection.toList(), (Class[])new Class[]{IRemoteActivity.class, IOutgoingRemoteChangeSummary.class, Object.class});
        Set set = changeSummaries = result[0].isEmpty() && result[2].isEmpty() ? result[1] : null;
        if (changeSummaries != null) {
            if (changeSummaries.isEmpty()) {
                return null;
            }
            for (IOutgoingRemoteChangeSummary summary : changeSummaries) {
                IRemoteActivity activity = summary.getActivity();
                if (activity.getActivitySource().getModel().isActive(activity)) continue;
                return null;
            }
        }
        return changeSummaries;
    }

    public void dispose() {
        if (this.createChangeSetIcon != null) {
            this.createChangeSetIcon.dispose();
            this.createChangeSetIcon = null;
        }
        super.dispose();
    }
}

